/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.messaging;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.search.spi.reindexer.BulkReindexer;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRelTable;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/segments_entry_reindex"}, service={MessageListener.class})
public class SegmentsEntryReindexMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryReindexMessageListener.class);
    @Reference(target="(indexer.class.name=com.liferay.portal.kernel.model.User)")
    private BulkReindexer _bulkReindexer;
    @Reference(target="(indexer.class.name=com.liferay.portal.kernel.model.User)")
    private Indexer<User> _indexer;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;

    protected void doReceive(Message message) {
        block3: {
            long segmentsEntryId = message.getLong("segmentsEntryId");
            if (segmentsEntryId == 0L) {
                return;
            }
            try {
                Set<Long> newClassPKs = this._getNewClassPKs(segmentsEntryId);
                this._updateDatabase(segmentsEntryId, newClassPKs);
                this._updateIndex(message.getLong("companyId"), segmentsEntryId, newClassPKs);
            }
            catch (PortalException portalException) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)"Unable to index segment members", (Throwable)portalException);
            }
        }
    }

    private Set<Long> _getNewClassPKs(long segmentsEntryId) throws PortalException {
        long[] classPKs = this._segmentsEntryProviderRegistry.getSegmentsEntryClassPKs(segmentsEntryId, -1, -1);
        return SetUtil.fromArray((long[])classPKs);
    }

    private Set<Long> _getOldDatabaseClassPKs(long segmentsEntryId) {
        Iterable iterable = (Iterable)this._segmentsEntryLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Expression[])new Expression[]{SegmentsEntryRelTable.INSTANCE.classPK}).from((Table)SegmentsEntryRelTable.INSTANCE).where(SegmentsEntryRelTable.INSTANCE.segmentsEntryId.eq((Object)segmentsEntryId)));
        return SetUtil.fromIterator(iterable.iterator());
    }

    private Set<Long> _getOldIndexClassPKs(long companyId, long segmentsEntryId) throws SearchException {
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("segmentsEntryIds", (Serializable)new long[]{segmentsEntryId});
        searchContext.setCompanyId(companyId);
        Hits hits = this._indexer.search(searchContext);
        HashSet<Long> classPKsSet = new HashSet<Long>();
        for (Document document : hits.getDocs()) {
            classPKsSet.add(GetterUtil.getLong((String)document.get("entryClassPK")));
        }
        return classPKsSet;
    }

    private void _updateDatabase(long segmentsEntryId, Set<Long> newClassPKs) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null || segmentsEntry.getCriteriaObj() == null) {
            return;
        }
        Set<Long> oldClassPKs = this._getOldDatabaseClassPKs(segmentsEntryId);
        HashSet<Long> addClassPKs = new HashSet<Long>(newClassPKs);
        HashSet<Long> deleteClassPKs = new HashSet<Long>();
        for (Long oldClassPK : oldClassPKs) {
            if (addClassPKs.remove(oldClassPK)) continue;
            deleteClassPKs.add(oldClassPK);
        }
        long classNameId = this._portal.getClassNameId(User.class);
        this._segmentsEntryRelLocalService.deleteSegmentsEntryRels(segmentsEntryId, classNameId, ArrayUtil.toLongArray(deleteClassPKs));
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(segmentsEntry.getGroupId());
        serviceContext.setUserId(segmentsEntry.getUserId());
        this._segmentsEntryRelLocalService.addSegmentsEntryRels(segmentsEntryId, classNameId, ArrayUtil.toLongArray(addClassPKs), serviceContext);
    }

    private void _updateIndex(long companyId, long segmentsEntryId, Set<Long> newClassPKs) throws PortalException {
        this._bulkReindexer.reindex(companyId, (Collection)SetUtil.symmetricDifference(this._getOldIndexClassPKs(companyId, segmentsEntryId), newClassPKs));
    }
}

