/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.checker;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.DateUtils;

public class UserSegmentsEntryMembershipChecker {
    private static final String[] _DATE_PATTERNS = new String[]{"yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
    private static final Pattern _booleanPattern = Pattern.compile("true|false");
    private static final Pattern _containsOperationPattern = Pattern.compile("contains\\((customField/){0,1}\\w*, '([^')]*)'\\)");
    private static final DateFormat _dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final Pattern _dateTimePattern = Pattern.compile("\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|((\\+|-)(\\d*))){0,1}");
    private static final Pattern _fieldNameContainsPattern = Pattern.compile("(?<=contains\\()(customField/){0,1}\\w*");
    private static final Pattern _fieldNamePattern = Pattern.compile("(customField\\/){0,1}\\w*\\s+(?=eq|ge|gt|in|le|lt)");
    private static final Map<String, String> _fieldNames = HashMapBuilder.put((Object)"dateModified", (Object)"modifiedDate").build();
    private static final Pattern _logicalOperationPattern = Pattern.compile("\\s+(and|or)\\s+");
    private static final Pattern _notOperationPattern = Pattern.compile("not(?=\\s*\\()");
    private static final Pattern _operationPattern = Pattern.compile(StringBundler.concat((String[])new String[]{"(customField\\/){0,1}\\w*\\s+(eq|ge|gt|in|le|lt)\\s+", "('([^')]*)'|\\('([^')]*)'\\)|false|true|", "\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|", "((\\+|\\-)(\\d*))){0,1})"}));
    private static final Pattern _operatorPattern = Pattern.compile("\\s+(eq|ge|gt|in|le|lt)(?=\\w*\\s+)");
    private static final Map<String, String> _operators = HashMapBuilder.put((Object)"and", (Object)"&&").put((Object)"eq", (Object)"==").put((Object)"ge", (Object)">=").put((Object)"gt", (Object)">").put((Object)"le", (Object)"<=").put((Object)"lt", (Object)"<").put((Object)"not", (Object)"!").put((Object)"or", (Object)"||").build();
    private static final Pattern _valuePattern = Pattern.compile("'([^')]*)'|false|true|'{0,1}\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}.\\d{3}){0,1}((Z)|((\\+|-)(\\d*))){0,1}'{0,1}");

    public static boolean isMember(String filterString, Map<String, Object> userAttributes) throws Exception {
        GroovyShell groovyShell = new GroovyShell();
        Script script = groovyShell.parse(UserSegmentsEntryMembershipChecker._parse(filterString, userAttributes));
        return (Boolean)script.invokeMethod("evaluate", null);
    }

    private static String _getBooleanValueString(String input) throws Exception {
        Matcher matcher = _booleanPattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static String _getDateValueString(String input) throws Exception {
        Matcher matcher = _dateTimePattern.matcher(input);
        if (matcher.find()) {
            String group = matcher.group();
            return _dateTimeFormat.format(DateUtils.parseDate((String)group, (String[])_DATE_PATTERNS));
        }
        return null;
    }

    private static String _getFieldName(String key) {
        String fieldName = _fieldNames.get(StringUtil.trim((String)key));
        if (fieldName != null) {
            return fieldName;
        }
        return key;
    }

    private static Object _getFieldValue(String fieldName, Map<String, Object> userAttributes) {
        return userAttributes.get(UserSegmentsEntryMembershipChecker._getFieldName(StringUtil.trim((String)fieldName)));
    }

    private static String _getGroup(String input, Pattern pattern) {
        Matcher matcher = pattern.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private static String _getValue(String input) throws Exception {
        String value = UserSegmentsEntryMembershipChecker._getGroup(input, _valuePattern);
        if (value == null) {
            return null;
        }
        String booleanValueString = UserSegmentsEntryMembershipChecker._getBooleanValueString(value);
        if (booleanValueString != null) {
            return StringUtil.quote((String)booleanValueString, (String)"\"");
        }
        String dateValueString = UserSegmentsEntryMembershipChecker._getDateValueString(value);
        if (dateValueString != null) {
            return StringUtil.quote((String)dateValueString, (String)"\"");
        }
        return value;
    }

    private static String _parse(String filterString, Map<String, Object> userAttributes) throws Exception {
        String parsedFilterString = UserSegmentsEntryMembershipChecker._processContainsOperations(filterString, userAttributes);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processLogicalOperations(parsedFilterString);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processNotOperations(parsedFilterString);
        parsedFilterString = UserSegmentsEntryMembershipChecker._processOperations(parsedFilterString, userAttributes);
        return StringBundler.concat((String[])new String[]{"def evaluate() {return ", parsedFilterString, "}"});
    }

    private static String _processContainsOperations(String filterString, Map<String, Object> userAttributes) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _containsOperationPattern.matcher(filterString);
        while (matcher.find()) {
            String group = matcher.group();
            Object fieldValue = UserSegmentsEntryMembershipChecker._getFieldValue(UserSegmentsEntryMembershipChecker._getGroup(group, _fieldNameContainsPattern), userAttributes);
            group = UserSegmentsEntryMembershipChecker._getGroup(group, _valuePattern);
            if (fieldValue == null || Validator.isBlank((String)group)) continue;
            matcher.appendReplacement(sb, StringBundler.concat((String[])new String[]{"-1 < ", StringUtil.quote((String)UserSegmentsEntryMembershipChecker._toString(fieldValue), (String)"\""), ".indexOf(", group, ")"}));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processLogicalOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _logicalOperationPattern.matcher(filterString);
        while (matcher.find()) {
            String group = matcher.group();
            matcher.appendReplacement(sb, StringUtil.quote((String)_operators.get(StringUtil.trim((String)group)), (String)" "));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processNotOperations(String filterString) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _notOperationPattern.matcher(filterString);
        while (matcher.find()) {
            matcher.appendReplacement(sb, "!");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String _processOperations(String filterString, Map<String, Object> userAttributes) throws Exception {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = _operationPattern.matcher(filterString);
        while (matcher.find()) {
            String group = matcher.group();
            Object fieldValue = UserSegmentsEntryMembershipChecker._getFieldValue(UserSegmentsEntryMembershipChecker._getGroup(group, _fieldNamePattern), userAttributes);
            String operatorGroup = StringUtil.trim((String)UserSegmentsEntryMembershipChecker._getGroup(group, _operatorPattern));
            String operator = _operators.getOrDefault(operatorGroup, operatorGroup);
            String value = UserSegmentsEntryMembershipChecker._getValue(group);
            if (fieldValue == null || Validator.isBlank((String)operator) || Validator.isBlank((String)value)) continue;
            Class<?> clazz = fieldValue.getClass();
            if (clazz.isArray()) {
                matcher.appendReplacement(sb, StringBundler.concat((String[])new String[]{"(", value, " in [", StringUtil.merge((Object[])TransformUtil.unsafeTransform((Object[])UserSegmentsEntryMembershipChecker._toArray(fieldValue), item -> StringUtil.quote((String)String.valueOf(item)), String.class)), "])"}));
                continue;
            }
            String fieldValueString = UserSegmentsEntryMembershipChecker._toString(fieldValue);
            if (Validator.isNull((String)fieldValueString)) {
                matcher.appendReplacement(sb, "false");
                continue;
            }
            matcher.appendReplacement(sb, StringBundler.concat((String[])new String[]{StringUtil.quote((String)fieldValueString, (String)"\""), " ", operator, " ", value}));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static Object[] _toArray(Object object) {
        Class<?> clazz = object.getClass();
        if (!(clazz = clazz.getComponentType()).isPrimitive()) {
            return (Object[])object;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < Array.getLength(object); ++i) {
            list.add(Array.get(object, i));
        }
        return list.toArray();
    }

    private static String _toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return _dateTimeFormat.format((Date)object);
        }
        return String.valueOf(object);
    }
}

