/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.filter.expression;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.CollectionEntityField;
import com.liferay.portal.odata.entity.ComplexEntityField;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.expression.BinaryExpression;
import com.liferay.portal.odata.filter.expression.CollectionPropertyExpression;
import com.liferay.portal.odata.filter.expression.ComplexPropertyExpression;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.LambdaFunctionExpression;
import com.liferay.portal.odata.filter.expression.LambdaVariableExpression;
import com.liferay.portal.odata.filter.expression.ListExpression;
import com.liferay.portal.odata.filter.expression.LiteralExpression;
import com.liferay.portal.odata.filter.expression.MemberExpression;
import com.liferay.portal.odata.filter.expression.MethodExpression;
import com.liferay.portal.odata.filter.expression.PrimitivePropertyExpression;
import com.liferay.portal.odata.filter.expression.PropertyExpression;
import com.liferay.portal.odata.filter.expression.UnaryExpression;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class PredicateExpressionVisitorImpl<T extends Map>
implements ExpressionVisitor<Object> {
    private final EntityModel _entityModel;
    private final CollectionEntityField _lambdaCollectionEntityField;

    public PredicateExpressionVisitorImpl(EntityModel entityModel) {
        this._entityModel = entityModel;
        this._lambdaCollectionEntityField = null;
    }

    public PredicateExpressionVisitorImpl(EntityModel entityModel, CollectionEntityField lambdaCollectionEntityField) {
        this._entityModel = entityModel;
        this._lambdaCollectionEntityField = lambdaCollectionEntityField;
    }

    public Predicate<T> visitBinaryExpressionOperation(BinaryExpression.Operation operation, Object left, Object right) {
        Predicate<T> predicate = null;
        predicate = this._lambdaCollectionEntityField != null ? this._getLambdaPredicate(operation, left, right) : this._getPredicate(operation, left, right);
        if (predicate != null) {
            return predicate;
        }
        throw new UnsupportedOperationException("Unsupported method visitBinaryExpressionOperation with operation " + operation);
    }

    public Object visitCollectionPropertyExpression(CollectionPropertyExpression collectionPropertyExpression) throws ExpressionVisitException {
        LambdaFunctionExpression lambdaFunctionExpression = collectionPropertyExpression.getLambdaFunctionExpression();
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        CollectionEntityField collectionEntityField = (CollectionEntityField)entityFieldsMap.get(collectionPropertyExpression.getName());
        return lambdaFunctionExpression.accept(new PredicateExpressionVisitorImpl<T>(this._getLambdaEntityModel(lambdaFunctionExpression.getVariableName(), collectionEntityField), collectionEntityField));
    }

    public Object visitComplexPropertyExpression(ComplexPropertyExpression complexPropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        ComplexEntityField complexEntityField = (ComplexEntityField)entityFieldsMap.get(complexPropertyExpression.getName());
        PropertyExpression propertyExpression = complexPropertyExpression.getPropertyExpression();
        Map complexEntityFieldEntityFieldsMap = complexEntityField.getEntityFieldsMap();
        return complexEntityFieldEntityFieldsMap.get(propertyExpression.getName());
    }

    public Object visitLambdaFunctionExpression(LambdaFunctionExpression.Type type, String variable, Expression expression) throws ExpressionVisitException {
        if (type == LambdaFunctionExpression.Type.ANY) {
            return this._any(expression);
        }
        throw new UnsupportedOperationException("Unsupported type visitLambdaFunctionExpression with type " + type);
    }

    public EntityField visitLambdaVariableExpression(LambdaVariableExpression lambdaVariableExpression) throws ExpressionVisitException {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        EntityField entityField = (EntityField)entityFieldsMap.get(lambdaVariableExpression.getVariableName());
        if (entityField == null) {
            throw new ExpressionVisitException("Invoked visitLambdaVariableExpression when no entity field is stored for lambda variable name " + lambdaVariableExpression.getVariableName());
        }
        return entityField;
    }

    public Object visitListExpressionOperation(ListExpression.Operation operation, Object left, List<Object> rights) throws ExpressionVisitException {
        if (operation != ListExpression.Operation.IN) {
            throw new UnsupportedOperationException("Unsupported method visitListExpressionOperation with operation " + operation);
        }
        return this._getINPredicate((EntityField)left, rights);
    }

    public Object visitLiteralExpression(LiteralExpression literalExpression) {
        if (Objects.equals(LiteralExpression.Type.BOOLEAN, literalExpression.getType())) {
            return Boolean.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE, literalExpression.getType())) {
            return LocalDate.parse(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DATE_TIME, literalExpression.getType())) {
            return ZonedDateTime.parse(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.DOUBLE, literalExpression.getType())) {
            return Double.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.INTEGER, literalExpression.getType())) {
            return Integer.valueOf(literalExpression.getText());
        }
        if (Objects.equals(LiteralExpression.Type.STRING, literalExpression.getType())) {
            return this._normalizeStringLiteral(literalExpression.getText());
        }
        return literalExpression.getText();
    }

    public Object visitMemberExpression(MemberExpression memberExpression) throws ExpressionVisitException {
        Expression expression = memberExpression.getExpression();
        return expression.accept((ExpressionVisitor)this);
    }

    public Object visitMethodExpression(List<Object> expressions, MethodExpression.Type type) {
        if (type == MethodExpression.Type.CONTAINS) {
            if (expressions.size() != 2) {
                throw new UnsupportedOperationException(StringBundler.concat((Object[])new Object[]{"Unsupported method visitMethodExpression with method ", "type ", type, " and ", expressions.size(), " parameters"}));
            }
            if (this._lambdaCollectionEntityField != null) {
                return this._getLambdaContainsPredicate((EntityField)expressions.get(0), expressions.get(1));
            }
            return this._getContainsPredicate((EntityField)expressions.get(0), expressions.get(1));
        }
        throw new UnsupportedOperationException("Unsupported method visitMethodExpression with method type " + type);
    }

    public Object visitPrimitivePropertyExpression(PrimitivePropertyExpression primitivePropertyExpression) {
        Map entityFieldsMap = this._entityModel.getEntityFieldsMap();
        return entityFieldsMap.get(primitivePropertyExpression.getName());
    }

    public Predicate<T> visitUnaryExpressionOperation(UnaryExpression.Operation operation, Object operand) {
        if (Objects.equals(UnaryExpression.Operation.NOT, operation)) {
            return this._getNotPredicate((Predicate)operand);
        }
        throw new UnsupportedOperationException("Unsupported method visitUnaryExpressionOperation with operation " + operation);
    }

    private Object _any(Expression expression) throws ExpressionVisitException {
        return expression.accept((ExpressionVisitor)this);
    }

    private Predicate<T> _getANDPredicate(Predicate<T> leftPredicate, Predicate<T> rightPredicate) {
        return leftPredicate.and(rightPredicate);
    }

    private Predicate<T> _getContainsPredicate(EntityField entityField, Object fieldValue) {
        if (Objects.equals(entityField.getType(), EntityField.Type.ID) || Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return p -> StringUtils.containsIgnoreCase((CharSequence)String.valueOf(p.get(entityField.getName())), (CharSequence)String.valueOf(fieldValue));
        }
        throw new UnsupportedOperationException("Unsupported method _contains with entity field type " + entityField.getType());
    }

    private Predicate<T> _getEQPredicate(EntityField entityField, Object fieldValue) {
        if (Objects.equals(entityField.getType(), EntityField.Type.ID)) {
            return p -> StringUtils.containsIgnoreCase((CharSequence)String.valueOf(p.get(entityField.getName())), (CharSequence)String.valueOf(fieldValue));
        }
        if (Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            return p -> fieldValue.equals(this._normalizeStringLiteral(String.valueOf(p.get(entityField.getName()))));
        }
        return p -> fieldValue.equals(p.get(entityField.getName()));
    }

    private Predicate<T> _getGEPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            Comparable comparable = (Comparable)fieldValue;
            return p -> comparable.compareTo(p.get(entityField.getName())) <= 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getGEPredicate with entity field type " + entityField.getType());
    }

    private Predicate<T> _getGTPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            Comparable comparable = (Comparable)fieldValue;
            return p -> comparable.compareTo(p.get(entityField.getName())) < 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getGTPredicate with entity field type " + entityField.getType());
    }

    private Predicate<T> _getINPredicate(EntityField entityField, List<Object> fieldValues) {
        return p -> {
            for (Object fieldValue : fieldValues) {
                if (!StringUtils.containsIgnoreCase((CharSequence)String.valueOf(p.get(entityField.getName())), (CharSequence)String.valueOf(fieldValue))) continue;
                return true;
            }
            return false;
        };
    }

    private Predicate<T> _getLambdaContainsPredicate(EntityField entityField, Object fieldValue) {
        if (!Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            throw new UnsupportedOperationException("Unsupported method _lambdaContains with entity field type " + entityField.getType());
        }
        return p -> {
            for (String name : (String[])p.get(this._lambdaCollectionEntityField.getName())) {
                if (!StringUtils.containsIgnoreCase((CharSequence)String.valueOf(name), (CharSequence)String.valueOf(fieldValue))) continue;
                return true;
            }
            return false;
        };
    }

    private EntityModel _getLambdaEntityModel(final String variableName, final CollectionEntityField collectionEntityField) {
        return new EntityModel(){

            public Map<String, EntityField> getEntityFieldsMap() {
                return Collections.singletonMap(variableName, collectionEntityField.getEntityField());
            }

            public String getName() {
                return collectionEntityField.getName();
            }
        };
    }

    private Predicate<T> _getLambdaEQPredicate(EntityField entityField, Object fieldValue) {
        if (!Objects.equals(entityField.getType(), EntityField.Type.STRING)) {
            throw new UnsupportedOperationException("Unsupported method _getLambdaEQPredicate with entity field " + entityField.getType());
        }
        return p -> {
            for (String name : (String[])p.get(this._lambdaCollectionEntityField.getName())) {
                if (!fieldValue.equals(this._normalizeStringLiteral(String.valueOf(name)))) continue;
                return true;
            }
            return false;
        };
    }

    private Predicate<T> _getLambdaPredicate(BinaryExpression.Operation operation, Object left, Object right) {
        if (!Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            return null;
        }
        return this._getLambdaEQPredicate((EntityField)left, right);
    }

    private Predicate<T> _getLEPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            Comparable comparable = (Comparable)fieldValue;
            return p -> comparable.compareTo(p.get(entityField.getName())) >= 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getLEPredicate with entity field type " + entityField.getType());
    }

    private Predicate<T> _getLTPredicate(EntityField entityField, Object fieldValue) {
        if (fieldValue instanceof Comparable && (Objects.equals(entityField.getType(), EntityField.Type.DATE) || Objects.equals(entityField.getType(), EntityField.Type.DATE_TIME) || Objects.equals(entityField.getType(), EntityField.Type.DOUBLE) || Objects.equals(entityField.getType(), EntityField.Type.INTEGER) || Objects.equals(entityField.getType(), EntityField.Type.STRING))) {
            Comparable comparable = (Comparable)fieldValue;
            return p -> comparable.compareTo(p.get(entityField.getName())) > 0;
        }
        throw new UnsupportedOperationException("Unsupported method _getLTPredicate with entity field type " + entityField.getType());
    }

    private Predicate<T> _getNotPredicate(Predicate<T> predicate) {
        return predicate.negate();
    }

    private Predicate<T> _getORPredicate(Predicate<T> leftPredicate, Predicate<T> rightPredicate) {
        return leftPredicate.or(rightPredicate);
    }

    private Predicate<T> _getPredicate(BinaryExpression.Operation operation, Object left, Object right) {
        if (Objects.equals(BinaryExpression.Operation.AND, operation)) {
            return this._getANDPredicate((Predicate)left, (Predicate)right);
        }
        if (Objects.equals(BinaryExpression.Operation.EQ, operation)) {
            return this._getEQPredicate((EntityField)left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.GE, operation)) {
            return this._getGEPredicate((EntityField)left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.GT, operation)) {
            return this._getGTPredicate((EntityField)left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.LE, operation)) {
            return this._getLEPredicate((EntityField)left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.LT, operation)) {
            return this._getLTPredicate((EntityField)left, right);
        }
        if (Objects.equals(BinaryExpression.Operation.OR, operation)) {
            return this._getORPredicate((Predicate)left, (Predicate)right);
        }
        return null;
    }

    private Object _normalizeStringLiteral(String literal) {
        literal = StringUtil.toLowerCase((String)literal);
        literal = StringUtil.unquote((String)literal);
        return StringUtil.replace((String)literal, (String)"''", (String)"'");
    }
}

