/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.criteria.contributor;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.mapper.SegmentsCriteriaJSONObjectMapper;
import com.liferay.segments.field.Field;
import com.liferay.segments.internal.odata.entity.EntityModelFieldMapper;
import com.liferay.segments.odata.retriever.ODataRetriever;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"segments.criteria.contributor.key=user-organization", "segments.criteria.contributor.model.class.name=com.liferay.portal.kernel.model.User", "segments.criteria.contributor.priority:Integer=20"}, service={SegmentsCriteriaContributor.class})
public class UserOrganizationSegmentsCriteriaContributor
implements SegmentsCriteriaContributor {
    public static final String KEY = "user-organization";
    private static final Log _log = LogFactoryUtil.getLog(UserOrganizationSegmentsCriteriaContributor.class);
    private static final Pattern _pattern = Pattern.compile("dateModified eq (?<date>\\d{4}-\\d{2}-\\d{2})T.*Z");
    @Reference(target="(entity.model.name=Organization)")
    private EntityModel _entityModel;
    @Reference
    private EntityModelFieldMapper _entityModelFieldMapper;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.Organization)")
    private ODataRetriever<Organization> _oDataRetriever;
    @Reference(target="(segments.criteria.mapper.key=odata)")
    private SegmentsCriteriaJSONObjectMapper _segmentsCriteriaJSONObjectMapper;

    public void contribute(Criteria criteria, String filterString, Criteria.Conjunction conjunction) {
        criteria.addCriterion(this.getKey(), this.getType(), filterString, conjunction);
        String newFilterString = null;
        try {
            Matcher matcher = _pattern.matcher(filterString);
            while (matcher.find()) {
                String date = matcher.group("date");
                filterString = StringUtil.replace((String)filterString, (String)matcher.group(), (String)StringBundler.concat((String[])new String[]{"dateModified ge ", date, "T00:00:00.000Z and ", "dateModified le ", date, "T23:59:59.999Z"}));
            }
            List organizations = this._oDataRetriever.getResults(CompanyThreadLocal.getCompanyId().longValue(), filterString, LocaleUtil.getDefault(), -1, -1);
            if (!organizations.isEmpty()) {
                StringBundler sb = new StringBundler(2 * organizations.size() + 1);
                sb.append("organizationIds in ('");
                for (Organization organization : organizations) {
                    sb.append(organization.getOrganizationId());
                    sb.append("', '");
                }
                sb.setStringAt("')", sb.index() - 1);
                newFilterString = sb.toString();
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to evaluate criteria ", criteria, " with filter ", filterString, " and conjunction ", conjunction.getValue()}), (Throwable)portalException);
        }
        if (newFilterString == null) {
            newFilterString = "(userId eq '0')";
        }
        criteria.addFilter(this.getType(), newFilterString, conjunction);
    }

    public JSONObject getCriteriaJSONObject(Criteria criteria) throws Exception {
        return this._segmentsCriteriaJSONObjectMapper.toJSONObject(criteria, (SegmentsCriteriaContributor)this);
    }

    public EntityModel getEntityModel() {
        return this._entityModel;
    }

    public String getEntityName() {
        return "Organization";
    }

    public List<Field> getFields(PortletRequest portletRequest) {
        return this._entityModelFieldMapper.getFields(this._entityModel, portletRequest);
    }

    public String getKey() {
        return KEY;
    }

    public Criteria.Type getType() {
        return Criteria.Type.MODEL;
    }
}

