/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.segments.SegmentsEntryRetriever;
import com.liferay.segments.configuration.provider.SegmentsConfigurationProvider;
import com.liferay.segments.context.Context;
import com.liferay.segments.provider.SegmentsEntryProviderRegistry;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SegmentsEntryRetriever.class})
public class SegmentsEntryRetrieverImpl
implements SegmentsEntryRetriever {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsEntryRetrieverImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsConfigurationProvider _segmentsConfigurationProvider;
    @Reference
    private SegmentsEntryProviderRegistry _segmentsEntryProviderRegistry;

    public long[] getSegmentsEntryIds(long groupId, long userId, Context context, long[] segmentEntryIds) {
        try {
            if (!this._segmentsConfigurationProvider.isSegmentationEnabled(this._getCompanyId(groupId))) {
                return new long[]{0L};
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return ArrayUtil.toLongArray((Collection)SetUtil.fromArray((long[])ArrayUtil.append((long[])this._getSegmentEntryIds(groupId, userId, context, segmentEntryIds), (long)0L)));
    }

    private long _getCompanyId(long groupId) throws PortalException {
        if (groupId == 0L) {
            return this._portal.getDefaultCompanyId();
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this._portal.getDefaultCompanyId();
        }
        return group.getCompanyId();
    }

    private long[] _getSegmentEntryIds(long groupId, long userId, Context context, long[] segmentEntryIds) {
        long segmentsEntryId = this._getSegmentsEntryId();
        if (segmentsEntryId >= 0L) {
            return new long[]{segmentsEntryId};
        }
        try {
            return this._segmentsEntryProviderRegistry.getSegmentsEntryIds(groupId, User.class.getName(), userId, context, segmentEntryIds);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return new long[0];
        }
    }

    private long _getSegmentsEntryId() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return -1L;
        }
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return -1L;
        }
        String layoutMode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode", (String)"view");
        if (!layoutMode.equals("preview")) {
            return -1L;
        }
        return ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"segmentsEntryId", (long)-1L);
    }
}

