/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.service.http;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.segments.service.SegmentsExperienceServiceUtil;

import java.rmi.RemoteException;

import java.util.Locale;
import java.util.Map;

/**
 * Provides the SOAP utility for the
 * <code>SegmentsExperienceServiceUtil</code> service
 * utility. The static methods of this class call the same methods of the
 * service utility. However, the signatures are different because it is
 * difficult for SOAP to support certain types.
 *
 * <p>
 * ServiceBuilder follows certain rules in translating the methods. For example,
 * if the method in the service utility returns a <code>java.util.List</code>,
 * that is translated to an array of
 * <code>com.liferay.segments.model.SegmentsExperienceSoap</code>. If the method in the
 * service utility returns a
 * <code>com.liferay.segments.model.SegmentsExperience</code>, that is translated to a
 * <code>com.liferay.segments.model.SegmentsExperienceSoap</code>. Methods that SOAP
 * cannot safely wire are skipped.
 * </p>
 *
 * <p>
 * The benefits of using the SOAP utility is that it is cross platform
 * compatible. SOAP allows different languages like Java, .NET, C++, PHP, and
 * even Perl, to call the generated services. One drawback of SOAP is that it is
 * slow because it needs to serialize all calls into a text format (XML).
 * </p>
 *
 * <p>
 * You can see a list of services at http://localhost:8080/api/axis. Set the
 * property <b>axis.servlet.hosts.allowed</b> in portal.properties to configure
 * security.
 * </p>
 *
 * <p>
 * The SOAP utility is only generated for remote services.
 * </p>
 *
 * @author Eduardo Garcia
 * @see SegmentsExperienceServiceHttp
 * @deprecated As of Athanasius (7.3.x), with no direct replacement
 * @generated
 */
@Deprecated
public class SegmentsExperienceServiceSoap {

	public static com.liferay.segments.model.SegmentsExperienceSoap
			addSegmentsExperience(
				long segmentsEntryId, long classNameId, long classPK,
				String[] nameMapLanguageIds, String[] nameMapValues,
				boolean active,
				com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws RemoteException {

		try {
			Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(
				nameMapLanguageIds, nameMapValues);

			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.addSegmentsExperience(
					segmentsEntryId, classNameId, classPK, nameMap, active,
					serviceContext);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap
			appendSegmentsExperience(
				long segmentsEntryId, long classNameId, long classPK,
				String[] nameMapLanguageIds, String[] nameMapValues,
				boolean active,
				com.liferay.portal.kernel.service.ServiceContext serviceContext)
		throws RemoteException {

		try {
			Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(
				nameMapLanguageIds, nameMapValues);

			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.appendSegmentsExperience(
					segmentsEntryId, classNameId, classPK, nameMap, active,
					serviceContext);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap
			deleteSegmentsExperience(long segmentsExperienceId)
		throws RemoteException {

		try {
			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.deleteSegmentsExperience(
					segmentsExperienceId);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap
			fetchSegmentsExperience(long groupId, String segmentsExperienceKey)
		throws RemoteException {

		try {
			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.fetchSegmentsExperience(
					groupId, segmentsExperienceKey);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap
			getSegmentsExperience(long segmentsExperienceId)
		throws RemoteException {

		try {
			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.getSegmentsExperience(
					segmentsExperienceId);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap[]
			getSegmentsExperiences(
				long groupId, long classNameId, long classPK, boolean active)
		throws RemoteException {

		try {
			java.util.List<com.liferay.segments.model.SegmentsExperience>
				returnValue =
					SegmentsExperienceServiceUtil.getSegmentsExperiences(
						groupId, classNameId, classPK, active);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModels(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap[]
			getSegmentsExperiences(
				long groupId, long classNameId, long classPK, boolean active,
				int start, int end,
				com.liferay.portal.kernel.util.OrderByComparator
					<com.liferay.segments.model.SegmentsExperience>
						orderByComparator)
		throws RemoteException {

		try {
			java.util.List<com.liferay.segments.model.SegmentsExperience>
				returnValue =
					SegmentsExperienceServiceUtil.getSegmentsExperiences(
						groupId, classNameId, classPK, active, start, end,
						orderByComparator);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModels(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static int getSegmentsExperiencesCount(
			long groupId, long classNameId, long classPK, boolean active)
		throws RemoteException {

		try {
			int returnValue =
				SegmentsExperienceServiceUtil.getSegmentsExperiencesCount(
					groupId, classNameId, classPK, active);

			return returnValue;
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static com.liferay.segments.model.SegmentsExperienceSoap
			updateSegmentsExperience(
				long segmentsExperienceId, long segmentsEntryId,
				String[] nameMapLanguageIds, String[] nameMapValues,
				boolean active)
		throws RemoteException {

		try {
			Map<Locale, String> nameMap = LocalizationUtil.getLocalizationMap(
				nameMapLanguageIds, nameMapValues);

			com.liferay.segments.model.SegmentsExperience returnValue =
				SegmentsExperienceServiceUtil.updateSegmentsExperience(
					segmentsExperienceId, segmentsEntryId, nameMap, active);

			return com.liferay.segments.model.SegmentsExperienceSoap.
				toSoapModel(returnValue);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	public static void updateSegmentsExperiencePriority(
			long segmentsExperienceId, int newPriority)
		throws RemoteException {

		try {
			SegmentsExperienceServiceUtil.updateSegmentsExperiencePriority(
				segmentsExperienceId, newPriority);
		}
		catch (Exception exception) {
			_log.error(exception, exception);

			throw new RemoteException(exception.getMessage());
		}
	}

	private static Log _log = LogFactoryUtil.getLog(
		SegmentsExperienceServiceSoap.class);

}