/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.exception.RequiredSegmentsExperienceException;
import com.liferay.segments.exception.SegmentsExperienceNameException;
import com.liferay.segments.exception.SegmentsExperiencePriorityException;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.base.SegmentsExperienceLocalServiceBaseImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsExperience"}, service={AopService.class})
public class SegmentsExperienceLocalServiceImpl
extends SegmentsExperienceLocalServiceBaseImpl {
    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        int lowestPriority = this._getLowestPriority(serviceContext.getScopeGroupId(), classNameId, this._getPublishedLayoutClassPK(classPK));
        if (lowestPriority - 1 == -1) {
            --lowestPriority;
        }
        return this.addSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, lowestPriority - 1, active, serviceContext);
    }

    public SegmentsExperience addSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, int priority, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long groupId = serviceContext.getScopeGroupId();
        long publishedClassPK = this._getPublishedLayoutClassPK(classPK);
        this._validateName(nameMap);
        this._validatePriority(groupId, classNameId, publishedClassPK, priority);
        long segmentsExperienceId = this.counterLocalService.increment();
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.create(segmentsExperienceId);
        segmentsExperience.setUuid(serviceContext.getUuid());
        segmentsExperience.setGroupId(groupId);
        segmentsExperience.setCompanyId(user.getCompanyId());
        segmentsExperience.setUserId(user.getUserId());
        segmentsExperience.setUserName(user.getFullName());
        segmentsExperience.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsExperience.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setSegmentsExperienceKey(String.valueOf(this.counterLocalService.increment()));
        segmentsExperience.setClassNameId(classNameId);
        segmentsExperience.setClassPK(publishedClassPK);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setPriority(priority);
        segmentsExperience.setActive(active);
        segmentsExperience = (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        this.resourceLocalService.addModelResources((AuditedModel)segmentsExperience, serviceContext);
        return segmentsExperience;
    }

    public SegmentsExperience appendSegmentsExperience(long segmentsEntryId, long classNameId, long classPK, Map<Locale, String> nameMap, boolean active, ServiceContext serviceContext) throws PortalException {
        int highestPriority = this._getHighestPriority(serviceContext.getScopeGroupId(), classNameId, this._getPublishedLayoutClassPK(classPK));
        if (highestPriority + 1 == -1) {
            ++highestPriority;
        }
        return this.addSegmentsExperience(segmentsEntryId, classNameId, classPK, nameMap, highestPriority + 1, active, serviceContext);
    }

    public void deleteSegmentsEntrySegmentsExperiences(long segmentsEntryId) throws PortalException {
        List segmentsExperiences = this.segmentsExperiencePersistence.findBySegmentsEntryId(segmentsEntryId);
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
        }
    }

    @Override
    public SegmentsExperience deleteSegmentsExperience(long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        return this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
    }

    @Override
    @SystemEvent(type=1)
    public SegmentsExperience deleteSegmentsExperience(SegmentsExperience segmentsExperience) throws PortalException {
        List<SegmentsExperience> segmentsExperiences;
        int count;
        if (!GroupThreadLocal.isDeleteInProcess() && (count = this.segmentsExperimentFinder.countByS_C_C_S(segmentsExperience.getSegmentsExperienceId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), SegmentsExperimentConstants.Status.getLockedStatusValues())) > 0) {
            throw new RequiredSegmentsExperienceException.MustNotDeleteSegmentsExperienceReferencedBySegmentsExperiments(segmentsExperience.getSegmentsExperienceId());
        }
        this.segmentsExperiencePersistence.remove((BaseModel)segmentsExperience);
        this.segmentsExperiencePersistence.flush();
        if (segmentsExperience.getPriority() >= 0) {
            segmentsExperiences = new ArrayList<SegmentsExperience>(this.segmentsExperiencePersistence.findByG_C_C_GtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), segmentsExperience.getPriority()));
            int lowestPriority = this._getLowestPriority(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK());
            int highestPriority = this._getHighestPriority(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK());
            segmentsExperiences = this._updateSegmentExperiencesPriority(segmentsExperiences, lowestPriority - 1, -1);
            this.segmentsExperiencePersistence.flush();
            this._updateSegmentExperiencesPriority(segmentsExperiences, highestPriority - 1, -1);
        } else {
            segmentsExperiences = new ArrayList(this.segmentsExperiencePersistence.findByG_C_C_LtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), segmentsExperience.getPriority()));
            this._updateSegmentExperiencesPriority(segmentsExperiences, segmentsExperience.getPriority(), 1);
        }
        for (SegmentsExperiment segmentsExperiment : this.segmentsExperimentPersistence.findByS_C_C(segmentsExperience.getSegmentsExperienceId(), segmentsExperience.getClassNameId(), this._getPublishedLayoutClassPK(segmentsExperience.getClassPK()))) {
            this._deleteSegmentsExperiment(segmentsExperiment);
        }
        this.resourceLocalService.deleteResource((AuditedModel)segmentsExperience, 4);
        return segmentsExperience;
    }

    public void deleteSegmentsExperiences(long groupId, long classNameId, long classPK) throws PortalException {
        List segmentsExperiences = this.segmentsExperiencePersistence.findByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            this.segmentsExperienceLocalService.deleteSegmentsExperience(segmentsExperience);
        }
        for (SegmentsExperiment segmentsExperiment : this.segmentsExperimentPersistence.findByS_C_C(0L, classNameId, this._getPublishedLayoutClassPK(classPK))) {
            this._deleteSegmentsExperiment(segmentsExperiment);
        }
    }

    @Override
    public SegmentsExperience fetchSegmentsExperience(long segmentsExperienceId) {
        return this.segmentsExperiencePersistence.fetchByPrimaryKey(segmentsExperienceId);
    }

    public SegmentsExperience fetchSegmentsExperience(long groupId, String segmentsExperienceKey) {
        return this.segmentsExperiencePersistence.fetchByG_S(groupId, segmentsExperienceKey);
    }

    @Override
    public SegmentsExperience getSegmentsExperience(long segmentsExperienceId) throws PortalException {
        return this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
    }

    public SegmentsExperience getSegmentsExperience(long groupId, String segmentsExperienceKey) throws PortalException {
        return this.segmentsExperiencePersistence.findByG_S(groupId, segmentsExperienceKey);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.findByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active) throws PortalException {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long[] segmentsEntryIds, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.findByG_S_C_C_A(groupId, segmentsEntryIds, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public List<SegmentsExperience> getSegmentsExperiences(long groupId, long[] segmentsEntryIds, long classNameId, long classPK, boolean active, int start, int end, OrderByComparator<SegmentsExperience> orderByComparator) {
        return this.segmentsExperiencePersistence.findByG_S_C_C_A(groupId, segmentsEntryIds, classNameId, this._getPublishedLayoutClassPK(classPK), active, start, end, orderByComparator);
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK) {
        return this.segmentsExperiencePersistence.countByG_C_C(groupId, classNameId, this._getPublishedLayoutClassPK(classPK));
    }

    public int getSegmentsExperiencesCount(long groupId, long classNameId, long classPK, boolean active) {
        return this.segmentsExperiencePersistence.countByG_C_C_A(groupId, classNameId, this._getPublishedLayoutClassPK(classPK), active);
    }

    public SegmentsExperience updateSegmentsExperience(long segmentsExperienceId, long segmentsEntryId, Map<Locale, String> nameMap, boolean active) throws PortalException {
        this._validateName(nameMap);
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        segmentsExperience.setSegmentsEntryId(segmentsEntryId);
        segmentsExperience.setNameMap(nameMap);
        segmentsExperience.setActive(active);
        return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
    }

    public SegmentsExperience updateSegmentsExperienceActive(long segmentsExperienceId, boolean active) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        segmentsExperience.setActive(active);
        return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
    }

    public SegmentsExperience updateSegmentsExperiencePriority(long segmentsExperienceId, int newPriority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.findByPrimaryKey(segmentsExperienceId);
        int count = this.segmentsExperiencePersistence.countByG_C_C(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK());
        if (newPriority >= count) {
            return segmentsExperience;
        }
        int lowestPriority = this._getLowestPriority(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK());
        if (segmentsExperience.getPriority() == 0 && newPriority == -1) {
            return this._swapSegmentsExperiences(lowestPriority, -2, segmentsExperience);
        }
        if (segmentsExperience.getPriority() == -2 && newPriority == -1) {
            return this._swapSegmentsExperiences(lowestPriority, 0, segmentsExperience);
        }
        return this._swapSegmentsExperience(lowestPriority, newPriority, segmentsExperience);
    }

    private void _deleteSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws PortalException {
        this.segmentsExperimentPersistence.remove((BaseModel)segmentsExperiment);
        this.segmentsExperimentRelPersistence.removeBySegmentsExperimentId(segmentsExperiment.getSegmentsExperimentId());
        this.resourceLocalService.deleteResource((AuditedModel)segmentsExperiment, 4);
    }

    private int _getHighestPriority(long groupId, long classNameId, long classPK) {
        return Optional.ofNullable(this.segmentsExperiencePersistence.fetchByG_C_C_First(groupId, classNameId, classPK, null)).map(SegmentsExperienceModel::getPriority).orElse(-1);
    }

    private int _getLowestPriority(long groupId, long classNameId, long classPK) {
        return Optional.ofNullable(this.segmentsExperiencePersistence.fetchByG_C_C_Last(groupId, classNameId, classPK, null)).map(SegmentsExperienceModel::getPriority).orElse(-1);
    }

    private long _getPublishedLayoutClassPK(long classPK) {
        Layout layout = this.layoutLocalService.fetchLayout(classPK);
        if (layout != null && layout.getClassNameId() == this.classNameLocalService.getClassNameId(Layout.class) && layout.getClassPK() != 0L) {
            return layout.getClassPK();
        }
        return classPK;
    }

    private List<SegmentsExperience> _getSegmentExperiences(SegmentsExperience segmentsExperience) {
        List aboveSegmentsExperiences = this.segmentsExperiencePersistence.findByG_C_C_GtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), segmentsExperience.getPriority());
        List belowSegmentsExperiences = this.segmentsExperiencePersistence.findByG_C_C_LtP(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), segmentsExperience.getPriority());
        return Stream.concat(Stream.concat(aboveSegmentsExperiences.stream(), Stream.of(segmentsExperience)), belowSegmentsExperiences.stream()).collect(Collectors.toList());
    }

    private SegmentsExperience _swapSegmentsExperience(int lowestPriority, int priority, SegmentsExperience segmentsExperience) {
        SegmentsExperience swapSegmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(segmentsExperience.getGroupId(), segmentsExperience.getClassNameId(), segmentsExperience.getClassPK(), priority);
        if (swapSegmentsExperience == null) {
            segmentsExperience.setPriority(priority);
            return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        }
        int originalPriority = segmentsExperience.getPriority();
        segmentsExperience.setPriority(lowestPriority - 1);
        segmentsExperience = (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        swapSegmentsExperience.setPriority(lowestPriority - 2);
        swapSegmentsExperience = (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)swapSegmentsExperience);
        this.segmentsExperiencePersistence.flush();
        segmentsExperience.setPriority(priority);
        segmentsExperience = this.segmentsExperienceLocalService.updateSegmentsExperience(segmentsExperience);
        swapSegmentsExperience.setPriority(originalPriority);
        this.segmentsExperienceLocalService.updateSegmentsExperience(swapSegmentsExperience);
        return segmentsExperience;
    }

    private SegmentsExperience _swapSegmentsExperiences(int lowestPriority, int priority, SegmentsExperience segmentsExperience) {
        List<SegmentsExperience> segmentsExperiences = this._getSegmentExperiences(segmentsExperience);
        if (ListUtil.isEmpty(segmentsExperiences)) {
            segmentsExperience.setPriority(priority);
            return (SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience);
        }
        Stream stream = segmentsExperiences.stream();
        int top = Math.toIntExact(stream.filter(currentSegmentsExperience -> currentSegmentsExperience.getSegmentsExperienceId() != segmentsExperience.getSegmentsExperienceId()).filter(currentSegmentsExperience -> currentSegmentsExperience.getPriority() >= 0).count());
        if (priority < 0) {
            --top;
        } else if (priority > 0) {
            ++top;
        }
        int bottom = lowestPriority - 1;
        if (priority < 0) {
            bottom -= 2;
        }
        segmentsExperiences = this._updateSegmentExperiencesPriority(segmentsExperiences, bottom, -1);
        this.segmentsExperiencePersistence.flush();
        this._updateSegmentExperiencesPriority(segmentsExperiences, top, -1);
        return this.segmentsExperiencePersistence.fetchByPrimaryKey(segmentsExperience.getSegmentsExperienceId());
    }

    private List<SegmentsExperience> _updateSegmentExperiencesPriority(List<SegmentsExperience> segmentsExperiences, int initialPriority, int offset) {
        int currentPriority = initialPriority;
        ArrayList<SegmentsExperience> updatedSegmentsExperiences = new ArrayList<SegmentsExperience>();
        for (SegmentsExperience segmentsExperience : segmentsExperiences) {
            if (currentPriority == -1) {
                currentPriority = -1 + offset;
            }
            segmentsExperience.setPriority(currentPriority);
            updatedSegmentsExperiences.add((SegmentsExperience)this.segmentsExperiencePersistence.update((BaseModel)segmentsExperience));
            if (currentPriority == -1 + offset) {
                this.segmentsExperiencePersistence.flush();
            }
            currentPriority += offset;
        }
        return updatedSegmentsExperiences;
    }

    private void _validateName(Map<Locale, String> nameMap) throws PortalException {
        Locale locale = LocaleUtil.getSiteDefault();
        if (nameMap.isEmpty() || Validator.isNull((String)nameMap.get(locale))) {
            throw new SegmentsExperienceNameException();
        }
    }

    private void _validatePriority(long groupId, long classNameId, long classPK, int priority) throws PortalException {
        SegmentsExperience segmentsExperience = this.segmentsExperiencePersistence.fetchByG_C_C_P(groupId, classNameId, classPK, priority);
        if (segmentsExperience != null) {
            throw new SegmentsExperiencePriorityException("A segments experience with the priority " + priority + " already exists");
        }
    }
}

