/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryRole;
import com.liferay.segments.service.base.SegmentsEntryRoleLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsEntryRole"}, service={AopService.class})
public class SegmentsEntryRoleLocalServiceImpl
extends SegmentsEntryRoleLocalServiceBaseImpl {
    public SegmentsEntryRole addSegmentsEntryRole(long segmentsEntryId, long roleId, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long segmentsEntryRoleId = this.counterLocalService.increment();
        SegmentsEntryRole segmentsEntryRole = this.segmentsEntryRolePersistence.create(segmentsEntryRoleId);
        segmentsEntryRole.setCompanyId(user.getCompanyId());
        segmentsEntryRole.setUserId(user.getUserId());
        segmentsEntryRole.setUserName(user.getFullName());
        segmentsEntryRole.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsEntryRole.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntryRole.setSegmentsEntryId(segmentsEntryId);
        segmentsEntryRole.setRoleId(roleId);
        segmentsEntryRole = (SegmentsEntryRole)this.segmentsEntryRolePersistence.update((BaseModel)segmentsEntryRole);
        this._reindex(segmentsEntryId);
        return segmentsEntryRole;
    }

    @SystemEvent(type=1)
    public SegmentsEntryRole deleteSegmentsEntryRole(long segmentsEntryId, long roleId) throws PortalException {
        SegmentsEntryRole segmentsEntryRole = this.segmentsEntryRolePersistence.removeByS_R(segmentsEntryId, roleId);
        this._reindex(segmentsEntryId);
        return segmentsEntryRole;
    }

    @SystemEvent(type=1)
    public void deleteSegmentsEntryRoles(long segmentsEntryId) throws PortalException {
        this.segmentsEntryRolePersistence.removeBySegmentsEntryId(segmentsEntryId);
        this._reindex(segmentsEntryId);
    }

    @SystemEvent(type=1)
    public void deleteSegmentsEntryRolesByRoleId(long roleId) throws PortalException {
        List segmentsEntryRoles = this.segmentsEntryRolePersistence.findByRoleId(roleId);
        this.segmentsEntryRolePersistence.removeByRoleId(roleId);
        for (SegmentsEntryRole segmentsEntryRole : segmentsEntryRoles) {
            this._reindex(segmentsEntryRole.getSegmentsEntryId());
        }
    }

    public List<SegmentsEntryRole> getSegmentsEntryRoles(long segmentsEntryId) {
        return this.segmentsEntryRolePersistence.findBySegmentsEntryId(segmentsEntryId);
    }

    public List<SegmentsEntryRole> getSegmentsEntryRolesByRoleId(long roleId) {
        return this.segmentsEntryRolePersistence.findByRoleId(roleId);
    }

    public int getSegmentsEntryRolesCount(long segmentsEntryId) {
        return this.segmentsEntryRolePersistence.countBySegmentsEntryId(segmentsEntryId);
    }

    public int getSegmentsEntryRolesCountByRoleId(long roleId) {
        return this.segmentsEntryRolePersistence.countByRoleId(roleId);
    }

    public boolean hasSegmentEntryRole(long segmentsEntryId, long roleId) {
        return this.segmentsEntryRolePersistence.fetchByS_R(segmentsEntryId, roleId) != null;
    }

    private void _reindex(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this.segmentsEntryPersistence.fetchByPrimaryKey(segmentsEntryId);
        if (segmentsEntry == null) {
            return;
        }
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(SegmentsEntry.class);
        indexer.reindex((Object)segmentsEntry);
    }
}

