/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.segments.model.SegmentsEntryRel;
import com.liferay.segments.service.base.SegmentsEntryRelLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.segments.model.SegmentsEntryRel"}, service={AopService.class})
public class SegmentsEntryRelLocalServiceImpl
extends SegmentsEntryRelLocalServiceBaseImpl {
    public SegmentsEntryRel addSegmentsEntryRel(long segmentsEntryId, long classNameId, long classPK, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(serviceContext.getUserId());
        long segmentsEntryRelId = this.counterLocalService.increment();
        SegmentsEntryRel segmentsEntryRel = this.segmentsEntryRelPersistence.create(segmentsEntryRelId);
        segmentsEntryRel.setGroupId(serviceContext.getScopeGroupId());
        segmentsEntryRel.setCompanyId(user.getCompanyId());
        segmentsEntryRel.setUserId(user.getUserId());
        segmentsEntryRel.setUserName(user.getFullName());
        segmentsEntryRel.setCreateDate(serviceContext.getCreateDate(new Date()));
        segmentsEntryRel.setModifiedDate(serviceContext.getModifiedDate(new Date()));
        segmentsEntryRel.setSegmentsEntryId(segmentsEntryId);
        segmentsEntryRel.setClassNameId(classNameId);
        segmentsEntryRel.setClassPK(classPK);
        return (SegmentsEntryRel)this.segmentsEntryRelPersistence.update((BaseModel)segmentsEntryRel);
    }

    public void deleteSegmentsEntryRel(long segmentsEntryId, long classNameId, long classPK) throws PortalException {
        this.segmentsEntryRelPersistence.removeByS_CN_CPK(segmentsEntryId, classNameId, classPK);
    }

    public void deleteSegmentsEntryRels(long segmentsEntryId) {
        this.segmentsEntryRelPersistence.removeBySegmentsEntryId(segmentsEntryId);
    }

    public void deleteSegmentsEntryRels(long classNameId, long classPK) {
        this.segmentsEntryRelPersistence.removeByCN_CPK(classNameId, classPK);
    }

    public List<SegmentsEntryRel> getSegmentsEntryRels(long segmentsEntryId) {
        return this.segmentsEntryRelPersistence.findBySegmentsEntryId(segmentsEntryId);
    }

    public List<SegmentsEntryRel> getSegmentsEntryRels(long segmentsEntryId, int start, int end, OrderByComparator<SegmentsEntryRel> orderByComparator) {
        return this.segmentsEntryRelPersistence.findBySegmentsEntryId(segmentsEntryId, start, end, orderByComparator);
    }

    public List<SegmentsEntryRel> getSegmentsEntryRels(long classNameId, long classPK) {
        return this.segmentsEntryRelPersistence.findByCN_CPK(classNameId, classPK);
    }

    public List<SegmentsEntryRel> getSegmentsEntryRels(long groupId, long classNameId, long classPK) {
        return this.segmentsEntryRelPersistence.findByG_CN_CPK(groupId, classNameId, classPK);
    }

    public int getSegmentsEntryRelsCount(long segmentsEntryId) {
        return this.segmentsEntryRelPersistence.countBySegmentsEntryId(segmentsEntryId);
    }

    public int getSegmentsEntryRelsCount(long classNameId, long classPK) {
        return this.segmentsEntryRelPersistence.countByCN_CPK(classNameId, classPK);
    }

    public int getSegmentsEntryRelsCount(long groupId, long classNameId, long classPK) {
        return this.segmentsEntryRelPersistence.countByG_CN_CPK(groupId, classNameId, classPK);
    }

    public boolean hasSegmentsEntryRel(long segmentsEntryId, long classNameId, long classPK) {
        List segmentsEntryRels = this.segmentsEntryRelPersistence.findByCN_CPK(classNameId, classPK);
        for (SegmentsEntryRel segmentsEntryRel : segmentsEntryRels) {
            if (segmentsEntryRel.getSegmentsEntryId() != segmentsEntryId) continue;
            return true;
        }
        return false;
    }
}

