/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.provider;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.context.Context;
import com.liferay.segments.criteria.Criteria;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributor;
import com.liferay.segments.criteria.contributor.SegmentsCriteriaContributorRegistry;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsEntryModel;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.odata.matcher.ODataMatcher;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"segments.entry.provider.source=DEFAULT"}, service={SegmentsEntryProvider.class})
public class DefaultSegmentsEntryProvider
implements SegmentsEntryProvider {
    private static final Log _log = LogFactoryUtil.getLog(DefaultSegmentsEntryProvider.class);
    @Reference(target="(target.class.name=com.liferay.segments.context.Context)")
    private ODataMatcher _oDataMatcher;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsCriteriaContributorRegistry _segmentsCriteriaContributorRegistry;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;
    private ServiceTrackerMap<String, ODataRetriever> _serviceTrackerMap;

    @Activate
    public void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ODataRetriever.class, (String)"model.class.name");
    }

    @Deactivate
    public void deactivate() {
        this._serviceTrackerMap.close();
    }

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return new long[0];
        }
        String filterString = this._getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            List segmentsEntryRels = this._segmentsEntryRelLocalService.getSegmentsEntryRels(segmentsEntryId, start, end, null);
            Stream stream = segmentsEntryRels.stream();
            return stream.mapToLong(SegmentsEntryRelModel::getClassPK).toArray();
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this._serviceTrackerMap.getService((Object)segmentsEntry.getType());
        if (oDataRetriever == null) {
            return new long[0];
        }
        List results = oDataRetriever.getResults(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault(), start, end);
        Stream stream = results.stream();
        return stream.mapToLong(baseModel -> (Long)baseModel.getPrimaryKeyObj()).toArray();
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        SegmentsEntry segmentsEntry = this._segmentsEntryLocalService.fetchSegmentsEntry(segmentsEntryId);
        if (segmentsEntry == null) {
            return 0;
        }
        String filterString = this._getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (Validator.isNull((String)filterString)) {
            return this._segmentsEntryRelLocalService.getSegmentsEntryRelsCount(segmentsEntryId);
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this._serviceTrackerMap.getService((Object)segmentsEntry.getType());
        if (oDataRetriever == null) {
            return 0;
        }
        return oDataRetriever.getResultsCount(segmentsEntry.getCompanyId(), filterString, LocaleUtil.getDefault());
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK) {
        return this.getSegmentsEntryIds(groupId, className, classPK, null);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context) {
        return this.getSegmentsEntryIds(groupId, className, classPK, context, new long[0], new long[0]);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context, long[] filterSegmentsEntryIds, long[] segmentsEntryIds) {
        List segmentsEntries = this._segmentsEntryLocalService.getSegmentsEntries(groupId, true, "DEFAULT", className, -1, -1, null);
        if (segmentsEntries.isEmpty()) {
            return new long[0];
        }
        Stream stream = segmentsEntries.stream();
        return stream.filter(segmentsEntry -> ArrayUtil.isEmpty((long[])filterSegmentsEntryIds) || ArrayUtil.contains((long[])filterSegmentsEntryIds, (long)segmentsEntry.getSegmentsEntryId())).filter(segmentsEntry -> this._isMember(className, classPK, context, (SegmentsEntry)segmentsEntry)).mapToLong(SegmentsEntryModel::getSegmentsEntryId).toArray();
    }

    private Criteria.Conjunction _getConjunction(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return Criteria.Conjunction.AND;
        }
        return existingCriteria.getTypeConjunction(type);
    }

    private String _getFilterString(SegmentsEntry segmentsEntry, Criteria.Type type) {
        Criteria existingCriteria = segmentsEntry.getCriteriaObj();
        if (existingCriteria == null) {
            return null;
        }
        Criteria criteria = new Criteria();
        List segmentsCriteriaContributors = this._segmentsCriteriaContributorRegistry.getSegmentsCriteriaContributors(segmentsEntry.getType(), type);
        for (SegmentsCriteriaContributor segmentsCriteriaContributor : segmentsCriteriaContributors) {
            Criteria.Criterion criterion = segmentsCriteriaContributor.getCriterion(existingCriteria);
            if (criterion == null) continue;
            segmentsCriteriaContributor.contribute(criteria, criterion.getFilterString(), Criteria.Conjunction.parse((String)criterion.getConjunction()));
        }
        return criteria.getFilterString(type);
    }

    private boolean _isMember(String className, long classPK, Context context, SegmentsEntry segmentsEntry) {
        if (this._segmentsEntryRelLocalService.hasSegmentsEntryRel(segmentsEntry.getSegmentsEntryId(), this._portal.getClassNameId(className), classPK)) {
            return true;
        }
        Criteria criteria = segmentsEntry.getCriteriaObj();
        if (criteria == null || MapUtil.isEmpty((Map)criteria.getCriteria())) {
            return false;
        }
        Criteria.Conjunction contextConjunction = this._getConjunction(segmentsEntry, Criteria.Type.CONTEXT);
        String contextFilterString = this._getFilterString(segmentsEntry, Criteria.Type.CONTEXT);
        String modelFilterString = this._getFilterString(segmentsEntry, Criteria.Type.MODEL);
        if (context != null) {
            boolean defaultUser;
            boolean bl = defaultUser = !GetterUtil.getBoolean((Object)context.get("signedIn"), (boolean)true);
            if (contextConjunction.equals((Object)Criteria.Conjunction.AND) && defaultUser && Validator.isNotNull((String)modelFilterString)) {
                return false;
            }
            boolean matchesContext = false;
            if (Validator.isNotNull((String)contextFilterString)) {
                block17: {
                    try {
                        matchesContext = this._oDataMatcher.matches(contextFilterString, (Object)context);
                    }
                    catch (PortalException portalException) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)portalException, (Throwable)portalException);
                        }
                        if (!_log.isWarnEnabled()) break block17;
                        _log.warn((Object)portalException.getMessage());
                    }
                }
                if (matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.OR)) {
                    return true;
                }
                if (!matchesContext && contextConjunction.equals((Object)Criteria.Conjunction.AND)) {
                    return false;
                }
            }
            if (defaultUser) {
                return matchesContext;
            }
        }
        ODataRetriever oDataRetriever = (ODataRetriever)this._serviceTrackerMap.getService((Object)className);
        if (Validator.isNotNull((String)modelFilterString) && oDataRetriever != null) {
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(modelFilterString);
            sb.append(") and (classPK eq '");
            sb.append(classPK);
            sb.append("')");
            boolean matchesModel = false;
            try {
                int count = oDataRetriever.getResultsCount(segmentsEntry.getCompanyId(), sb.toString(), LocaleUtil.getDefault());
                if (count > 0) {
                    matchesModel = true;
                }
            }
            catch (PortalException portalException) {
                _log.error((Object)portalException, (Throwable)portalException);
            }
            Criteria.Conjunction modelConjunction = this._getConjunction(segmentsEntry, Criteria.Type.MODEL);
            if (matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.OR)) {
                return true;
            }
            if (!matchesModel && modelConjunction.equals((Object)Criteria.Conjunction.AND)) {
                return false;
            }
        }
        return true;
    }
}

