/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.processor;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.segments.model.SegmentsExperienceModel;
import com.liferay.segments.processor.SegmentsExperienceRequestProcessor;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.List;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"segments.experience.request.processor.priority:Integer=0"}, service={SegmentsExperienceRequestProcessor.class})
public class DefaultSegmentsExperienceRequestProcessor
implements SegmentsExperienceRequestProcessor {
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public long[] getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long classNameId, long classPK, long[] segmentsExperienceIds) throws PortalException {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(groupId, classNameId, classPK, true);
        Stream stream = segmentsExperiences.stream();
        return stream.filter(segmentsExperience -> segmentsExperience.getPriority() >= 0).mapToLong(SegmentsExperienceModel::getSegmentsExperienceId).toArray();
    }

    public long[] getSegmentsExperienceIds(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long groupId, long classNameId, long classPK, long[] segmentsEntryIds, long[] segmentsExperienceIds) throws PortalException {
        List segmentsExperiences = this._segmentsExperienceLocalService.getSegmentsExperiences(groupId, segmentsEntryIds, classNameId, classPK, true);
        Stream stream = segmentsExperiences.stream();
        return stream.filter(segmentsExperience -> segmentsExperience.getPriority() >= 0).mapToLong(SegmentsExperienceModel::getSegmentsExperienceId).toArray();
    }
}

