/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.internal.odata.retriever;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.segments.odata.retriever.ODataRetriever;
import com.liferay.segments.odata.search.ODataSearchAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.portal.kernel.model.Organization"}, service={ODataRetriever.class})
public class OrganizationODataRetriever
implements ODataRetriever<Organization> {
    @Reference(target="(entity.model.name=Organization)")
    private EntityModel _entityModel;
    @Reference(target="(entity.model.name=Organization)")
    private FilterParser _filterParser;
    @Reference
    private ODataSearchAdapter _oDataSearchAdapter;
    @Reference
    private OrganizationLocalService _organizationLocalService;

    public List<Organization> getResults(long companyId, String filterString, Locale locale, int start, int end) throws PortalException {
        Hits hits = this._oDataSearchAdapter.search(companyId, this._filterParser, filterString, Organization.class.getName(), this._entityModel, locale, start, end);
        return this._getOrganizations(hits);
    }

    public int getResultsCount(long companyId, String filterString, Locale locale) throws PortalException {
        return this._oDataSearchAdapter.searchCount(companyId, this._filterParser, filterString, Organization.class.getName(), this._entityModel, locale);
    }

    private Organization _getOrganization(Document document) throws PortalException {
        long organizationId = GetterUtil.getLong((String)document.get("organizationId"));
        return this._organizationLocalService.getOrganization(organizationId);
    }

    private List<Organization> _getOrganizations(Hits hits) throws PortalException {
        Document[] documents = hits.getDocs();
        ArrayList<Organization> organizations = new ArrayList<Organization>(documents.length);
        for (Document document : documents) {
            organizations.add(this._getOrganization(document));
        }
        return organizations;
    }
}

