/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.portlet.action;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactory;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCResourceCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCResourceCommand;
import com.liferay.portal.kernel.portlet.url.builder.PortletURLBuilder;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.client.model.Experiment;
import com.liferay.segments.asah.connector.internal.client.model.ExperimentStatus;
import com.liferay.segments.asah.connector.internal.configuration.SegmentsExperimentConfiguration;
import com.liferay.segments.asah.connector.internal.util.SegmentsExperimentUtil;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import com.liferay.segments.service.SegmentsExperienceService;
import com.liferay.segments.service.SegmentsExperimentRelService;
import com.liferay.segments.service.SegmentsExperimentService;
import com.liferay.staging.StagingGroupHelper;
import jakarta.portlet.MimeResponse;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.portlet.ResourceRequest;
import jakarta.portlet.ResourceResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.asah.connector.internal.configuration.SegmentsExperimentConfiguration"}, property={"jakarta.portlet.name=com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", "mvc.command.name=/segments_experiment/get_data"}, service={MVCResourceCommand.class})
public class GetDataMVCResourceCommand
extends BaseMVCResourceCommand {
    private static final Log _log = LogFactoryUtil.getLog(GetDataMVCResourceCommand.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private AsahFaroBackendClient _asahFaroBackendClient;
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private PortletURLFactory _portletURLFactory;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;
    @Reference
    private SegmentsExperienceService _segmentsExperienceService;
    private volatile SegmentsExperimentConfiguration _segmentsExperimentConfiguration;
    @Reference
    private SegmentsExperimentRelService _segmentsExperimentRelService;
    @Reference
    private SegmentsExperimentService _segmentsExperimentService;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._segmentsExperimentConfiguration = (SegmentsExperimentConfiguration)ConfigurableUtil.createConfigurable(SegmentsExperimentConfiguration.class, properties);
        this._asahFaroBackendClient = new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http);
    }

    @Deactivate
    protected void deactivate() {
        this._asahFaroBackendClient = null;
    }

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        HttpServletRequest httpServletRequest = this._portal.getHttpServletRequest((PortletRequest)resourceRequest);
        try {
            String backURL = ParamUtil.getString((PortletRequest)resourceRequest, (String)"backURL");
            String backURLTitle = ParamUtil.getString((PortletRequest)resourceRequest, (String)"backURLTitle");
            String redirect = ParamUtil.getString((PortletRequest)resourceRequest, (String)"redirect");
            long plid = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"plid");
            Layout layout = this._layoutLocalService.getLayout(plid);
            long segmentsExperienceId = ParamUtil.getLong((PortletRequest)resourceRequest, (String)"segmentsExperienceId");
            Experiment experiment = this._fetchAndSyncExperiment(layout.getGroupId(), plid, segmentsExperienceId);
            JSONPortletResponseUtil.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (Object)JSONUtil.put((String)"context", (Object)this._getContextJSONObject(backURL, backURLTitle, layout, httpServletRequest, redirect, segmentsExperienceId)).put("props", this._getPropsJSONObject(experiment, httpServletRequest, layout, this._portal.getLocale(httpServletRequest), redirect, segmentsExperienceId)));
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            JSONPortletResponseUtil.writeJSON((PortletRequest)resourceRequest, (MimeResponse)resourceResponse, (Object)JSONUtil.put((String)"error", (Object)this._language.get(httpServletRequest, "an-unexpected-error-occurred")));
        }
    }

    private Experiment _fetchAndSyncExperiment(long groupId, long plid, long segmentsExperienceId) throws PortalException {
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
        SegmentsExperiment segmentsExperiment = this._segmentsExperimentService.fetchSegmentsExperiment(groupId, segmentsExperience.getSegmentsExperienceKey(), plid);
        if (segmentsExperiment == null) {
            return null;
        }
        Experiment experiment = this._asahFaroBackendClient.getExperiment(segmentsExperiment.getCompanyId(), segmentsExperiment.getSegmentsExperimentKey());
        ExperimentStatus experimentStatus = experiment.getExperimentStatus();
        SegmentsExperimentConstants.Status status = SegmentsExperimentConstants.Status.parse((String)experimentStatus.name());
        if (status == null) {
            return null;
        }
        if (!Objects.equals(segmentsExperiment.getStatus(), status.getValue())) {
            if (experiment.getWinnerDXPVariantId() != null) {
                segmentsExperience = this._segmentsExperienceService.getSegmentsExperience(segmentsExperiment.getGroupId(), experiment.getWinnerDXPVariantId(), segmentsExperiment.getPlid());
                this._segmentsExperimentService.updateSegmentsExperimentStatus(segmentsExperiment.getSegmentsExperimentId(), segmentsExperience.getSegmentsExperienceId(), status.getValue());
            } else {
                this._segmentsExperimentService.updateSegmentsExperimentStatus(segmentsExperiment.getSegmentsExperimentId(), status.getValue());
            }
        }
        return experiment;
    }

    private SegmentsExperiment _fetchSegmentsExperiment(Layout layout, long segmentsExperienceId) throws Exception {
        SegmentsExperience segmentsExperience = this._segmentsExperienceLocalService.fetchSegmentsExperience(segmentsExperienceId);
        return this._segmentsExperimentService.fetchSegmentsExperiment(layout.getGroupId(), segmentsExperience.getSegmentsExperienceKey(), layout.getPlid());
    }

    private String _getContentPageEditorPortletNamespace() {
        return this._portal.getPortletNamespace("com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet");
    }

    private JSONObject _getContextJSONObject(String backURL, String backURLTitle, Layout layout, HttpServletRequest httpServletRequest, String redirect, long segmentsExperienceId) throws Exception {
        return JSONUtil.put((String)"contentPageEditorNamespace", (Object)this._getContentPageEditorPortletNamespace()).put("endpoints", JSONUtil.put((String)"calculateSegmentsExperimentEstimatedDurationURL", (Object)this._getSegmentsExperimentActionURL("/calculate_segments_experiment_estimated_duration", httpServletRequest)).put("createSegmentsExperimentURL", this._getSegmentsExperimentActionURL("/segments_experiment/add_segments_experiment", httpServletRequest)).put("createSegmentsVariantURL", () -> PortletURLBuilder.create((PortletURL)this._portletURLFactory.create(httpServletRequest, "com_liferay_layout_content_page_editor_web_internal_portlet_ContentPageEditorPortlet", "ACTION_PHASE")).setActionName("/layout_content_page_editor/add_segments_experience").buildString()).put("deleteSegmentsExperimentURL", this._getSegmentsExperimentActionURL("/segments_experiment/delete_segments_experiment", httpServletRequest)).put("deleteSegmentsVariantURL", this._getSegmentsExperimentActionURL("/segments_experiment/delete_segments_experiment_rel", httpServletRequest)).put("editSegmentsExperimentStatusURL", this._getSegmentsExperimentActionURL("/segments_experiment/edit_segments_experiment_status", httpServletRequest)).put("editSegmentsExperimentURL", this._getSegmentsExperimentActionURL("/segments_experiment/edit_segments_experiment", httpServletRequest)).put("editSegmentsVariantLayoutURL", this._getEditSegmentsVariantLayoutURL(backURL, backURLTitle, layout, redirect, segmentsExperienceId)).put("editSegmentsVariantURL", this._getSegmentsExperimentActionURL("/segments_experiment/edit_segments_experiment_rel", httpServletRequest)).put("runSegmentsExperimentURL", this._getSegmentsExperimentActionURL("/segments_experiment/run_segments_experiment", httpServletRequest))).put("imagesPath", this._portal.getPathContext(httpServletRequest) + "/images").put("namespace", this._portal.getPortletNamespace("com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet")).put("page", JSONUtil.put((String)"plid", (Object)layout.getPlid()).put("type", layout.getType()));
    }

    private String _getEditSegmentsVariantLayoutURL(String backURL, String backURLTitle, Layout layout, String redirect, long segmentsExperienceId) {
        Layout draftLayout = this._layoutLocalService.fetchDraftLayout(layout.getPlid());
        if (draftLayout == null) {
            return "";
        }
        if (segmentsExperienceId != -1L) {
            backURL = HttpComponentsUtil.setParameter((String)backURL, (String)"segmentsExperienceId", (long)segmentsExperienceId);
        }
        return HttpComponentsUtil.addParameters((String)redirect, (Object[])new Object[]{"p_l_back_url", backURL, "p_l_back_url_title", backURLTitle, "p_l_mode", "edit", "redirect", redirect});
    }

    private long _getLiveGroupId(long groupId) throws Exception {
        Group group = this._stagingGroupHelper.fetchLiveGroup(groupId);
        if (group != null) {
            return group.getGroupId();
        }
        return groupId;
    }

    private JSONObject _getPropsJSONObject(Experiment experiment, HttpServletRequest httpServletRequest, Layout layout, Locale locale, String redirect, long segmentsExperienceId) throws Exception {
        Group group = layout.getGroup();
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(group.getCompanyId());
        return JSONUtil.put((String)"analyticsData", (Object)JSONUtil.put((String)"cloudTrialURL", (Object)"https://www.liferay.com/products/analytics-cloud/get-started").put("isConnected", this._analyticsSettingsManager.isAnalyticsEnabled(group.getCompanyId())).put("isSynced", this._analyticsSettingsManager.isSiteIdSynced(group.getCompanyId(), this._getLiveGroupId(group.getGroupId()))).put("url", analyticsConfiguration.liferayAnalyticsURL())).put("hideSegmentsExperimentPanelURL", PortletURLBuilder.create((PortletURL)this._portletURLFactory.create(httpServletRequest, "com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", "ACTION_PHASE")).setActionName("/segments_experiment/hide_segments_experiment_panel").setRedirect(redirect).setParameter("p_l_mode", "view").buildString()).put("initialSegmentsVariants", () -> {
            JSONArray segmentsExperimentRelsJSONArray = this._jsonFactory.createJSONArray();
            SegmentsExperiment segmentsExperiment = this._fetchSegmentsExperiment(layout, segmentsExperienceId);
            if (segmentsExperiment == null) {
                return segmentsExperimentRelsJSONArray;
            }
            return JSONUtil.toJSONArray((Collection)this._segmentsExperimentRelService.getSegmentsExperimentRels(segmentsExperiment.getSegmentsExperimentId()), segmentsExperimentRel -> SegmentsExperimentUtil.toSegmentsExperimentRelJSONObject(experiment, locale, segmentsExperimentRel));
        }).put("pathToAssets", this._portal.getPathContext(httpServletRequest)).put("segmentsExperiences", JSONUtil.toJSONArray((Collection)this._segmentsExperienceService.getSegmentsExperiences(layout.getGroupId(), layout.getPlid(), true), segmentsExperience -> JSONUtil.put((String)"name", (Object)segmentsExperience.getName(locale)).put("segmentsExperienceId", String.valueOf(segmentsExperience.getSegmentsExperienceId())).put("segmentsExperiment", SegmentsExperimentUtil.toSegmentsExperimentJSONObject(analyticsConfiguration, group, locale, this._fetchSegmentsExperiment(layout, segmentsExperience.getSegmentsExperienceId()))))).put("segmentsExperiment", SegmentsExperimentUtil.toSegmentsExperimentJSONObject(analyticsConfiguration, group, locale, this._fetchSegmentsExperiment(layout, segmentsExperienceId))).put("segmentsExperimentGoals", JSONUtil.toJSONArray((Object[])SegmentsExperimentConstants.Goal.values(), goal -> {
            if (!ArrayUtil.contains((Object[])this._segmentsExperimentConfiguration.goalsEnabled(), (Object)goal.name())) {
                return null;
            }
            return JSONUtil.put((String)"label", (Object)this._language.get(locale, goal.getLabel())).put("value", goal.getLabel());
        })).put("selectedSegmentsExperienceId", segmentsExperienceId).put("winnerSegmentsVariantId", () -> {
            SegmentsExperiment segmentsExperiment = this._fetchSegmentsExperiment(layout, segmentsExperienceId);
            if (segmentsExperiment == null) {
                return "";
            }
            long winnerSegmentsExperienceId = segmentsExperiment.getWinnerSegmentsExperienceId();
            if (winnerSegmentsExperienceId == -1L) {
                return "";
            }
            return String.valueOf(winnerSegmentsExperienceId);
        });
    }

    private String _getSegmentsExperimentActionURL(String action, HttpServletRequest httpServletRequest) {
        return PortletURLBuilder.create((PortletURL)this._portletURLFactory.create(httpServletRequest, "com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", "ACTION_PHASE")).setActionName(action).setParameter("p_l_mode", "view").buildString();
    }
}

