/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.portlet.action;

import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.JSONPortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.client.model.util.ExperimentSettingsUtil;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.service.SegmentsExperimentLocalService;
import com.liferay.segments.service.SegmentsExperimentRelLocalService;
import jakarta.portlet.ActionRequest;
import jakarta.portlet.ActionResponse;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_segments_experiment_web_internal_portlet_SegmentsExperimentPortlet", "mvc.command.name=/calculate_segments_experiment_estimated_duration"}, service={MVCActionCommand.class})
public class CalculateSegmentsExperimentEstimatedDurationMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(CalculateSegmentsExperimentEstimatedDurationMVCActionCommand.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private AsahFaroBackendClient _asahFaroBackendClient;
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsExperimentLocalService _segmentsExperimentLocalService;
    @Reference
    private SegmentsExperimentRelLocalService _segmentsExperimentRelLocalService;

    @Activate
    protected void activate() {
        this._asahFaroBackendClient = new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http);
    }

    @Deactivate
    protected void deactivate() {
        this._asahFaroBackendClient = null;
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        JSONObject jsonObject = null;
        try {
            jsonObject = this._calculateSegmentsExperimentEstimatedDaysDurationJSONObject(actionRequest);
        }
        catch (Throwable throwable) {
            _log.error((Object)throwable, throwable);
            HttpServletResponse httpServletResponse = this._portal.getHttpServletResponse((PortletResponse)actionResponse);
            httpServletResponse.setStatus(400);
            jsonObject = JSONUtil.put((String)"error", (Object)this._language.get(themeDisplay.getRequest(), "an-unexpected-error-occurred"));
        }
        JSONPortletResponseUtil.writeJSON((PortletRequest)actionRequest, (PortletResponse)actionResponse, (Object)jsonObject);
        this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
    }

    private Long _calculateSegmentsExperimentEstimatedDaysDuration(double confidenceLevel, SegmentsExperiment segmentsExperiment, Map<String, Double> segmentsExperienceKeySplitMap) throws Exception {
        if (!this._analyticsSettingsManager.isAnalyticsEnabled(segmentsExperiment.getCompanyId())) {
            return null;
        }
        return this._asahFaroBackendClient.calculateExperimentEstimatedDaysDuration(segmentsExperiment.getCompanyId(), segmentsExperiment.getSegmentsExperimentKey(), ExperimentSettingsUtil.toExperimentSettings(confidenceLevel, segmentsExperienceKeySplitMap, segmentsExperiment));
    }

    private JSONObject _calculateSegmentsExperimentEstimatedDaysDurationJSONObject(ActionRequest actionRequest) throws PortalException {
        return JSONUtil.put((String)"segmentsExperimentEstimatedDaysDuration", () -> {
            long segmentsExperimentId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"segmentsExperimentId");
            SegmentsExperiment segmentsExperiment = this._segmentsExperimentLocalService.getSegmentsExperiment(segmentsExperimentId);
            String segmentsExperimentRels = ParamUtil.getString((PortletRequest)actionRequest, (String)"segmentsExperimentRels");
            JSONObject segmentsExperimentRelsJSONObject = this._jsonFactory.createJSONObject(segmentsExperimentRels);
            Iterator iterator = segmentsExperimentRelsJSONObject.keys();
            HashMap<String, Double> segmentsExperienceKeySplitMap = new HashMap<String, Double>();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                SegmentsExperimentRel segmentsExperimentRel = this._segmentsExperimentRelLocalService.getSegmentsExperimentRel(GetterUtil.getLong((String)key));
                segmentsExperienceKeySplitMap.put(segmentsExperimentRel.getSegmentsExperienceKey(), segmentsExperimentRelsJSONObject.getDouble(key));
            }
            return this._calculateSegmentsExperimentEstimatedDaysDuration(ParamUtil.getDouble((PortletRequest)actionRequest, (String)"confidenceLevel"), segmentsExperiment, segmentsExperienceKeySplitMap);
        });
    }
}

