/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.client.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.client.util.FilterUtil;
import java.util.ArrayList;
import java.util.List;

public class FilterBuilder {
    private final List<String> _filters = new ArrayList<String>();
    private final List<String> _requiredFilters = new ArrayList<String>();

    public void addFilter(String fieldName, String operator, Object value) {
        this._addFilter(fieldName, operator, value, true);
    }

    public void addNullFilter(String fieldName, String operator) {
        this._requiredFilters.add(FilterUtil.getNullFilter(fieldName, operator));
    }

    public String build() {
        StringBundler sb = new StringBundler();
        if (!this._filters.isEmpty()) {
            this._buildQueries(sb, this._filters, " or ");
            if (!this._requiredFilters.isEmpty()) {
                sb.append(" and ");
            }
        }
        if (!this._requiredFilters.isEmpty()) {
            this._buildQueries(sb, this._requiredFilters, " and ");
        }
        return sb.toString();
    }

    private void _addFilter(String fieldName, String operator, Object value, boolean required) {
        if (Validator.isNull((String)fieldName) || Validator.isNull((String)operator) || Validator.isNull((Object)value)) {
            return;
        }
        if (value instanceof String) {
            value = this._getValue(value);
        }
        String filter = FilterUtil.getFilter(fieldName, operator, value);
        if (required) {
            this._requiredFilters.add(filter);
        } else {
            this._filters.add(filter);
        }
    }

    private void _buildQueries(StringBundler sb, List<String> filterQueries, String operator) {
        sb.append("(");
        for (String filterQuery : filterQueries) {
            sb.append(filterQuery);
            sb.append(operator);
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
    }

    private String _getValue(Object value) {
        String valueString = (String)value;
        return valueString.replaceAll("'", "''");
    }
}

