/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.client.model.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropsValues;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.client.model.Experiment;
import com.liferay.segments.asah.connector.internal.client.model.ExperimentStatus;
import com.liferay.segments.asah.connector.internal.client.model.ExperimentType;
import com.liferay.segments.asah.connector.internal.client.model.Goal;
import com.liferay.segments.asah.connector.internal.client.model.GoalMetric;
import com.liferay.segments.asah.connector.internal.client.model.util.DXPVariantUtil;
import com.liferay.segments.constants.SegmentsEntryConstants;
import com.liferay.segments.constants.SegmentsExperimentConstants;
import com.liferay.segments.exception.SegmentsExperimentGoalException;
import com.liferay.segments.model.SegmentsEntry;
import com.liferay.segments.model.SegmentsExperience;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;

public class ExperimentUtil {
    public static Experiment toExperiment(CompanyLocalService companyLocalService, String dataSourceId, GroupLocalService groupLocalService, Layout layout, Locale locale, Portal portal, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService, SegmentsExperiment segmentsExperiment) throws PortalException {
        return ExperimentUtil.toExperiment(ExperimentUtil._getChannelId(groupLocalService, layout), dataSourceId, SegmentsEntryConstants.getDefaultSegmentsEntryName((Locale)locale), layout, locale, ExperimentUtil._getLayoutFullURL(portal, companyLocalService, groupLocalService, layout), segmentsEntryLocalService, segmentsExperienceLocalService, segmentsExperiment);
    }

    public static Experiment toExperiment(CompanyLocalService companyLocalService, String dataSourceId, GroupLocalService groupLocalService, LayoutLocalService layoutLocalService, Locale locale, Portal portal, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService, SegmentsExperiment segmentsExperiment) throws PortalException {
        return ExperimentUtil.toExperiment(companyLocalService, dataSourceId, groupLocalService, layoutLocalService.getLayout(segmentsExperiment.getPlid()), locale, portal, segmentsEntryLocalService, segmentsExperienceLocalService, segmentsExperiment);
    }

    protected static Experiment toExperiment(String channelId, String dataSourceId, String defaultSegmentsEntryName, Layout layout, Locale locale, String pageURL, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService, SegmentsExperiment segmentsExperiment) throws PortalException {
        Experiment experiment = new Experiment();
        experiment.setChannelId(channelId);
        experiment.setConfidenceLevel(segmentsExperiment.getConfidenceLevel() * 100.0);
        experiment.setCreateDate(segmentsExperiment.getCreateDate());
        experiment.setDataSourceId(dataSourceId);
        experiment.setDescription(segmentsExperiment.getDescription());
        experiment.setDXPGroupId(layout.getGroupId());
        experiment.setDXPLayoutId(layout.getUuid());
        List segmentsExperimentRels = segmentsExperiment.getSegmentsExperimentRels();
        if (ListUtil.isNotEmpty((List)segmentsExperimentRels)) {
            experiment.setDXPVariants(DXPVariantUtil.toDXPVariantList(locale, segmentsExperienceLocalService, segmentsExperimentRels));
        }
        experiment.setExperimentStatus(ExperimentUtil._toExperimentStatus(segmentsExperiment.getStatus()));
        experiment.setExperimentType(ExperimentType.parse(segmentsExperiment.getType()));
        experiment.setGoal(ExperimentUtil._toExperimentGoal(segmentsExperiment));
        experiment.setId(segmentsExperiment.getSegmentsExperimentKey());
        experiment.setModifiedDate(segmentsExperiment.getModifiedDate());
        experiment.setName(segmentsExperiment.getName());
        experiment.setPageRelativePath(layout.getFriendlyURL());
        experiment.setPageTitle(layout.getTitle(locale));
        experiment.setPageURL(pageURL);
        experiment.setPublishable(true);
        if (segmentsExperiment.getStatus() == 2 || segmentsExperiment.getStatus() == 6 && segmentsExperiment.getWinnerSegmentsExperienceId() > 0L) {
            experiment.setPublishedDXPVariantId(ExperimentUtil._getSegmentsExperienceKey(segmentsExperienceLocalService.getSegmentsExperience(segmentsExperiment.getWinnerSegmentsExperienceId())));
        }
        SegmentsExperience segmentsExperience = segmentsExperienceLocalService.getSegmentsExperience(segmentsExperiment.getSegmentsExperienceId());
        experiment.setDXPExperienceId(ExperimentUtil._getSegmentsExperienceKey(segmentsExperience));
        experiment.setDXPExperienceName(segmentsExperience.getName(locale));
        SegmentsEntry segmentsEntry = segmentsEntryLocalService.fetchSegmentsEntry(segmentsExperience.getSegmentsEntryId());
        if (segmentsEntry == null) {
            experiment.setDXPSegmentId("DEFAULT");
            experiment.setDXPSegmentName(defaultSegmentsEntryName);
        } else {
            experiment.setDXPSegmentId(segmentsEntry.getSegmentsEntryKey());
            experiment.setDXPSegmentName(segmentsEntry.getName(locale));
        }
        return experiment;
    }

    private static String _getChannelId(GroupLocalService groupLocalService, Layout layout) throws PortalException {
        Group group = groupLocalService.getGroup(layout.getGroupId());
        return group.getTypeSettingsProperty("analyticsChannelId");
    }

    private static String _getLayoutFullURL(Portal portal, CompanyLocalService companyLocalService, GroupLocalService groupLocalService, Layout layout) throws PortalException {
        long parentGroupId;
        StringBundler sb = new StringBundler(4);
        Group group = groupLocalService.getGroup(layout.getGroupId());
        if (group.isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = groupLocalService.getGroup(parentGroupId);
        }
        String virtualHostname = null;
        LayoutSet layoutSet = layout.getLayoutSet();
        NavigableMap virtualHostnames = layoutSet.getVirtualHostnames();
        if (!virtualHostnames.isEmpty()) {
            virtualHostname = (String)virtualHostnames.firstKey();
        } else {
            Company company = companyLocalService.getCompany(layout.getCompanyId());
            virtualHostname = company.getVirtualHostname();
        }
        boolean secure = StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL);
        sb.append(portal.getPortalURL(virtualHostname, portal.getPortalServerPort(secure), secure));
        if (layout.isPrivateLayout()) {
            sb.append(portal.getPathFriendlyURLPrivateGroup());
        } else {
            sb.append(portal.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    private static String _getSegmentsExperienceKey(SegmentsExperience segmentsExperience) {
        UnicodeProperties typeSettingsUnicodeProperties = segmentsExperience.getTypeSettingsUnicodeProperties();
        String segmentsExperimentSegmentsExperienceKey = (String)typeSettingsUnicodeProperties.get((Object)"segmentsExperimentSegmentsExperienceKey");
        if (Validator.isNotNull((String)segmentsExperimentSegmentsExperienceKey)) {
            return segmentsExperimentSegmentsExperienceKey;
        }
        return segmentsExperience.getSegmentsExperienceKey();
    }

    private static Goal _toExperimentGoal(SegmentsExperiment segmentsExperiment) throws SegmentsExperimentGoalException {
        SegmentsExperimentConstants.Goal goal = SegmentsExperimentConstants.Goal.parse((String)segmentsExperiment.getGoal());
        if (goal != null) {
            String goalName = goal.name();
            for (GoalMetric goalMetric : GoalMetric.values()) {
                if (!goalName.equals(goalMetric.name())) continue;
                return new Goal(GoalMetric.valueOf(goalName), segmentsExperiment.getGoalTarget());
            }
        }
        throw new SegmentsExperimentGoalException();
    }

    private static ExperimentStatus _toExperimentStatus(int status) {
        if (status == 2) {
            return ExperimentStatus.COMPLETED;
        }
        if (status == 4) {
            return ExperimentStatus.FINISHED_NO_WINNER;
        }
        if (status == 3) {
            return ExperimentStatus.FINISHED_WINNER;
        }
        if (status == 5) {
            return ExperimentStatus.PAUSED;
        }
        if (status == 1) {
            return ExperimentStatus.RUNNING;
        }
        if (status == 7) {
            return ExperimentStatus.SCHEDULED;
        }
        if (status == 6) {
            return ExperimentStatus.TERMINATED;
        }
        return ExperimentStatus.DRAFT;
    }
}

