/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.provider;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.segments.asah.connector.internal.cache.AsahInterestTermCache;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"segments.entry.provider.source=ASAH_FARO_BACKEND"}, service={AsahInterestTermProvider.class})
public class AsahInterestTermProvider {
    private static final Log _log = LogFactoryUtil.getLog(AsahInterestTermProvider.class);
    @Reference
    private AsahInterestTermCache _asahInterestTermCache;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;
    @Reference
    private MessageBus _messageBus;

    public String[] getInterestTerms(long companyId, String userId) {
        String[] cachedInterestTerms = this._asahInterestTermCache.getInterestTerms(userId);
        if (cachedInterestTerms == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Asah interest terms cache not found for user ID " + userId));
            }
            this._sendMessage(companyId, userId);
            return new String[0];
        }
        return cachedInterestTerms;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/interest_terms");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._destinationServiceRegistration.unregister();
    }

    private void _sendMessage(long companyId, String userId) {
        Message message = new Message();
        message.put("companyId", (Object)companyId);
        message.put("userId", (Object)userId);
        this._messageBus.sendMessage("liferay/interest_terms", message);
    }
}

