/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.model.listener;

import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClientImpl;
import com.liferay.segments.asah.connector.internal.processor.AsahSegmentsExperimentProcessor;
import com.liferay.segments.asah.connector.internal.util.AsahUtil;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class SegmentsExperimentModelListener
extends BaseModelListener<SegmentsExperiment> {
    private static final Log _log = LogFactoryUtil.getLog(SegmentsExperimentModelListener.class);
    @Reference
    private AnalyticsSettingsManager _analyticsSettingsManager;
    private AsahSegmentsExperimentProcessor _asahSegmentsExperimentProcessor;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public void onAfterUpdate(SegmentsExperiment originalSegmentsExperiment, SegmentsExperiment segmentsExperiment) throws ModelListenerException {
        try {
            if (AsahUtil.isSkipAsahEvent(this._analyticsSettingsManager, segmentsExperiment.getCompanyId(), segmentsExperiment.getGroupId()) || originalSegmentsExperiment.getStatus() != segmentsExperiment.getStatus() && segmentsExperiment.getStatus() == 4 || segmentsExperiment.getStatus() == 3) {
                return;
            }
            this._asahSegmentsExperimentProcessor.processUpdateSegmentsExperiment(segmentsExperiment);
        }
        catch (Exception exception) {
            throw new ModelListenerException("Unable to update segments experiment " + segmentsExperiment.getSegmentsExperimentId(), (Throwable)exception);
        }
    }

    public void onBeforeCreate(SegmentsExperiment segmentsExperiment) throws ModelListenerException {
        try {
            if (AsahUtil.isSkipAsahEvent(this._analyticsSettingsManager, segmentsExperiment.getCompanyId(), segmentsExperiment.getGroupId())) {
                return;
            }
            this._asahSegmentsExperimentProcessor.processAddSegmentsExperiment(segmentsExperiment);
        }
        catch (Exception exception) {
            throw new ModelListenerException("Unable to add segments experiment " + segmentsExperiment.getSegmentsExperimentId(), (Throwable)exception);
        }
    }

    public void onBeforeRemove(SegmentsExperiment segmentsExperiment) throws ModelListenerException {
        block3: {
            try {
                if (AsahUtil.isSkipAsahEvent(this._analyticsSettingsManager, segmentsExperiment.getCompanyId(), segmentsExperiment.getGroupId()) || segmentsExperiment.getStatus() == 8) {
                    return;
                }
                this._asahSegmentsExperimentProcessor.processDeleteSegmentsExperiment(segmentsExperiment);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Unable to delete segments experiment " + segmentsExperiment.getSegmentsExperimentId()), (Throwable)exception);
            }
        }
    }

    @Activate
    protected void activate() {
        this._asahSegmentsExperimentProcessor = new AsahSegmentsExperimentProcessor(this._analyticsSettingsManager, new AsahFaroBackendClientImpl(this._analyticsSettingsManager, this._http), this._companyLocalService, this._groupLocalService, this._layoutLocalService, this._portal, this._segmentsEntryLocalService, this._segmentsExperienceLocalService);
    }

    @Deactivate
    protected void deactivate() {
        this._asahSegmentsExperimentProcessor = null;
    }
}

