/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NestableRuntimeException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.data.binding.ExperimentJSONObjectMapper;
import com.liferay.segments.asah.connector.internal.client.data.binding.IndividualJSONObjectMapper;
import com.liferay.segments.asah.connector.internal.client.data.binding.IndividualSegmentJSONObjectMapper;
import com.liferay.segments.asah.connector.internal.client.data.binding.InterestTermsJSONObjectMapper;
import com.liferay.segments.asah.connector.internal.client.model.DXPVariants;
import com.liferay.segments.asah.connector.internal.client.model.Experiment;
import com.liferay.segments.asah.connector.internal.client.model.ExperimentSettings;
import com.liferay.segments.asah.connector.internal.client.model.Individual;
import com.liferay.segments.asah.connector.internal.client.model.IndividualSegment;
import com.liferay.segments.asah.connector.internal.client.model.Results;
import com.liferay.segments.asah.connector.internal.client.model.Topic;
import com.liferay.segments.asah.connector.internal.client.util.FilterBuilder;
import com.liferay.segments.asah.connector.internal.client.util.OrderByField;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AsahFaroBackendClientImpl
implements AsahFaroBackendClient {
    private static final String _ERROR_MSG = "Unable to handle response: ";
    private static final String _PATH_EXPERIMENTS = "api/1.0/experiments";
    private static final String _PATH_EXPERIMENTS_DXP_VARIANTS = "api/1.0/experiments/{experimentId}/dxp-variants";
    private static final String _PATH_EXPERIMENTS_ESTIMATED_DAYS_DURATION = "api/1.0/experiments/{experimentId}/estimated-days-duration";
    private static final String _PATH_EXPERIMENTS_EXPERIMENT = "api/1.0/experiments/{experimentId}";
    private static final String _PATH_INDIVIDUAL_SEGMENTS = "api/1.0/individual-segments";
    private static final String _PATH_INDIVIDUAL_SEGMENTS_INDIVIDUALS = "api/1.0/individual-segments/{id}/individuals";
    private static final String _PATH_INDIVIDUALS = "api/1.0/individuals";
    private static final String _PATH_INTERESTS_TERMS = "api/1.0/interests/terms/{userId}";
    private static final Log _log = LogFactoryUtil.getLog(AsahFaroBackendClientImpl.class);
    private static final ExperimentJSONObjectMapper _experimentJSONObjectMapper = new ExperimentJSONObjectMapper();
    private static final IndividualJSONObjectMapper _individualJSONObjectMapper = new IndividualJSONObjectMapper();
    private static final IndividualSegmentJSONObjectMapper _individualSegmentJSONObjectMapper = new IndividualSegmentJSONObjectMapper();
    private static final InterestTermsJSONObjectMapper _interestTermsJSONObjectMapper = new InterestTermsJSONObjectMapper();
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        }
    };
    private final AnalyticsSettingsManager _analyticsSettingsManager;
    private final Http _http;

    public AsahFaroBackendClientImpl(AnalyticsSettingsManager analyticsSettingsManager, Http http) {
        this._analyticsSettingsManager = analyticsSettingsManager;
        this._http = http;
    }

    @Override
    public Experiment addExperiment(long companyId, Experiment experiment) {
        if (experiment == null) {
            return null;
        }
        try {
            return (Experiment)this._post(companyId, _PATH_EXPERIMENTS, experiment, response -> (Experiment)_objectMapper.readValue(response, Experiment.class));
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Long calculateExperimentEstimatedDaysDuration(long companyId, String experimentId, ExperimentSettings experimentSettings) {
        try {
            return (Long)this._post(companyId, StringUtil.replace((String)_PATH_EXPERIMENTS_ESTIMATED_DAYS_DURATION, (String)"{experimentId}", (String)experimentId), experimentSettings, Long::valueOf);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void deleteExperiment(long companyId, String experimentId) {
        if (experimentId == null) {
            return;
        }
        try {
            this._delete(companyId, StringUtil.replace((String)_PATH_EXPERIMENTS_EXPERIMENT, (String)"{experimentId}", (String)experimentId));
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Experiment getExperiment(long companyId, String experimentId) {
        if (experimentId == null) {
            return null;
        }
        try {
            return (Experiment)this._get(companyId, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), StringUtil.replace((String)_PATH_EXPERIMENTS_EXPERIMENT, (String)"{experimentId}", (String)experimentId), _experimentJSONObjectMapper::map);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Individual getIndividual(long companyId, String individualPK) {
        try {
            AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(companyId);
            FilterBuilder filterBuilder = new FilterBuilder();
            filterBuilder.addFilter("dataSourceId", " eq ", analyticsConfiguration.liferayAnalyticsDataSourceId());
            filterBuilder.addFilter("dataSourceIndividualPKs/individualPKs", " eq ", individualPK);
            MultivaluedHashMap uriVariables = new MultivaluedHashMap();
            uriVariables.putSingle((Object)"includeAnonymousUsers", (Object)true);
            Results individualResults = (Results)this._get(companyId, this._getParameters(filterBuilder, "demographics/?/value", 1, 1, Collections.emptyList(), (MultivaluedMap<String, Object>)uriVariables), _PATH_INDIVIDUALS, _individualJSONObjectMapper::mapToResults);
            List items = individualResults.getItems();
            if (ListUtil.isNotEmpty(items)) {
                return (Individual)items.get(0);
            }
            return null;
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Results<Individual> getIndividualResults(long companyId, String individualSegmentId, int cur, int delta, List<OrderByField> orderByFields) {
        try {
            return (Results)this._get(companyId, this._getParameters(new FilterBuilder(), "demographics/?/value", cur, delta, orderByFields), StringUtil.replace((String)_PATH_INDIVIDUAL_SEGMENTS_INDIVIDUALS, (String)"{id}", (String)individualSegmentId), _individualJSONObjectMapper::mapToResults);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Results<IndividualSegment> getIndividualSegmentResults(long companyId, int cur, int delta, List<OrderByField> orderByFields) {
        FilterBuilder filterBuilder = new FilterBuilder();
        filterBuilder.addFilter("status", " eq ", IndividualSegment.Status.ACTIVE.name());
        try {
            AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(companyId);
            MultivaluedMap<String, Object> parameters = this._getParameters(filterBuilder, "fields/?/value", cur, delta, orderByFields);
            parameters.putSingle((Object)"dataSourceId", (Object)analyticsConfiguration.liferayAnalyticsDataSourceId());
            return (Results)this._get(companyId, parameters, _PATH_INDIVIDUAL_SEGMENTS, _individualSegmentJSONObjectMapper::mapToResults);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException(_ERROR_MSG + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Results<Topic> getInterestTermsResults(long companyId, String userId) {
        try {
            return (Results)this._get(companyId, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), StringUtil.replace((String)_PATH_INTERESTS_TERMS, (String)"{userId}", (String)userId), _interestTermsJSONObjectMapper::mapToResults);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException("Unable to handle JSON response: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void updateExperiment(long companyId, Experiment experiment) {
        if (Validator.isNull((String)experiment.getId())) {
            throw new IllegalArgumentException("Experiment ID is null");
        }
        try {
            this._patch(companyId, StringUtil.replace((String)_PATH_EXPERIMENTS_EXPERIMENT, (String)"{experimentId}", (String)experiment.getId()), experiment);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException("Unable to handle JSON response: " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public void updateExperimentDXPVariants(long companyId, String experimentId, DXPVariants dxpVariants) {
        if (Validator.isNull((String)experimentId)) {
            throw new IllegalArgumentException("Experiment ID is null");
        }
        if (dxpVariants == null) {
            throw new IllegalArgumentException("DXPVariants is null");
        }
        try {
            this._put(companyId, StringUtil.replace((String)_PATH_EXPERIMENTS_DXP_VARIANTS, (String)"{experimentId}", (String)experimentId), dxpVariants);
        }
        catch (Exception exception) {
            throw new NestableRuntimeException("Unable to handle JSON response: " + exception.getMessage(), (Throwable)exception);
        }
    }

    private String _delete(long companyId, String path) throws Exception {
        return this._invoke(this._getHttpOptions(companyId, Http.Method.DELETE, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), path));
    }

    private <T> T _get(long companyId, MultivaluedMap<String, Object> parameters, String path, UnsafeFunction<String, T, Exception> unsafeFunction) throws Exception {
        return (T)unsafeFunction.apply((Object)this._invoke(this._getHttpOptions(companyId, Http.Method.GET, parameters, path)));
    }

    private Map<String, String> _getHeaders(AnalyticsConfiguration analyticsConfiguration) {
        return HashMapBuilder.put((Object)"Accept", (Object)"application/json").put((Object)"Content-Type", (Object)"application/json").put((Object)"OSB-Asah-Faro-Backend-Security-Signature", (Object)analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature()).put((Object)"OSB-Asah-Project-ID", (Object)analyticsConfiguration.liferayAnalyticsProjectId()).build();
    }

    private Http.Options _getHttpOptions(long companyId, Http.Method method, MultivaluedMap<String, Object> parameters, String path) throws Exception {
        Http.Options httpOptions = new Http.Options();
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(companyId);
        httpOptions.setHeaders(this._getHeaders(analyticsConfiguration));
        String url = StringBundler.concat((String[])new String[]{analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/", path});
        for (Map.Entry entry : parameters.entrySet()) {
            for (Object value : (List)entry.getValue()) {
                url = HttpComponentsUtil.addParameter((String)url, (String)((String)entry.getKey()), (String)value.toString());
            }
        }
        httpOptions.setLocation(url);
        httpOptions.setMethod(method);
        return httpOptions;
    }

    private MultivaluedMap<String, Object> _getParameters(FilterBuilder filterBuilder, String fieldNameContext, int cur, int delta, List<OrderByField> orderByFields) {
        MultivaluedMap<String, Object> uriVariables = this._getUriVariables(cur, delta, orderByFields, fieldNameContext);
        uriVariables.putSingle((Object)"filter", (Object)filterBuilder.build());
        return uriVariables;
    }

    private MultivaluedMap<String, Object> _getParameters(FilterBuilder filterBuilder, String fieldNameContext, int cur, int delta, List<OrderByField> orderByFields, MultivaluedMap<String, Object> initialUriVariables) {
        MultivaluedMap<String, Object> uriVariables = this._getUriVariables(cur, delta, orderByFields, fieldNameContext, initialUriVariables);
        uriVariables.putSingle((Object)"filter", (Object)filterBuilder.build());
        return uriVariables;
    }

    private MultivaluedMap<String, Object> _getUriVariables(int cur, int delta, List<OrderByField> orderByFields, String fieldNameContext) {
        return this._getUriVariables(cur, delta, orderByFields, fieldNameContext, (MultivaluedMap<String, Object>)new MultivaluedHashMap());
    }

    private MultivaluedMap<String, Object> _getUriVariables(int cur, int delta, List<OrderByField> orderByFields, String fieldNameContext, MultivaluedMap<String, Object> uriVariables) {
        uriVariables.putSingle((Object)"page", (Object)(cur - 1));
        uriVariables.putSingle((Object)"size", (Object)delta);
        if (ListUtil.isEmpty(orderByFields)) {
            return uriVariables;
        }
        ArrayList<CallSite> sort = new ArrayList<CallSite>();
        for (OrderByField orderByField : orderByFields) {
            String fieldName = orderByField.getFieldName();
            if (!orderByField.isSystem() && fieldNameContext != null) {
                fieldName = StringUtil.replace((String)fieldNameContext, (char)'?', (String)fieldName);
            }
            sort.add((CallSite)((Object)(fieldName + "," + orderByField.getOrderBy())));
        }
        uriVariables.put((Object)"sort", sort);
        return uriVariables;
    }

    private String _invoke(Http.Options httpOptions) throws Exception {
        String response = this._http.URLtoString(httpOptions);
        Http.Response httpResponse = httpOptions.getResponse();
        if (httpResponse.getResponseCode() != 200) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + httpResponse.getResponseCode()));
            }
            throw new NestableRuntimeException(StringBundler.concat((Object[])new Object[]{"Unexpected response status ", httpResponse.getResponseCode(), " with response message: ", response}));
        }
        return response;
    }

    private String _patch(long companyId, String path, Object object) throws Exception {
        Http.Options httpOptions = this._getHttpOptions(companyId, Http.Method.PATCH, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), path);
        httpOptions.setBody(_objectMapper.writeValueAsString(object), "application/json", "UTF-8");
        return this._invoke(httpOptions);
    }

    private <T> T _post(long companyId, String path, Object object, UnsafeFunction<String, T, Exception> unsafeFunction) throws Exception {
        Http.Options httpOptions = this._getHttpOptions(companyId, Http.Method.POST, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), path);
        httpOptions.setBody(_objectMapper.writeValueAsString(object), "application/json", "UTF-8");
        String response = this._invoke(httpOptions);
        if (Validator.isNull((String)response)) {
            return null;
        }
        return (T)unsafeFunction.apply((Object)response);
    }

    private String _put(long companyId, String path, Object object) throws Exception {
        Http.Options httpOptions = this._getHttpOptions(companyId, Http.Method.PUT, (MultivaluedMap<String, Object>)new MultivaluedHashMap(), path);
        httpOptions.setBody(_objectMapper.writeValueAsString(object), "application/json", "UTF-8");
        return this._invoke(httpOptions);
    }
}

