/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.provider;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.cache.AsahSegmentsEntryCache;
import com.liferay.segments.context.Context;
import com.liferay.segments.model.SegmentsEntryModel;
import com.liferay.segments.model.SegmentsEntryRelModel;
import com.liferay.segments.provider.SegmentsEntryProvider;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsEntryRelLocalService;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"segments.entry.provider.order:Integer=50", "segments.entry.provider.source=ASAH_FARO_BACKEND"}, service={SegmentsEntryProvider.class})
public class AsahSegmentsEntryProvider
implements SegmentsEntryProvider {
    private static final Log _log = LogFactoryUtil.getLog(AsahSegmentsEntryProvider.class);
    @Reference
    private AsahSegmentsEntryCache _asahSegmentsEntryCache;
    @Reference
    private Portal _portal;
    @Reference
    private SegmentsEntryLocalService _segmentsEntryLocalService;
    @Reference
    private SegmentsEntryRelLocalService _segmentsEntryRelLocalService;

    public long[] getSegmentsEntryClassPKs(long segmentsEntryId, int start, int end) throws PortalException {
        return ListUtil.toLongArray((List)this._segmentsEntryRelLocalService.getSegmentsEntryRels(segmentsEntryId, start, end, null), SegmentsEntryRelModel::getClassPK);
    }

    public int getSegmentsEntryClassPKsCount(long segmentsEntryId) throws PortalException {
        return this._segmentsEntryRelLocalService.getSegmentsEntryRelsCount(segmentsEntryId);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context) throws PortalException {
        return this.getSegmentsEntryIds(groupId, className, classPK, context, new long[0], new long[0]);
    }

    public long[] getSegmentsEntryIds(long groupId, String className, long classPK, Context context, long[] filterSegmentsEntryIds, long[] segmentsEntryIds) {
        if (context == null) {
            return new long[0];
        }
        if (GetterUtil.getBoolean((Object)context.get((Object)"signedIn"))) {
            List segmentsEntries = this._segmentsEntryLocalService.getSegmentsEntries(groupId, "ASAH_FARO_BACKEND", -1, -1, null);
            if (segmentsEntries.isEmpty()) {
                return new long[0];
            }
            segmentsEntries = ListUtil.filter((List)segmentsEntries, segmentsEntry -> (ArrayUtil.isEmpty((long[])filterSegmentsEntryIds) || ArrayUtil.contains((long[])filterSegmentsEntryIds, (long)segmentsEntry.getSegmentsEntryId())) && this._segmentsEntryRelLocalService.hasSegmentsEntryRel(segmentsEntry.getSegmentsEntryId(), this._portal.getClassNameId(className), classPK));
            segmentsEntries.sort((segmentsEntry1, segmentsEntry2) -> {
                Date modifiedDate = segmentsEntry2.getModifiedDate();
                return modifiedDate.compareTo(segmentsEntry1.getModifiedDate());
            });
            return ListUtil.toLongArray((List)segmentsEntries, SegmentsEntryModel::getSegmentsEntryId);
        }
        String userId = GetterUtil.getString((Object)context.get((Object)"segmentsAnonymousUserId"));
        if (Validator.isNull((String)userId)) {
            return new long[0];
        }
        long[] cachedSegmentsEntryIds = this._asahSegmentsEntryCache.getSegmentsEntryIds(userId);
        if (cachedSegmentsEntryIds == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Asah segments cache not found for user ID " + userId));
            }
            return new long[0];
        }
        return cachedSegmentsEntryIds;
    }
}

