/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.processor;

import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.analytics.settings.rest.manager.AnalyticsSettingsManager;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.segments.asah.connector.internal.client.AsahFaroBackendClient;
import com.liferay.segments.asah.connector.internal.client.model.Experiment;
import com.liferay.segments.asah.connector.internal.client.model.util.DXPVariantUtil;
import com.liferay.segments.asah.connector.internal.client.model.util.ExperimentUtil;
import com.liferay.segments.model.SegmentsExperiment;
import com.liferay.segments.model.SegmentsExperimentRel;
import com.liferay.segments.service.SegmentsEntryLocalService;
import com.liferay.segments.service.SegmentsExperienceLocalService;
import java.util.List;

public class AsahSegmentsExperimentProcessor {
    private final AnalyticsSettingsManager _analyticsSettingsManager;
    private final AsahFaroBackendClient _asahFaroBackendClient;
    private final CompanyLocalService _companyLocalService;
    private final GroupLocalService _groupLocalService;
    private final LayoutLocalService _layoutLocalService;
    private final Portal _portal;
    private final SegmentsEntryLocalService _segmentsEntryLocalService;
    private final SegmentsExperienceLocalService _segmentsExperienceLocalService;

    public AsahSegmentsExperimentProcessor(AnalyticsSettingsManager analyticsSettingsManager, AsahFaroBackendClient asahFaroBackendClient, CompanyLocalService companyLocalService, GroupLocalService groupLocalService, LayoutLocalService layoutLocalService, Portal portal, SegmentsEntryLocalService segmentsEntryLocalService, SegmentsExperienceLocalService segmentsExperienceLocalService) {
        this._analyticsSettingsManager = analyticsSettingsManager;
        this._asahFaroBackendClient = asahFaroBackendClient;
        this._companyLocalService = companyLocalService;
        this._groupLocalService = groupLocalService;
        this._layoutLocalService = layoutLocalService;
        this._portal = portal;
        this._segmentsEntryLocalService = segmentsEntryLocalService;
        this._segmentsExperienceLocalService = segmentsExperienceLocalService;
    }

    public void processAddSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws Exception {
        if (segmentsExperiment == null || !this._analyticsSettingsManager.isAnalyticsEnabled(segmentsExperiment.getCompanyId())) {
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(segmentsExperiment.getCompanyId());
        Experiment experiment = this._asahFaroBackendClient.addExperiment(segmentsExperiment.getCompanyId(), ExperimentUtil.toExperiment(this._companyLocalService, analyticsConfiguration.liferayAnalyticsDataSourceId(), this._groupLocalService, this._layoutLocalService, LocaleUtil.getSiteDefault(), this._portal, this._segmentsEntryLocalService, this._segmentsExperienceLocalService, segmentsExperiment));
        segmentsExperiment.setSegmentsExperimentKey(experiment.getId());
    }

    public void processDeleteSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws Exception {
        if (segmentsExperiment == null || !this._analyticsSettingsManager.isAnalyticsEnabled(segmentsExperiment.getCompanyId())) {
            return;
        }
        this._asahFaroBackendClient.deleteExperiment(segmentsExperiment.getCompanyId(), segmentsExperiment.getSegmentsExperimentKey());
    }

    public void processUpdateSegmentsExperiment(SegmentsExperiment segmentsExperiment) throws Exception {
        if (segmentsExperiment == null || !this._analyticsSettingsManager.isAnalyticsEnabled(segmentsExperiment.getCompanyId())) {
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(segmentsExperiment.getCompanyId());
        this._asahFaroBackendClient.updateExperiment(segmentsExperiment.getCompanyId(), ExperimentUtil.toExperiment(this._companyLocalService, analyticsConfiguration.liferayAnalyticsDataSourceId(), this._groupLocalService, this._layoutLocalService, LocaleUtil.getSiteDefault(), this._portal, this._segmentsEntryLocalService, this._segmentsExperienceLocalService, segmentsExperiment));
    }

    public void processUpdateSegmentsExperimentLayout(SegmentsExperiment segmentsExperiment, Layout segmentsExperimentLayout) throws Exception {
        if (segmentsExperiment == null || segmentsExperimentLayout == null || !this._analyticsSettingsManager.isAnalyticsEnabled(segmentsExperiment.getCompanyId())) {
            return;
        }
        AnalyticsConfiguration analyticsConfiguration = this._analyticsSettingsManager.getAnalyticsConfiguration(segmentsExperiment.getCompanyId());
        this._asahFaroBackendClient.updateExperiment(segmentsExperiment.getCompanyId(), ExperimentUtil.toExperiment(this._companyLocalService, analyticsConfiguration.liferayAnalyticsDataSourceId(), this._groupLocalService, segmentsExperimentLayout, LocaleUtil.getSiteDefault(), this._portal, this._segmentsEntryLocalService, this._segmentsExperienceLocalService, segmentsExperiment));
    }

    public void processUpdateSegmentsExperimentRel(long companyId, String segmentsExperimentKey, List<SegmentsExperimentRel> segmentsExperimentRels) throws Exception {
        if (segmentsExperimentRels == null || !this._analyticsSettingsManager.isAnalyticsEnabled(companyId)) {
            return;
        }
        this._asahFaroBackendClient.updateExperimentDXPVariants(companyId, segmentsExperimentKey, DXPVariantUtil.toDXPVariants(LocaleUtil.getSiteDefault(), this._segmentsExperienceLocalService, segmentsExperimentRels));
    }
}

