/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.segments.asah.connector.internal.configuration.provider;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.segments.asah.connector.internal.configuration.SegmentsAsahCompanyConfiguration;
import com.liferay.segments.asah.connector.internal.configuration.SegmentsAsahConfiguration;
import java.io.IOException;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.segments.asah.connector.internal.configuration.SegmentsAsahConfiguration"}, service={SegmentsAsahConfigurationProvider.class})
public class SegmentsAsahConfigurationProvider {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private volatile SegmentsAsahConfiguration _segmentsAsahConfiguration;

    public int getAnonymousUserSegmentsCacheExpirationTime(long companyId) throws ConfigurationException {
        if (!this._isSegmentsAsahCompanyConfigurationDefined(companyId)) {
            return this._segmentsAsahConfiguration.anonymousUserSegmentsCacheExpirationTime();
        }
        SegmentsAsahCompanyConfiguration segmentsAsahCompanyConfiguration = (SegmentsAsahCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsAsahCompanyConfiguration.class, companyId);
        return segmentsAsahCompanyConfiguration.anonymousUserSegmentsCacheExpirationTime();
    }

    public int getInterestTermsCacheExpirationTime(long companyId) throws ConfigurationException {
        if (!this._isSegmentsAsahCompanyConfigurationDefined(companyId)) {
            return this._segmentsAsahConfiguration.interestTermsCacheExpirationTime();
        }
        SegmentsAsahCompanyConfiguration segmentsAsahCompanyConfiguration = (SegmentsAsahCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(SegmentsAsahCompanyConfiguration.class, companyId);
        return segmentsAsahCompanyConfiguration.interestTermsCacheExpirationTime();
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._segmentsAsahConfiguration = (SegmentsAsahConfiguration)ConfigurableUtil.createConfigurable(SegmentsAsahConfiguration.class, properties);
    }

    private boolean _isSegmentsAsahCompanyConfigurationDefined(long companyId) throws ConfigurationException {
        try {
            String filterString = StringBundler.concat((Object[])new Object[]{"(&(", "service.factoryPid", "=", SegmentsAsahConfiguration.class.getName(), ".scoped", ")(companyId=", companyId, "))"});
            Configuration[] configuration = this._configurationAdmin.listConfigurations(filterString);
            return configuration != null;
        }
        catch (IOException | InvalidSyntaxException exception) {
            throw new ConfigurationException(exception);
        }
    }
}

