/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.segments.asah.connector.internal.asset.list.asset.entry.query.processor;

import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.list.asset.entry.query.processor.AssetListAssetEntryQueryProcessor;
import com.liferay.asset.list.constants.AssetListPortletKeys;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.segments.asah.connector.internal.provider.AsahInterestTermProvider;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Sarai Díaz
 */
@Component(
	immediate = true,
	property = "javax.portlet.name=" + AssetListPortletKeys.ASSET_LIST,
	service = AssetListAssetEntryQueryProcessor.class
)
public class AsahInterestTermAssetListAssetEntryQueryProcessor
	implements AssetListAssetEntryQueryProcessor {

	@Override
	public void processAssetEntryQuery(
		String userId, UnicodeProperties unicodeProperties,
		AssetEntryQuery assetEntryQuery) {

		if (Validator.isNull(userId)) {
			return;
		}

		boolean enableContentRecommendation = GetterUtil.getBoolean(
			unicodeProperties.getProperty("enableContentRecommendation"));

		if (!enableContentRecommendation ||
			(_asahInterestTermProvider == null)) {

			return;
		}

		String terms = StringUtil.merge(
			_asahInterestTermProvider.getInterestTerms(userId));

		if (Validator.isNull(terms)) {
			return;
		}

		if (_log.isDebugEnabled()) {
			_log.debug(
				StringBundler.concat(
					"Adding interest terms \"", terms,
					"\" to asset query for user ID ", userId));
		}

		assetEntryQuery.setKeywords(terms);
	}

	private static final Log _log = LogFactoryUtil.getLog(
		AsahInterestTermAssetListAssetEntryQueryProcessor.class);

	@Reference
	private AsahInterestTermProvider _asahInterestTermProvider;

}