/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManager;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionCommentIterator;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.screens.service.base.ScreensCommentServiceBaseImpl;
import java.util.Date;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=screens", "json.web.service.context.path=ScreensComment"}, service={AopService.class})
public class ScreensCommentServiceImpl
extends ScreensCommentServiceBaseImpl {
    @Reference
    protected CommentManager commentManager;

    public JSONObject addComment(String className, long classPK, String body) throws PortalException {
        DiscussionPermission discussionPermission = this.commentManager.getDiscussionPermission(this.getPermissionChecker());
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        Group group = this.groupLocalService.getGroup(assetEntry.getGroupId());
        discussionPermission.checkAddPermission(group.getCompanyId(), assetEntry.getGroupId(), className, classPK);
        long commentId = this.commentManager.addComment(this.getUserId(), assetEntry.getGroupId(), className, classPK, this.getUser().getFullName(), "", body, this.createServiceContextFunction());
        Comment comment = this.commentManager.fetchComment(commentId);
        return this.toJSONObject(comment, discussionPermission);
    }

    public JSONObject getComment(long commentId) throws PortalException {
        DiscussionPermission discussionPermission = this.commentManager.getDiscussionPermission(this.getPermissionChecker());
        Comment comment = this.commentManager.fetchComment(commentId);
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(comment.getClassName(), comment.getClassPK());
        Group group = this.groupLocalService.getGroup(assetEntry.getGroupId());
        discussionPermission.checkViewPermission(group.getCompanyId(), assetEntry.getGroupId(), comment.getClassName(), comment.getClassPK());
        return this.toJSONObject(comment, discussionPermission);
    }

    public JSONArray getComments(String className, long classPK, int start, int end) throws PortalException {
        DiscussionPermission discussionPermission = this.commentManager.getDiscussionPermission(this.getPermissionChecker());
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        Group group = this.groupLocalService.getGroup(assetEntry.getGroupId());
        discussionPermission.checkViewPermission(group.getCompanyId(), assetEntry.getGroupId(), className, classPK);
        Discussion discussion = this.commentManager.getDiscussion(this.getUserId(), assetEntry.getGroupId(), className, classPK, this.createServiceContextFunction());
        DiscussionComment rootDiscussionComment = discussion.getRootDiscussionComment();
        if (start == -1) {
            start = 0;
        }
        DiscussionCommentIterator threadDiscussionCommentIterator = rootDiscussionComment.getThreadDiscussionCommentIterator(start);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        if (end == -1) {
            while (threadDiscussionCommentIterator.hasNext()) {
                JSONObject jsonObject = this.toJSONObject((Comment)threadDiscussionCommentIterator.next(), discussionPermission);
                jsonArray.put(jsonObject);
            }
        } else {
            for (int commentsCount = end - start; threadDiscussionCommentIterator.hasNext() && commentsCount > 0; --commentsCount) {
                JSONObject jsonObject = this.toJSONObject((Comment)threadDiscussionCommentIterator.next(), discussionPermission);
                jsonArray.put(jsonObject);
            }
        }
        return jsonArray;
    }

    public int getCommentsCount(String className, long classPK) throws PortalException {
        DiscussionPermission discussionPermission = this.commentManager.getDiscussionPermission(this.getPermissionChecker());
        AssetEntry assetEntry = this.assetEntryLocalService.getEntry(className, classPK);
        Group group = this.groupLocalService.getGroup(assetEntry.getGroupId());
        discussionPermission.checkViewPermission(group.getCompanyId(), assetEntry.getGroupId(), className, classPK);
        return this.commentManager.getCommentsCount(className, classPK);
    }

    public JSONObject updateComment(long commentId, String body) throws PortalException {
        DiscussionPermission discussionPermission = this.commentManager.getDiscussionPermission(this.getPermissionChecker());
        discussionPermission.checkUpdatePermission(commentId);
        Comment comment = this.commentManager.fetchComment(commentId);
        this.commentManager.updateComment(this.getUserId(), comment.getClassName(), comment.getClassPK(), commentId, "", body, this.createServiceContextFunction(1));
        comment = this.commentManager.fetchComment(commentId);
        return this.toJSONObject(comment, discussionPermission);
    }

    protected Function<String, ServiceContext> createServiceContextFunction() {
        return className -> new ServiceContext();
    }

    protected Function<String, ServiceContext> createServiceContextFunction(int workflowAction) {
        return className -> {
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setWorkflowAction(workflowAction);
            return serviceContext;
        };
    }

    protected JSONObject toJSONObject(Comment comment, DiscussionPermission discussionPermission) throws PortalException {
        JSONObject jsonObject = JSONUtil.put((String)"body", (Object)comment.getBody()).put("commentId", (Object)comment.getCommentId());
        Date createDate = comment.getCreateDate();
        jsonObject.put("createDate", (Object)createDate.getTime()).put("deletePermission", discussionPermission.hasDeletePermission(comment.getCommentId()));
        Date modifiedDate = comment.getModifiedDate();
        jsonObject.put("modifiedDate", (Object)modifiedDate.getTime()).put("updatePermission", discussionPermission.hasUpdatePermission(comment.getCommentId())).put("userId", (Object)comment.getUserId()).put("userName", comment.getUserName());
        return jsonObject;
    }
}

