/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.screens.service.base.ScreensRatingsEntryServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=screens", "json.web.service.context.path=ScreensRatingsEntry"}, service={AopService.class})
public class ScreensRatingsEntryServiceImpl
extends ScreensRatingsEntryServiceBaseImpl {
    public JSONObject deleteRatingsEntry(long classPK, String className, int ratingsLength) throws PortalException {
        User user = this.getUser();
        if (user.isDefaultUser()) {
            throw new PrincipalException();
        }
        this.ratingsEntryLocalService.deleteEntry(this.getUserId(), className, classPK);
        return this.getRatingsEntries(classPK, className, ratingsLength);
    }

    public JSONObject getRatingsEntries(long assetEntryId, int ratingsLength) throws PortalException {
        AssetEntry assetEntry = this.assetEntryLocalService.fetchEntry(assetEntryId);
        AssetEntryPermission.check((PermissionChecker)this.getPermissionChecker(), (AssetEntry)assetEntry, (String)"VIEW");
        return this.getRatingsEntries(assetEntry.getClassPK(), assetEntry.getClassName(), ratingsLength);
    }

    public JSONObject getRatingsEntries(long classPK, String className, int ratingsLength) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        List ratingsEntries = this.ratingsEntryLocalService.getEntries(className, classPK);
        int[] ratings = new int[ratingsLength];
        double totalScore = 0.0;
        double userScore = -1.0;
        for (RatingsEntry ratingsEntry : ratingsEntries) {
            int index = (int)(ratingsEntry.getScore() * (double)ratingsLength);
            if (index == ratingsLength) {
                // empty if block
            }
            int n = --index;
            ratings[n] = ratings[n] + 1;
            totalScore += ratingsEntry.getScore();
            if (ratingsEntry.getUserId() != this.getUserId()) continue;
            userScore = ratingsEntry.getScore();
        }
        if (!ratingsEntries.isEmpty()) {
            jsonObject.put("average", totalScore / (double)ratingsEntries.size());
        } else {
            jsonObject.put("average", 0);
        }
        jsonObject.put("className", className).put("classPK", classPK).put("ratings", (Object)ratings).put("totalCount", ratingsEntries.size()).put("totalScore", totalScore).put("userScore", userScore);
        return jsonObject;
    }

    public JSONObject updateRatingsEntry(long classPK, String className, double score, int ratingsLength) throws PortalException {
        User user = this.getUser();
        if (user.isDefaultUser()) {
            throw new PrincipalException();
        }
        this.ratingsEntryLocalService.updateEntry(this.getUserId(), className, classPK, score, new ServiceContext());
        return this.getRatingsEntries(classPK, className, ratingsLength);
    }
}

