/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.screens.service.base.ScreensJournalArticleServiceBaseImpl;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=screens", "json.web.service.context.path=ScreensJournalArticle"}, service={AopService.class})
public class ScreensJournalArticleServiceImpl
extends ScreensJournalArticleServiceBaseImpl {
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference(target="(model.class.name=com.liferay.journal.model.JournalArticle)")
    private ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission;

    public String getJournalArticleContent(long classPK, Locale locale) throws PortalException {
        JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(classPK);
        this._checkPermission(journalArticleResource.getGroupId(), journalArticleResource.getArticleId());
        return this.journalArticleLocalService.getArticleContent(journalArticleResource.getGroupId(), journalArticleResource.getArticleId(), null, null, this.getLanguageId(locale), null, null);
    }

    public String getJournalArticleContent(long classPK, long ddmTemplateId, Locale locale) throws PortalException {
        JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(classPK);
        this._checkPermission(journalArticleResource.getGroupId(), journalArticleResource.getArticleId());
        return this.journalArticleLocalService.getArticleContent(journalArticleResource.getGroupId(), journalArticleResource.getArticleId(), null, this.getDDMTemplateKey(ddmTemplateId), this.getLanguageId(locale), null, null);
    }

    public String getJournalArticleContent(long groupId, String articleId, long ddmTemplateId, Locale locale) throws PortalException {
        this._checkPermission(groupId, articleId);
        return this.journalArticleLocalService.getArticleContent(groupId, articleId, null, this.getDDMTemplateKey(ddmTemplateId), this.getLanguageId(locale), null, null);
    }

    protected String getDDMTemplateKey(long ddmTemplateId) throws PortalException {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(ddmTemplateId);
        return ddmTemplate.getTemplateKey();
    }

    protected String getLanguageId(Locale locale) {
        if (locale == null) {
            locale = LocaleUtil.getSiteDefault();
        }
        return LocaleUtil.toLanguageId((Locale)locale);
    }

    private void _checkPermission(long groupId, String articleId) throws PortalException {
        JournalArticle article = this.journalArticleLocalService.getArticle(groupId, articleId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!this._journalArticleModelResourcePermission.contains(permissionChecker, (ClassedModel)article, "VIEW")) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalArticle.class.getName(), article.getArticleId(), "VIEW"});
        }
    }
}

