/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.screens.service.impl;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.asset.publisher.util.AssetPublisherHelper;
import com.liferay.blogs.model.BlogsEntry;
import com.liferay.blogs.service.BlogsEntryService;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.PortletItem;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portlet.asset.service.permission.AssetEntryPermission;
import com.liferay.screens.service.ScreensDDLRecordService;
import com.liferay.screens.service.base.ScreensAssetEntryServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletPreferences;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=screens", "json.web.service.context.path=ScreensAssetEntry"}, service={AopService.class})
public class ScreensAssetEntryServiceImpl
extends ScreensAssetEntryServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ScreensAssetEntryServiceImpl.class);
    private static volatile ModelResourcePermission<JournalArticle> _journalArticleModelResourcePermission = ModelResourcePermissionFactory.getInstance(ScreensAssetEntryServiceImpl.class, (String)"_journalArticleModelResourcePermission", JournalArticle.class);
    @Reference
    private AssetPublisherHelper _assetPublisherHelper;
    @Reference
    private BlogsEntryService _blogsEntryService;
    @Reference
    private Portal _portal;
    @Reference
    private ScreensDDLRecordService _screensDDLRecordService;

    public JSONArray getAssetEntries(AssetEntryQuery assetEntryQuery, Locale locale) throws PortalException {
        List<AssetEntry> assetEntries = this.assetEntryLocalService.getEntries(assetEntryQuery);
        assetEntries = this.filterAssetEntries(assetEntries);
        return this.toJSONArray(assetEntries, locale);
    }

    public JSONArray getAssetEntries(long companyId, long groupId, String portletItemName, Locale locale, int max) throws PortalException {
        DynamicQuery dynamicQuery = DynamicQueryFactoryUtil.forClass(PortletItem.class, (ClassLoader)this.getClassLoader());
        Property property = PropertyFactoryUtil.forName((String)"name");
        dynamicQuery.add(property.eq((Object)portletItemName));
        dynamicQuery.setLimit(0, 1);
        List portletItems = this.portletItemLocalService.dynamicQuery(dynamicQuery);
        if (portletItems.isEmpty()) {
            throw new PortalException("No portlet items associated with portlet item name " + portletItemName);
        }
        PortletItem portletItem = (PortletItem)portletItems.get(0);
        PortletPreferences portletPreferences = this.portletPreferencesLocalService.getPreferences(portletItem.getCompanyId(), portletItem.getPortletItemId(), 5, 0L, portletItem.getPortletId());
        String selectionStyle = GetterUtil.getString((String)portletPreferences.getValue("selectionStyle", null), (String)"dynamic");
        if (selectionStyle.equals("dynamic")) {
            List layouts;
            if (max > 500) {
                max = 500;
            }
            if (!(layouts = this.layoutLocalService.getLayouts(companyId)).isEmpty()) {
                AssetEntryQuery assetEntryQuery = this._assetPublisherHelper.getAssetEntryQuery(portletPreferences, groupId, (Layout)layouts.get(0), null, null);
                assetEntryQuery.setEnd(max);
                assetEntryQuery.setStart(0);
                List<AssetEntry> assetEntries = this.assetEntryLocalService.getEntries(assetEntryQuery);
                assetEntries = this.filterAssetEntries(assetEntries);
                return this.toJSONArray(assetEntries, locale);
            }
            return JSONFactoryUtil.createJSONArray();
        }
        try {
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)this.getUser());
            List<AssetEntry> assetEntries = this._assetPublisherHelper.getAssetEntries(null, portletPreferences, permissionChecker, new long[]{groupId}, false, false, false);
            assetEntries = this.filterAssetEntries(assetEntries);
            return this.toJSONArray(assetEntries, locale);
        }
        catch (PortalException | SystemException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    public JSONObject getAssetEntry(long entryId, Locale locale) throws PortalException {
        AssetEntry entry = this.assetEntryLocalService.getEntry(entryId);
        AssetEntryPermission.check((PermissionChecker)this.getPermissionChecker(), (AssetEntry)entry, (String)"VIEW");
        return this.toJSONObject(entry, locale);
    }

    public JSONObject getAssetEntry(String className, long classPK, Locale locale) throws PortalException {
        AssetEntryPermission.check((PermissionChecker)this.getPermissionChecker(), (String)className, (long)classPK, (String)"VIEW");
        return this.toJSONObject(this.assetEntryLocalService.getEntry(className, classPK), locale);
    }

    protected List<AssetEntry> filterAssetEntries(List<AssetEntry> assetEntries) {
        ArrayList<AssetEntry> filteredAssetEntries = new ArrayList<AssetEntry>(assetEntries.size());
        for (AssetEntry assetEntry : assetEntries) {
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetEntry.getClassName());
            try {
                if (!assetRendererFactory.hasPermission(this.getPermissionChecker(), assetEntry.getClassPK(), "VIEW")) continue;
                filteredAssetEntries.add(assetEntry);
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)exception, (Throwable)exception);
            }
        }
        return filteredAssetEntries;
    }

    protected JSONObject getAssetObjectJSONObject(AssetEntry assetEntry, Locale locale) throws PortalException {
        String className = assetEntry.getClassName();
        if (className.equals(BlogsEntry.class.getName())) {
            return this.getBlogsEntryJSONObject(assetEntry);
        }
        if (className.equals(DLFileEntry.class.getName())) {
            return this.getFileEntryJSONObject(assetEntry);
        }
        if (className.equals(DDLRecord.class.getName())) {
            return this._screensDDLRecordService.getDDLRecord(assetEntry.getClassPK(), locale);
        }
        if (className.equals(JournalArticle.class.getName())) {
            return this.getJournalArticleJSONObject(assetEntry);
        }
        if (className.equals(User.class.getName())) {
            return this.getUserJSONObject(assetEntry);
        }
        return JSONFactoryUtil.createJSONObject();
    }

    protected JSONObject getBlogsEntryJSONObject(AssetEntry assetEntry) throws PortalException {
        BlogsEntry blogsEntry = this._blogsEntryService.getEntry(assetEntry.getClassPK());
        return JSONUtil.put((String)"blogsEntry", (Object)JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)blogsEntry)));
    }

    protected JSONObject getFileEntryJSONObject(AssetEntry assetEntry) throws PortalException {
        FileEntry fileEntry = this.dlAppService.getFileEntry(assetEntry.getClassPK());
        return JSONUtil.put((String)"fileEntry", (Object)JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)fileEntry))).put("url", this.getFileEntryPreviewURL(fileEntry));
    }

    protected String getFileEntryPreviewURL(FileEntry fileEntry) {
        StringBundler sb = new StringBundler(9);
        sb.append(this._portal.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileEntry.getTitle())));
        sb.append("/");
        sb.append(fileEntry.getUuid());
        return sb.toString();
    }

    protected JSONObject getJournalArticleJSONObject(AssetEntry assetEntry) throws PortalException {
        JournalArticle journalArticle = null;
        _journalArticleModelResourcePermission.check(this.getPermissionChecker(), assetEntry.getClassPK(), "VIEW");
        try {
            journalArticle = this.journalArticleLocalService.getArticle(assetEntry.getClassPK());
        }
        catch (Exception exception) {
            JournalArticleResource journalArticleResource = this.journalArticleResourceLocalService.getArticleResource(assetEntry.getClassPK());
            journalArticle = this.journalArticleLocalService.getLatestArticle(journalArticleResource.getGroupId(), journalArticleResource.getArticleId());
        }
        JSONObject journalArticleJSONObject = JSONUtil.put((String)"DDMStructure", (Object)JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)journalArticle.getDDMStructure())));
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)journalArticle));
        journalArticleJSONObject.put("modelAttributes", jsonObject).put("modelValues", jsonObject.getString("content"));
        jsonObject.remove("content");
        return journalArticleJSONObject;
    }

    protected JSONObject getUserJSONObject(AssetEntry assetEntry) throws PortalException {
        User user = this.userService.getUserById(assetEntry.getClassPK());
        return JSONUtil.put((String)"user", (Object)JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)user)));
    }

    protected JSONArray toJSONArray(List<AssetEntry> assetEntries, Locale locale) throws PortalException {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        for (AssetEntry assetEntry : assetEntries) {
            JSONObject jsonObject = this.toJSONObject(assetEntry, locale);
            jsonArray.put(jsonObject);
        }
        return jsonArray;
    }

    protected JSONObject toJSONObject(AssetEntry assetEntry, Locale locale) throws PortalException {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerialize((Object)assetEntry));
        jsonObject.put("className", assetEntry.getClassName()).put("description", assetEntry.getDescription(locale)).put("locale", String.valueOf(locale)).put("object", this.getAssetObjectJSONObject(assetEntry, locale)).put("summary", assetEntry.getSummary(locale)).put("title", assetEntry.getTitle(locale));
        return jsonObject;
    }
}

