/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.screens.service.base;

import com.liferay.journal.service.persistence.JournalArticlePersistence;
import com.liferay.journal.service.persistence.JournalArticleResourcePersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.persistence.ClassNamePersistence;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.kernel.util.InfrastructureUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.screens.service.ScreensJournalArticleService;
import com.liferay.screens.service.ScreensJournalArticleServiceUtil;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the screens journal article remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.screens.service.impl.ScreensJournalArticleServiceImpl}.
 * </p>
 *
 * @author José Manuel Navarro
 * @see com.liferay.screens.service.impl.ScreensJournalArticleServiceImpl
 * @generated
 */
public abstract class ScreensJournalArticleServiceBaseImpl
	extends BaseServiceImpl
	implements IdentifiableOSGiService, ScreensJournalArticleService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>ScreensJournalArticleService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>ScreensJournalArticleServiceUtil</code>.
	 */

	/**
	 * Returns the screens asset entry remote service.
	 *
	 * @return the screens asset entry remote service
	 */
	public com.liferay.screens.service.ScreensAssetEntryService
		getScreensAssetEntryService() {

		return screensAssetEntryService;
	}

	/**
	 * Sets the screens asset entry remote service.
	 *
	 * @param screensAssetEntryService the screens asset entry remote service
	 */
	public void setScreensAssetEntryService(
		com.liferay.screens.service.ScreensAssetEntryService
			screensAssetEntryService) {

		this.screensAssetEntryService = screensAssetEntryService;
	}

	/**
	 * Returns the screens comment remote service.
	 *
	 * @return the screens comment remote service
	 */
	public com.liferay.screens.service.ScreensCommentService
		getScreensCommentService() {

		return screensCommentService;
	}

	/**
	 * Sets the screens comment remote service.
	 *
	 * @param screensCommentService the screens comment remote service
	 */
	public void setScreensCommentService(
		com.liferay.screens.service.ScreensCommentService
			screensCommentService) {

		this.screensCommentService = screensCommentService;
	}

	/**
	 * Returns the screens ddl record remote service.
	 *
	 * @return the screens ddl record remote service
	 */
	public com.liferay.screens.service.ScreensDDLRecordService
		getScreensDDLRecordService() {

		return screensDDLRecordService;
	}

	/**
	 * Sets the screens ddl record remote service.
	 *
	 * @param screensDDLRecordService the screens ddl record remote service
	 */
	public void setScreensDDLRecordService(
		com.liferay.screens.service.ScreensDDLRecordService
			screensDDLRecordService) {

		this.screensDDLRecordService = screensDDLRecordService;
	}

	/**
	 * Returns the screens ddm structure version remote service.
	 *
	 * @return the screens ddm structure version remote service
	 */
	public com.liferay.screens.service.ScreensDDMStructureVersionService
		getScreensDDMStructureVersionService() {

		return screensDDMStructureVersionService;
	}

	/**
	 * Sets the screens ddm structure version remote service.
	 *
	 * @param screensDDMStructureVersionService the screens ddm structure version remote service
	 */
	public void setScreensDDMStructureVersionService(
		com.liferay.screens.service.ScreensDDMStructureVersionService
			screensDDMStructureVersionService) {

		this.screensDDMStructureVersionService =
			screensDDMStructureVersionService;
	}

	/**
	 * Returns the screens journal article remote service.
	 *
	 * @return the screens journal article remote service
	 */
	public ScreensJournalArticleService getScreensJournalArticleService() {
		return screensJournalArticleService;
	}

	/**
	 * Sets the screens journal article remote service.
	 *
	 * @param screensJournalArticleService the screens journal article remote service
	 */
	public void setScreensJournalArticleService(
		ScreensJournalArticleService screensJournalArticleService) {

		this.screensJournalArticleService = screensJournalArticleService;
	}

	/**
	 * Returns the screens ratings entry remote service.
	 *
	 * @return the screens ratings entry remote service
	 */
	public com.liferay.screens.service.ScreensRatingsEntryService
		getScreensRatingsEntryService() {

		return screensRatingsEntryService;
	}

	/**
	 * Sets the screens ratings entry remote service.
	 *
	 * @param screensRatingsEntryService the screens ratings entry remote service
	 */
	public void setScreensRatingsEntryService(
		com.liferay.screens.service.ScreensRatingsEntryService
			screensRatingsEntryService) {

		this.screensRatingsEntryService = screensRatingsEntryService;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the journal article local service.
	 *
	 * @return the journal article local service
	 */
	public com.liferay.journal.service.JournalArticleLocalService
		getJournalArticleLocalService() {

		return journalArticleLocalService;
	}

	/**
	 * Sets the journal article local service.
	 *
	 * @param journalArticleLocalService the journal article local service
	 */
	public void setJournalArticleLocalService(
		com.liferay.journal.service.JournalArticleLocalService
			journalArticleLocalService) {

		this.journalArticleLocalService = journalArticleLocalService;
	}

	/**
	 * Returns the journal article remote service.
	 *
	 * @return the journal article remote service
	 */
	public com.liferay.journal.service.JournalArticleService
		getJournalArticleService() {

		return journalArticleService;
	}

	/**
	 * Sets the journal article remote service.
	 *
	 * @param journalArticleService the journal article remote service
	 */
	public void setJournalArticleService(
		com.liferay.journal.service.JournalArticleService
			journalArticleService) {

		this.journalArticleService = journalArticleService;
	}

	/**
	 * Returns the journal article persistence.
	 *
	 * @return the journal article persistence
	 */
	public JournalArticlePersistence getJournalArticlePersistence() {
		return journalArticlePersistence;
	}

	/**
	 * Sets the journal article persistence.
	 *
	 * @param journalArticlePersistence the journal article persistence
	 */
	public void setJournalArticlePersistence(
		JournalArticlePersistence journalArticlePersistence) {

		this.journalArticlePersistence = journalArticlePersistence;
	}

	/**
	 * Returns the journal article resource local service.
	 *
	 * @return the journal article resource local service
	 */
	public com.liferay.journal.service.JournalArticleResourceLocalService
		getJournalArticleResourceLocalService() {

		return journalArticleResourceLocalService;
	}

	/**
	 * Sets the journal article resource local service.
	 *
	 * @param journalArticleResourceLocalService the journal article resource local service
	 */
	public void setJournalArticleResourceLocalService(
		com.liferay.journal.service.JournalArticleResourceLocalService
			journalArticleResourceLocalService) {

		this.journalArticleResourceLocalService =
			journalArticleResourceLocalService;
	}

	/**
	 * Returns the journal article resource persistence.
	 *
	 * @return the journal article resource persistence
	 */
	public JournalArticleResourcePersistence
		getJournalArticleResourcePersistence() {

		return journalArticleResourcePersistence;
	}

	/**
	 * Sets the journal article resource persistence.
	 *
	 * @param journalArticleResourcePersistence the journal article resource persistence
	 */
	public void setJournalArticleResourcePersistence(
		JournalArticleResourcePersistence journalArticleResourcePersistence) {

		this.journalArticleResourcePersistence =
			journalArticleResourcePersistence;
	}

	/**
	 * Returns the class name local service.
	 *
	 * @return the class name local service
	 */
	public com.liferay.portal.kernel.service.ClassNameLocalService
		getClassNameLocalService() {

		return classNameLocalService;
	}

	/**
	 * Sets the class name local service.
	 *
	 * @param classNameLocalService the class name local service
	 */
	public void setClassNameLocalService(
		com.liferay.portal.kernel.service.ClassNameLocalService
			classNameLocalService) {

		this.classNameLocalService = classNameLocalService;
	}

	/**
	 * Returns the class name remote service.
	 *
	 * @return the class name remote service
	 */
	public com.liferay.portal.kernel.service.ClassNameService
		getClassNameService() {

		return classNameService;
	}

	/**
	 * Sets the class name remote service.
	 *
	 * @param classNameService the class name remote service
	 */
	public void setClassNameService(
		com.liferay.portal.kernel.service.ClassNameService classNameService) {

		this.classNameService = classNameService;
	}

	/**
	 * Returns the class name persistence.
	 *
	 * @return the class name persistence
	 */
	public ClassNamePersistence getClassNamePersistence() {
		return classNamePersistence;
	}

	/**
	 * Sets the class name persistence.
	 *
	 * @param classNamePersistence the class name persistence
	 */
	public void setClassNamePersistence(
		ClassNamePersistence classNamePersistence) {

		this.classNamePersistence = classNamePersistence;
	}

	/**
	 * Returns the resource local service.
	 *
	 * @return the resource local service
	 */
	public com.liferay.portal.kernel.service.ResourceLocalService
		getResourceLocalService() {

		return resourceLocalService;
	}

	/**
	 * Sets the resource local service.
	 *
	 * @param resourceLocalService the resource local service
	 */
	public void setResourceLocalService(
		com.liferay.portal.kernel.service.ResourceLocalService
			resourceLocalService) {

		this.resourceLocalService = resourceLocalService;
	}

	/**
	 * Returns the user local service.
	 *
	 * @return the user local service
	 */
	public com.liferay.portal.kernel.service.UserLocalService
		getUserLocalService() {

		return userLocalService;
	}

	/**
	 * Sets the user local service.
	 *
	 * @param userLocalService the user local service
	 */
	public void setUserLocalService(
		com.liferay.portal.kernel.service.UserLocalService userLocalService) {

		this.userLocalService = userLocalService;
	}

	/**
	 * Returns the user remote service.
	 *
	 * @return the user remote service
	 */
	public com.liferay.portal.kernel.service.UserService getUserService() {
		return userService;
	}

	/**
	 * Sets the user remote service.
	 *
	 * @param userService the user remote service
	 */
	public void setUserService(
		com.liferay.portal.kernel.service.UserService userService) {

		this.userService = userService;
	}

	/**
	 * Returns the user persistence.
	 *
	 * @return the user persistence
	 */
	public UserPersistence getUserPersistence() {
		return userPersistence;
	}

	/**
	 * Sets the user persistence.
	 *
	 * @param userPersistence the user persistence
	 */
	public void setUserPersistence(UserPersistence userPersistence) {
		this.userPersistence = userPersistence;
	}

	public void afterPropertiesSet() {
		ScreensJournalArticleServiceUtil.setService(
			screensJournalArticleService);
	}

	public void destroy() {
		ScreensJournalArticleServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return ScreensJournalArticleService.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource = InfrastructureUtil.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.screens.service.ScreensAssetEntryService.class
	)
	protected com.liferay.screens.service.ScreensAssetEntryService
		screensAssetEntryService;

	@BeanReference(
		type = com.liferay.screens.service.ScreensCommentService.class
	)
	protected com.liferay.screens.service.ScreensCommentService
		screensCommentService;

	@BeanReference(
		type = com.liferay.screens.service.ScreensDDLRecordService.class
	)
	protected com.liferay.screens.service.ScreensDDLRecordService
		screensDDLRecordService;

	@BeanReference(
		type = com.liferay.screens.service.ScreensDDMStructureVersionService.class
	)
	protected com.liferay.screens.service.ScreensDDMStructureVersionService
		screensDDMStructureVersionService;

	@BeanReference(type = ScreensJournalArticleService.class)
	protected ScreensJournalArticleService screensJournalArticleService;

	@BeanReference(
		type = com.liferay.screens.service.ScreensRatingsEntryService.class
	)
	protected com.liferay.screens.service.ScreensRatingsEntryService
		screensRatingsEntryService;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@ServiceReference(
		type = com.liferay.journal.service.JournalArticleLocalService.class
	)
	protected com.liferay.journal.service.JournalArticleLocalService
		journalArticleLocalService;

	@ServiceReference(
		type = com.liferay.journal.service.JournalArticleService.class
	)
	protected com.liferay.journal.service.JournalArticleService
		journalArticleService;

	@ServiceReference(type = JournalArticlePersistence.class)
	protected JournalArticlePersistence journalArticlePersistence;

	@ServiceReference(
		type = com.liferay.journal.service.JournalArticleResourceLocalService.class
	)
	protected com.liferay.journal.service.JournalArticleResourceLocalService
		journalArticleResourceLocalService;

	@ServiceReference(type = JournalArticleResourcePersistence.class)
	protected JournalArticleResourcePersistence
		journalArticleResourcePersistence;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.ClassNameLocalService.class
	)
	protected com.liferay.portal.kernel.service.ClassNameLocalService
		classNameLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.ClassNameService.class
	)
	protected com.liferay.portal.kernel.service.ClassNameService
		classNameService;

	@ServiceReference(type = ClassNamePersistence.class)
	protected ClassNamePersistence classNamePersistence;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.ResourceLocalService.class
	)
	protected com.liferay.portal.kernel.service.ResourceLocalService
		resourceLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserLocalService.class
	)
	protected com.liferay.portal.kernel.service.UserLocalService
		userLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserService.class
	)
	protected com.liferay.portal.kernel.service.UserService userService;

	@ServiceReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;

	private static final Log _log = LogFactoryUtil.getLog(
		ScreensJournalArticleServiceBaseImpl.class);

}