/**
 * SPDX-FileCopyrightText: (c) 2023 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.saved.content.model.impl;

import com.liferay.saved.content.model.SavedContentEntry;
import com.liferay.saved.content.service.SavedContentEntryLocalServiceUtil;

/**
 * The extended model base implementation for the SavedContentEntry service. Represents a row in the &quot;SavedContentEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SavedContentEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SavedContentEntryImpl
 * @see SavedContentEntry
 * @generated
 */
public abstract class SavedContentEntryBaseImpl
	extends SavedContentEntryModelImpl implements SavedContentEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a saved content entry model instance should use the <code>SavedContentEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			SavedContentEntryLocalServiceUtil.addSavedContentEntry(this);
		}
		else {
			SavedContentEntryLocalServiceUtil.updateSavedContentEntry(this);
		}
	}

}