/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.internal.page.ratings.exportimport.data.handler;

import com.liferay.exportimport.kernel.lar.BasePortletDataHandler;
import com.liferay.exportimport.kernel.lar.DataLevel;
import com.liferay.exportimport.kernel.lar.ExportImportHelper;
import com.liferay.exportimport.kernel.lar.ExportImportProcessCallbackRegistry;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataContextFactory;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerBoolean;
import com.liferay.exportimport.kernel.lar.PortletDataHandlerControl;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import jakarta.portlet.PortletPreferences;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"jakarta.portlet.name=com_liferay_ratings_page_ratings_web_portlet_PageRatingsPortlet"}, service={PortletDataHandler.class})
public class PageRatingsPortletDataHandler
extends BasePortletDataHandler {
    public static final String NAMESPACE = "ratings";
    public static final String SCHEMA_VERSION = "4.0.0";
    private static final Log _log = LogFactoryUtil.getLog(PageRatingsPortletDataHandler.class);
    @Reference
    private ExportImportHelper _exportImportHelper;
    @Reference
    private ExportImportProcessCallbackRegistry _exportImportProcessCallbackRegistry;
    @Reference
    private PortletDataContextFactory _portletDataContextFactory;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;

    public String getSchemaVersion() {
        return SCHEMA_VERSION;
    }

    @Activate
    protected void activate() {
        this.setDataAlwaysStaged(true);
        this.setDataLevel(DataLevel.PORTLET_INSTANCE);
        this.setDeletionSystemEventStagedModelTypes(new StagedModelType[]{new StagedModelType(RatingsEntry.class)});
        this.setExportControls(new PortletDataHandlerControl[]{new PortletDataHandlerBoolean(NAMESPACE, "ratings-entries", true, false, null, RatingsEntry.class.getName(), "referrer-class-name-all")});
        this.setPublishToLiveByDefault(true);
        this.setStagingControls(this.getExportControls());
    }

    protected String doExportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences) throws Exception {
        Element rootElement = this.addExportDataRootElement(portletDataContext);
        if (!portletDataContext.getBooleanParameter(NAMESPACE, "ratings-entries") || MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return this.getExportDataRootElementString(rootElement);
        }
        ActionableDynamicQuery actionableDynamicQuery = this._getRatingsEntryActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performActions();
        return this.getExportDataRootElementString(rootElement);
    }

    protected PortletPreferences doImportData(PortletDataContext portletDataContext, String portletId, PortletPreferences portletPreferences, String data) throws Exception {
        PortletDataContext clonedPortletDataContext = this._portletDataContextFactory.clonePortletDataContext(portletDataContext);
        this._exportImportProcessCallbackRegistry.registerCallback(portletDataContext.getExportImportProcessId(), (Callable)new ImportRatingsCallable(clonedPortletDataContext));
        return null;
    }

    protected void doPrepareManifestSummary(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._getRatingsEntryCountActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.performCount();
    }

    private long _getGroupId(RatingsEntry ratingsEntry) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)ratingsEntry.getClassName());
        if (persistedModelLocalService == null) {
            return 0L;
        }
        PersistedModel persistedModel = null;
        try {
            persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(ratingsEntry.getClassPK()));
        }
        catch (NoSuchModelException noSuchModelException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchModelException);
            }
            return 0L;
        }
        if (!(persistedModel instanceof GroupedModel)) {
            return 0L;
        }
        GroupedModel groupedModel = (GroupedModel)persistedModel;
        return groupedModel.getGroupId();
    }

    private ActionableDynamicQuery _getRatingsEntryActionableDynamicQuery(PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery actionableDynamicQuery = this._ratingsEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        actionableDynamicQuery.setPerformActionMethod(ratingsEntry -> {
            long groupId = this._getGroupId((RatingsEntry)ratingsEntry);
            if (groupId != portletDataContext.getScopeGroupId()) {
                return;
            }
            StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)ratingsEntry);
        });
        return actionableDynamicQuery;
    }

    private ActionableDynamicQuery _getRatingsEntryCountActionableDynamicQuery(final PortletDataContext portletDataContext) throws Exception {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = this._ratingsEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
        exportActionableDynamicQuery.setPerformActionMethod(ratingsEntry -> {
            long groupId = this._getGroupId((RatingsEntry)ratingsEntry);
            if (groupId != portletDataContext.getScopeGroupId()) {
                return;
            }
            ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
            manifestSummary.incrementModelAdditionCount(exportActionableDynamicQuery.getStagedModelType());
        });
        exportActionableDynamicQuery.setPerformCountMethod(new ActionableDynamicQuery.PerformCountMethod(){

            public long performCount() throws PortalException {
                exportActionableDynamicQuery.performActions();
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long modelDeletionCount = PageRatingsPortletDataHandler.this._exportImportHelper.getModelDeletionCount(portletDataContext, stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                manifestSummary.addModelAdditionCount(stagedModelType, 0L);
                return manifestSummary.getModelAdditionCount(stagedModelType);
            }
        });
        return exportActionableDynamicQuery;
    }

    private static class ImportRatingsCallable
    implements Callable<Void> {
        private final PortletDataContext _portletDataContext;

        public ImportRatingsCallable(PortletDataContext portletDataContext) {
            this._portletDataContext = portletDataContext;
        }

        @Override
        public Void call() throws PortalException {
            if (!this._portletDataContext.getBooleanParameter(PageRatingsPortletDataHandler.NAMESPACE, "ratings-entries")) {
                return null;
            }
            Element entriesElement = this._portletDataContext.getImportDataGroupElement(RatingsEntry.class);
            List entryElements = entriesElement.elements();
            for (Element entryElement : entryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)this._portletDataContext, (Element)entryElement);
            }
            return null;
        }
    }
}

