/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ratings.internal.exportimport.data.handler;

import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.portal.kernel.comment.Discussion;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedResourcedModelLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.ratings.kernel.model.RatingsEntry;
import com.liferay.ratings.kernel.service.RatingsEntryLocalService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class RatingsEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<RatingsEntry> {
    public static final String[] CLASS_NAMES = new String[]{RatingsEntry.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(RatingsEntryStagedModelDataHandler.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private RatingsEntryLocalService _ratingsEntryLocalService;

    public void deleteStagedModel(RatingsEntry ratingsEntry) {
        this._ratingsEntryLocalService.deleteRatingsEntry(ratingsEntry);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        RatingsEntry entry = this._ratingsEntryLocalService.fetchRatingsEntryByUuidAndCompanyId(uuid, group.getCompanyId());
        if (entry != null) {
            this.deleteStagedModel(entry);
        }
    }

    public List<RatingsEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return ListUtil.fromArray((Object[])new RatingsEntry[]{this._ratingsEntryLocalService.fetchRatingsEntryByUuidAndCompanyId(uuid, companyId)});
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(RatingsEntry entry) {
        return entry.getUuid();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, RatingsEntry entry) throws Exception {
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)entry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)entry), (ClassedModel)entry);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, RatingsEntry entry) throws Exception {
        long newClassPK;
        block8: {
            Map relatedClassPKs = portletDataContext.getNewPrimaryKeysMap(entry.getClassName());
            newClassPK = MapUtil.getLong((Map)relatedClassPKs, (long)entry.getClassPK(), (long)entry.getClassPK());
            try {
                PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)entry.getClassName());
                if (persistedModelLocalService instanceof PersistedResourcedModelLocalService) {
                    PersistedResourcedModelLocalService persistedResourcedModelLocalService = (PersistedResourcedModelLocalService)persistedModelLocalService;
                    List persistedModels = persistedResourcedModelLocalService.getPersistedModel(newClassPK);
                    if (ListUtil.isEmpty((List)persistedModels)) {
                        return;
                    }
                    break block8;
                }
                try {
                    persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(newClassPK));
                }
                catch (NoSuchModelException noSuchModelException) {
                    if (Objects.equals(entry.getClassName(), Discussion.class.getName()) || Objects.equals(entry.getClassName(), "com.liferay.message.boards.model.MBDiscussion")) {
                        PersistedModelLocalService mbMessagePersistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)"com.liferay.message.boards.model.MBMessage");
                        mbMessagePersistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(newClassPK));
                        break block8;
                    }
                    throw noSuchModelException;
                }
            }
            catch (PortalException portalException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to import ratings entry " + entry.getEntryId()), (Throwable)portalException);
                }
                return;
            }
        }
        long userId = portletDataContext.getUserId(entry.getUserUuid());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)entry);
        RatingsEntry importedEntry = this._ratingsEntryLocalService.updateEntry(userId, entry.getClassName(), newClassPK, entry.getScore(), serviceContext);
        portletDataContext.importClassedModel((ClassedModel)entry, (ClassedModel)importedEntry);
    }
}

