/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import org.apache.commons.collections.ArrayStack;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.buffer.BlockingBuffer;
import org.apache.commons.collections.buffer.PredicatedBuffer;
import org.apache.commons.collections.buffer.SynchronizedBuffer;
import org.apache.commons.collections.buffer.TransformedBuffer;
import org.apache.commons.collections.buffer.TypedBuffer;
import org.apache.commons.collections.buffer.UnmodifiableBuffer;

public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = UnmodifiableBuffer.decorate((Buffer)new ArrayStack(1));

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return SynchronizedBuffer.decorate((Buffer)buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return BlockingBuffer.decorate((Buffer)buffer);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return UnmodifiableBuffer.decorate((Buffer)buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return PredicatedBuffer.decorate((Buffer)buffer, (Predicate)predicate);
    }

    public static Buffer typedBuffer(Buffer buffer, Class type) {
        return TypedBuffer.decorate((Buffer)buffer, (Class)type);
    }

    public static Buffer transformedBuffer(Buffer buffer, Transformer transformer) {
        return TransformedBuffer.decorate((Buffer)buffer, (Transformer)transformer);
    }
}

