/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.internal.util;

import com.liferay.project.templates.extensions.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JakartaCompatabilityUtil {
    private static final String _DELIMITER_COLON = ":";
    private static final String _DELIMITER_UNDERLINE = "_";
    private static final String _GRADLE_GAV_PATTERN = "group: \"%s\", name: \"%s\", version: \"%s\"";
    private static final String _IMPORT_PACKAGE_NEW = "jakarta";
    private static final String _IMPORT_PACKAGE_OLD = "javax";
    private static final String _JAKARTA_DEPENDENCIES_PROPERTIES_FILE_PATH = "jakarta-dependencies/jakarta-dependencies.properties";
    private static final String _TAGLIB_URL_NEW = "jakarta.tags.core";
    private static final String _TAGLIB_URL_OLD = "http://java.sun.com/jsp/jstl/core";
    private static final Properties _jakartaDependenciesProperties = new Properties();

    public static void updateForJakarta(File destinationDir) throws Exception {
        Files.walkFileTree(destinationDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (basicFileAttributes.isRegularFile()) {
                    File file = path.toFile();
                    String fileName = file.getName();
                    if (fileName.endsWith(".gradle")) {
                        JakartaCompatabilityUtil._updateGradleDependencies(path);
                    }
                    if (fileName.endsWith(".jsp")) {
                        FileUtil.replaceString(file, JakartaCompatabilityUtil._TAGLIB_URL_OLD, JakartaCompatabilityUtil._TAGLIB_URL_NEW);
                    }
                    FileUtil.replaceString(file, JakartaCompatabilityUtil._IMPORT_PACKAGE_OLD, JakartaCompatabilityUtil._IMPORT_PACKAGE_NEW);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void _updateGradleDependencies(Path gradleFilePath) throws IOException {
        String content = FileUtil.read(gradleFilePath);
        for (Map.Entry<Object, Object> entry : _jakartaDependenciesProperties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String[] groupAndName = key.split(_DELIMITER_UNDERLINE);
            Pattern pattern = Pattern.compile(String.format(_GRADLE_GAV_PATTERN, groupAndName[0], groupAndName[1], ".*"));
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            String value = String.valueOf(entry.getValue());
            String[] groupAndNameAndVersion = value.split(_DELIMITER_COLON);
            content = matcher.replaceAll(String.format(_GRADLE_GAV_PATTERN, groupAndNameAndVersion[0], groupAndNameAndVersion[1], groupAndNameAndVersion[2]));
        }
        Files.writeString(gradleFilePath, (CharSequence)content, new OpenOption[0]);
    }

    static {
        ClassLoader classLoader = JakartaCompatabilityUtil.class.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream(_JAKARTA_DEPENDENCIES_PROPERTIES_FILE_PATH);){
            _jakartaDependenciesProperties.load(inputStream);
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

