/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginContainer
implements Serializable {
    private List<Plugin> plugins;
    Map pluginMap;

    public void addPlugin(Plugin plugin) {
        if (!(plugin instanceof Plugin)) {
            throw new ClassCastException("PluginContainer.addPlugins(plugin) parameter must be instanceof " + Plugin.class.getName());
        }
        this.getPlugins().add(plugin);
    }

    public List<Plugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<Plugin>();
        }
        return this.plugins;
    }

    public void removePlugin(Plugin plugin) {
        if (!(plugin instanceof Plugin)) {
            throw new ClassCastException("PluginContainer.removePlugins(plugin) parameter must be instanceof " + Plugin.class.getName());
        }
        this.getPlugins().remove(plugin);
    }

    public void setPlugins(List<Plugin> plugins) {
        this.plugins = plugins;
    }

    public void flushPluginMap() {
        this.pluginMap = null;
    }

    public Map getPluginsAsMap() {
        if (this.pluginMap == null) {
            this.pluginMap = new LinkedHashMap();
            if (this.plugins != null) {
                for (Plugin plugin : this.plugins) {
                    this.pluginMap.put(plugin.getKey(), plugin);
                }
            }
        }
        return this.pluginMap;
    }
}

