/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.maven.archetype.ArchetypeCreationRequest;
import org.apache.maven.archetype.ArchetypeCreationResult;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.creator.ArchetypeCreator;
import org.apache.maven.archetype.generator.ArchetypeGenerator;
import org.apache.maven.archetype.source.ArchetypeDataSource;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;

@Component(role=ArchetypeManager.class)
public class DefaultArchetypeManager
extends AbstractLogEnabled
implements ArchetypeManager {
    @Requirement(hint="fileset")
    private ArchetypeCreator creator;
    @Requirement
    private ArchetypeGenerator generator;
    @Requirement(role=ArchetypeDataSource.class)
    private Map<String, ArchetypeDataSource> archetypeSources;

    public ArchetypeCreationResult createArchetypeFromProject(ArchetypeCreationRequest request) {
        ArchetypeCreationResult result = new ArchetypeCreationResult();
        this.creator.createArchetype(request, result);
        return result;
    }

    public ArchetypeGenerationResult generateProjectFromArchetype(ArchetypeGenerationRequest request) {
        ArchetypeGenerationResult result = new ArchetypeGenerationResult();
        this.generator.generateArchetype(request, result);
        return result;
    }

    public File archiveArchetype(File archetypeDirectory, File outputDirectory, String finalName) throws DependencyResolutionRequiredException, IOException {
        File jarFile = new File(outputDirectory, finalName + ".jar");
        this.zip(archetypeDirectory, jarFile);
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(File sourceDirectory, File archive) throws IOException {
        if (!archive.getParentFile().exists()) {
            archive.getParentFile().mkdirs();
        }
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(archive));
            zos.setLevel(9);
            this.zipper(zos, sourceDirectory.getAbsolutePath().length(), sourceDirectory);
        }
        catch (Throwable throwable) {
            IOUtil.close(zos);
            throw throwable;
        }
        IOUtil.close(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipper(ZipOutputStream zos, int offset, File currentSourceDirectory) throws IOException {
        File[] files = currentSourceDirectory.listFiles();
        if (files.length == 0) {
            String dirName = currentSourceDirectory.getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                dirName = dirName.replace('\\', '/');
            }
            zos.putNextEntry(new ZipEntry(dirName + '/'));
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.zipper(zos, offset, files[i]);
                continue;
            }
            String fileName = files[i].getAbsolutePath().substring(offset + 1);
            if (File.separatorChar != '/') {
                fileName = fileName.replace('\\', '/');
            }
            ZipEntry e = new ZipEntry(fileName);
            zos.putNextEntry(e);
            FileInputStream is = null;
            try {
                is = new FileInputStream(files[i]);
                IOUtil.copy((InputStream)is, (OutputStream)zos);
            }
            catch (Throwable throwable) {
                IOUtil.close(is);
                throw throwable;
            }
            IOUtil.close(is);
            zos.flush();
            zos.closeEntry();
        }
    }

    public ArchetypeCatalog getInternalCatalog() {
        try {
            ArchetypeDataSource source = this.archetypeSources.get("internal-catalog");
            return source.getArchetypeCatalog(new Properties());
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    public ArchetypeCatalog getDefaultLocalCatalog() {
        return this.getLocalCatalog("${user.home}/.m2/archetype-catalog.xml");
    }

    public ArchetypeCatalog getLocalCatalog(String path) {
        try {
            Properties properties = new Properties();
            properties.setProperty("file", path);
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            return source.getArchetypeCatalog(properties);
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    public ArchetypeCatalog getRemoteCatalog() {
        return this.getRemoteCatalog("http://repo.maven.apache.org/maven2");
    }

    public ArchetypeCatalog getRemoteCatalog(String url) {
        try {
            Properties properties = new Properties();
            properties.setProperty("repository", url);
            ArchetypeDataSource source = this.archetypeSources.get("remote-catalog");
            return source.getArchetypeCatalog(properties);
        }
        catch (ArchetypeDataSourceException e) {
            return new ArchetypeCatalog();
        }
    }

    public void updateLocalCatalog(Archetype archetype) {
        this.updateLocalCatalog(archetype, "${user.home}/.m2/archetype-catalog.xml");
    }

    public void updateLocalCatalog(Archetype archetype, String path) {
        try {
            Properties properties = new Properties();
            properties.setProperty("file", path);
            ArchetypeDataSource source = this.archetypeSources.get("catalog");
            source.updateCatalog(properties, archetype);
        }
        catch (ArchetypeDataSourceException archetypeDataSourceException) {
            // empty catch block
        }
    }
}

