/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.sla.processor;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAInstanceResult;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAStopwatch;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLATaskResult;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendar;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendarRegistry;
import com.liferay.portal.workflow.metrics.sla.processor.WorkflowMetricsSLAStatus;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;

public class WorkflowMetricsSLAProcessor {
    private final DateTimeFormatter _dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public WorkflowMetricsSLAInstanceResult process(LocalDateTime completionLocalDateTime, LocalDateTime createLocalDateTime, List<Document> documents, long instanceId, LocalDateTime nowLocalDateTime, long startNodeId, WorkflowMetricsSLACalendarRegistry workflowMetricsSLACalendarRegistry, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult) {
        long elapsedTime = 0L;
        LocalDateTime lastCheckLocalDateTime = null;
        WorkflowMetricsSLAStatus workflowMetricsSLAStatus = WorkflowMetricsSLAStatus.NEW;
        if (workflowMetricsSLAInstanceResult != null) {
            elapsedTime = workflowMetricsSLAInstanceResult.getElapsedTime();
            lastCheckLocalDateTime = workflowMetricsSLAInstanceResult.getModifiedLocalDateTime();
            workflowMetricsSLAStatus = workflowMetricsSLAInstanceResult.getWorkflowMetricsSLAStatus();
            if (lastCheckLocalDateTime.isAfter(nowLocalDateTime) || Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.COMPLETED)) {
                return null;
            }
        }
        WorkflowMetricsSLACalendar workflowMetricsSLACalendar = workflowMetricsSLACalendarRegistry.getWorkflowMetricsSLACalendar(workflowMetricsSLADefinitionVersion.getCalendarKey());
        WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch = this._createWorkflowMetricsSLAStopwatch(createLocalDateTime, documents, lastCheckLocalDateTime, startNodeId, workflowMetricsSLADefinitionVersion, workflowMetricsSLAStatus);
        LocalDateTime endLocalDateTime = nowLocalDateTime;
        if (completionLocalDateTime != null) {
            endLocalDateTime = completionLocalDateTime;
        }
        if (!workflowMetricsSLAStopwatch.isEmpty()) {
            List<TaskInterval> taskIntervals = this._toTaskIntervals(documents, lastCheckLocalDateTime, nowLocalDateTime);
            for (TaskInterval taskInterval : taskIntervals) {
                endLocalDateTime = taskInterval.getEndLocalDateTime();
                elapsedTime += this._computeElapsedTime(endLocalDateTime, taskInterval.getStartLocalDateTime(), workflowMetricsSLACalendar, workflowMetricsSLAStopwatch);
            }
            workflowMetricsSLAStatus = workflowMetricsSLAStopwatch.getWorkflowMetricsSLAStatus();
            if (completionLocalDateTime != null) {
                workflowMetricsSLAStatus = WorkflowMetricsSLAStatus.COMPLETED;
            }
            if (Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.RUNNING)) {
                duration = workflowMetricsSLACalendar.getDuration(endLocalDateTime, nowLocalDateTime);
                elapsedTime += duration.toMillis();
                endLocalDateTime = nowLocalDateTime;
            } else if (Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.COMPLETED)) {
                duration = workflowMetricsSLACalendar.getDuration(endLocalDateTime, completionLocalDateTime);
                elapsedTime += duration.toMillis();
                endLocalDateTime = completionLocalDateTime;
            }
        }
        return this._createWorkflowMetricsSLAInstanceResult(workflowMetricsSLADefinitionVersion.getCompanyId(), completionLocalDateTime, documents, elapsedTime, endLocalDateTime, instanceId, nowLocalDateTime, workflowMetricsSLACalendar, workflowMetricsSLADefinitionVersion, workflowMetricsSLAStatus);
    }

    protected boolean isBreached(Document document, LocalDateTime nowLocalDateTime, LocalDateTime overdueLocalDateTime) {
        if (nowLocalDateTime.isBefore(overdueLocalDateTime)) {
            return false;
        }
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getDate("createDate"), this._dateTimeFormatter);
        if (createDateLocalDateTime.isAfter(overdueLocalDateTime)) {
            return false;
        }
        if (Validator.isNull((String)document.getDate("completionDate"))) {
            return true;
        }
        LocalDateTime completionDateLocalDateTime = LocalDateTime.parse(document.getDate("completionDate"), this._dateTimeFormatter);
        return completionDateLocalDateTime.isAfter(overdueLocalDateTime);
    }

    protected boolean isOnTime(Document document, LocalDateTime nowLocalDateTime, LocalDateTime overdueLocalDateTime) {
        if (nowLocalDateTime.isBefore(overdueLocalDateTime)) {
            return true;
        }
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getDate("createDate"), this._dateTimeFormatter);
        if (createDateLocalDateTime.isAfter(overdueLocalDateTime) || Validator.isNull((String)document.getDate("completionDate"))) {
            return false;
        }
        LocalDateTime completionDateLocalDateTime = LocalDateTime.parse(document.getDate("completionDate"), this._dateTimeFormatter);
        return completionDateLocalDateTime.isBefore(overdueLocalDateTime) || Objects.equals(completionDateLocalDateTime, overdueLocalDateTime);
    }

    private long _computeElapsedTime(LocalDateTime endLocalDateTime, LocalDateTime starLocalDateTime, WorkflowMetricsSLACalendar workflowMetricsSLACalendar, WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch) {
        long elapsedTime = 0L;
        for (TaskInterval taskInterval : workflowMetricsSLAStopwatch.getTaskIntervals()) {
            if (endLocalDateTime.isBefore(taskInterval._startLocalDateTime) || starLocalDateTime.isAfter(taskInterval._endLocalDateTime)) continue;
            Duration duration = workflowMetricsSLACalendar.getDuration(this._getMaxLocalDateTime(starLocalDateTime, taskInterval._startLocalDateTime), this._getMinLocalDateTime(endLocalDateTime, taskInterval._endLocalDateTime));
            elapsedTime += duration.toMillis();
        }
        return elapsedTime;
    }

    private WorkflowMetricsSLAInstanceResult _createWorkflowMetricsSLAInstanceResult(final long companyId, final LocalDateTime completionLocalDateTime, List<Document> documents, final long elapsedTime, final LocalDateTime endLocalDateTime, final long instanceId, final LocalDateTime nowLocalDateTime, final WorkflowMetricsSLACalendar workflowMetricsSLACalendar, final WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, final WorkflowMetricsSLAStatus workflowMetricsSLAStatus) {
        WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult = new WorkflowMetricsSLAInstanceResult(){
            {
                this.setCompanyId(companyId);
                if (completionLocalDateTime != null) {
                    this.setCompletionLocalDateTime(completionLocalDateTime);
                }
                this.setElapsedTime(elapsedTime);
                this.setInstanceId(instanceId);
                this.setModifiedLocalDateTime(nowLocalDateTime);
                this.setOnTime(elapsedTime <= workflowMetricsSLADefinitionVersion.getDuration());
                long remainingTime = workflowMetricsSLADefinitionVersion.getDuration() - elapsedTime;
                this.setOverdueLocalDateTime(workflowMetricsSLACalendar.getOverdueLocalDateTime(endLocalDateTime, Duration.ofMillis(remainingTime)));
                this.setProcessId(workflowMetricsSLADefinitionVersion.getProcessId());
                this.setRemainingTime(remainingTime);
                this.setSLADefinitionId(workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId());
                this.setWorkflowMetricsSLAStatus(workflowMetricsSLAStatus);
            }
        };
        workflowMetricsSLAInstanceResult.setWorkflowMetricsSLATaskResults(this._createWorkflowMetricsSLATaskResults(documents, completionLocalDateTime != null, completionLocalDateTime, nowLocalDateTime, workflowMetricsSLAInstanceResult));
        return workflowMetricsSLAInstanceResult;
    }

    private WorkflowMetricsSLAStopwatch _createWorkflowMetricsSLAStopwatch(LocalDateTime createDateLocalDateTime, List<Document> documents, LocalDateTime lastCheckLocalDateTime, long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion, WorkflowMetricsSLAStatus workflowMetricsSLAStatus) {
        WorkflowMetricsSLAStopwatch workflowMetricsSLAStopwatch = new WorkflowMetricsSLAStopwatch(workflowMetricsSLAStatus);
        if (Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.STOPPED)) {
            return workflowMetricsSLAStopwatch;
        }
        Map<Long, String> startTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getStartNodeKeys()));
        if (Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.NEW) && startTimeMarkers.containsKey(startNodeId)) {
            workflowMetricsSLAStopwatch.run(createDateLocalDateTime);
        } else if (Objects.equals(workflowMetricsSLAStatus, WorkflowMetricsSLAStatus.RUNNING)) {
            workflowMetricsSLAStopwatch.run(lastCheckLocalDateTime);
        }
        if (ListUtil.isEmpty(documents)) {
            return workflowMetricsSLAStopwatch;
        }
        Map<Long, String> pauseTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getPauseNodeKeys()));
        Map<Long, String> stopTimeMarkers = this._getTimeMarkers(StringUtil.split((String)workflowMetricsSLADefinitionVersion.getStopNodeKeys()));
        Iterator<Document> iterator = documents.iterator();
        while (iterator.hasNext() && !workflowMetricsSLAStopwatch.isStopped()) {
            Document document = iterator.next();
            long nodeId = document.getLong("nodeId");
            TaskInterval taskInterval = this._toTaskInterval(document, lastCheckLocalDateTime, null);
            if (pauseTimeMarkers.containsKey(nodeId) && !stopTimeMarkers.containsKey(nodeId)) {
                workflowMetricsSLAStopwatch.pause(taskInterval._startLocalDateTime);
                if (taskInterval._endLocalDateTime != null) {
                    workflowMetricsSLAStopwatch.run(taskInterval._endLocalDateTime);
                }
            }
            if (startTimeMarkers.containsKey(nodeId)) {
                if (Objects.equals(startTimeMarkers.get(nodeId), "enter")) {
                    workflowMetricsSLAStopwatch.run(taskInterval._startLocalDateTime);
                } else if (Objects.equals(startTimeMarkers.get(nodeId), "leave") && taskInterval._endLocalDateTime != null) {
                    workflowMetricsSLAStopwatch.run(taskInterval._endLocalDateTime);
                }
            }
            if (!stopTimeMarkers.containsKey(nodeId)) continue;
            if (Objects.equals(stopTimeMarkers.get(nodeId), "enter")) {
                workflowMetricsSLAStopwatch.stop(taskInterval._startLocalDateTime);
                continue;
            }
            if (!Objects.equals(stopTimeMarkers.get(nodeId), "leave") || taskInterval._endLocalDateTime == null) continue;
            workflowMetricsSLAStopwatch.stop(taskInterval._endLocalDateTime);
        }
        return workflowMetricsSLAStopwatch;
    }

    private WorkflowMetricsSLATaskResult _createWorkflowMetricsSLATaskResult(final Document document, final boolean instanceCompleted, final LocalDateTime instanceCompletionLocalDateTime, final LocalDateTime nowLocalDateTime, final WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult) {
        return new WorkflowMetricsSLATaskResult(){
            {
                List assigneeIds = document.getLongs("assigneeIds");
                if (assigneeIds != null) {
                    this.setAssigneeIds(assigneeIds.toArray(new Long[0]));
                    this.setAssigneeType(document.getString("assigneeType"));
                }
                this.setBreached(WorkflowMetricsSLAProcessor.this.isBreached(document, nowLocalDateTime, workflowMetricsSLAInstanceResult.getOverdueLocalDateTime()));
                this.setCompanyId(workflowMetricsSLAInstanceResult.getCompanyId());
                if (Validator.isNotNull((String)document.getDate("completionDate"))) {
                    this.setCompletionLocalDateTime(LocalDateTime.parse(document.getDate("completionDate"), WorkflowMetricsSLAProcessor.this._dateTimeFormatter));
                }
                if (Validator.isNotNull((Long)document.getLong("completionUserId"))) {
                    this.setCompletionUserId(document.getLong("completionUserId"));
                }
                this.setInstanceCompleted(instanceCompleted);
                this.setInstanceCompletionLocalDateTime(instanceCompletionLocalDateTime);
                this.setInstanceId(workflowMetricsSLAInstanceResult.getInstanceId());
                this.setModifiedLocalDateTime(workflowMetricsSLAInstanceResult.getModifiedLocalDateTime());
                this.setNodeId(document.getLong("nodeId"));
                this.setOnTime(WorkflowMetricsSLAProcessor.this.isOnTime(document, nowLocalDateTime, workflowMetricsSLAInstanceResult.getOverdueLocalDateTime()));
                this.setProcessId(workflowMetricsSLAInstanceResult.getProcessId());
                this.setSLADefinitionId(workflowMetricsSLAInstanceResult.getSLADefinitionId());
                this.setTaskId(document.getLong("taskId"));
                this.setTaskName(document.getString("name"));
                this.setWorkflowMetricsSLAStatus(WorkflowMetricsSLAProcessor.this._getWorkflowMetricsSLAStatus(document, workflowMetricsSLAInstanceResult));
            }
        };
    }

    private List<WorkflowMetricsSLATaskResult> _createWorkflowMetricsSLATaskResults(List<Document> documents, boolean instanceCompleted, LocalDateTime instanceCompletionLocalDateTime, LocalDateTime nowLocalDateTime, WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult) {
        if (ListUtil.isEmpty(documents)) {
            return Collections.emptyList();
        }
        return TransformUtil.transform(documents, document -> this._createWorkflowMetricsSLATaskResult((Document)document, instanceCompleted, instanceCompletionLocalDateTime, nowLocalDateTime, workflowMetricsSLAInstanceResult));
    }

    private LocalDateTime _getMaxLocalDateTime(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        if (localDateTime1.isAfter(localDateTime2)) {
            return localDateTime1;
        }
        return localDateTime2;
    }

    private LocalDateTime _getMinLocalDateTime(LocalDateTime localDateTime1, LocalDateTime localDateTime2) {
        if (localDateTime1.isBefore(localDateTime2)) {
            return localDateTime1;
        }
        return localDateTime2;
    }

    private Map<Long, String> _getTimeMarkers(List<String> nodeKeys) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (String nodeKey : nodeKeys) {
            List parts = StringUtil.split((String)nodeKey, (char)':');
            long nodeId = GetterUtil.getLong((String)((String)parts.get(0)));
            if (parts.size() == 1) {
                map.put(nodeId, "");
                continue;
            }
            map.put(nodeId, (String)parts.get(1));
        }
        return map;
    }

    private WorkflowMetricsSLAStatus _getWorkflowMetricsSLAStatus(Document document, WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult) {
        if (Objects.equals(workflowMetricsSLAInstanceResult.getWorkflowMetricsSLAStatus(), WorkflowMetricsSLAStatus.NEW)) {
            return WorkflowMetricsSLAStatus.NEW;
        }
        if (GetterUtil.getBoolean((Object)document.getBoolean("completed")) || workflowMetricsSLAInstanceResult.getCompletionLocalDateTime() != null || Objects.equals(workflowMetricsSLAInstanceResult.getWorkflowMetricsSLAStatus(), WorkflowMetricsSLAStatus.COMPLETED)) {
            return WorkflowMetricsSLAStatus.COMPLETED;
        }
        return WorkflowMetricsSLAStatus.RUNNING;
    }

    private TaskInterval _toTaskInterval(Document document, LocalDateTime lastCheckLocalDateTime, LocalDateTime nowLocalDateTime) {
        TaskInterval taskInterval = new TaskInterval();
        taskInterval._endLocalDateTime = Validator.isNull((String)document.getDate("completionDate")) ? nowLocalDateTime : LocalDateTime.parse(document.getDate("completionDate"), this._dateTimeFormatter);
        LocalDateTime createDateLocalDateTime = LocalDateTime.parse(document.getDate("createDate"), this._dateTimeFormatter);
        taskInterval._startLocalDateTime = lastCheckLocalDateTime != null && lastCheckLocalDateTime.isAfter(createDateLocalDateTime) ? lastCheckLocalDateTime : createDateLocalDateTime;
        return taskInterval;
    }

    private List<TaskInterval> _toTaskIntervals(List<Document> documents, LocalDateTime lastCheckLocalDateTime, LocalDateTime nowLocalDateTime) {
        if (ListUtil.isEmpty(documents)) {
            return Collections.emptyList();
        }
        Stack<TaskInterval> taskIntervals = new Stack<TaskInterval>();
        taskIntervals.push(this._toTaskInterval(documents.get(0), lastCheckLocalDateTime, nowLocalDateTime));
        for (Document document : documents) {
            TaskInterval topTaskInterval = taskIntervals.peek();
            TaskInterval taskInterval = this._toTaskInterval(document, lastCheckLocalDateTime, nowLocalDateTime);
            LocalDateTime topEndLocalDateTime = topTaskInterval.getEndLocalDateTime();
            if (topEndLocalDateTime.isBefore(taskInterval.getStartLocalDateTime())) {
                taskIntervals.push(taskInterval);
                continue;
            }
            if (!topEndLocalDateTime.isBefore(taskInterval.getEndLocalDateTime())) continue;
            topTaskInterval._endLocalDateTime = taskInterval.getEndLocalDateTime();
        }
        return taskIntervals;
    }

    protected static class TaskInterval {
        private LocalDateTime _endLocalDateTime;
        private LocalDateTime _startLocalDateTime;

        protected TaskInterval() {
        }

        public LocalDateTime getEndLocalDateTime() {
            return this._endLocalDateTime;
        }

        public LocalDateTime getStartLocalDateTime() {
            return this._startLocalDateTime;
        }

        public void setEndLocalDateTime(LocalDateTime endLocalDateTime) {
            this._endLocalDateTime = endLocalDateTime;
        }

        public void setStartLocalDateTime(LocalDateTime startLocalDateTime) {
            this._startLocalDateTime = startLocalDateTime;
        }
    }
}

