/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index.reindexer;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskHelper;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAInstanceResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.reindexer.WorkflowMetricsReindexer;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsReindexer.class})
public class SLAInstanceResultWorkflowMetricsReindexer
implements WorkflowMetricsReindexer {
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    private static final Snapshot<WorkflowMetricsSLAProcessBackgroundTaskHelper> _workflowMetricsSLAProcessBackgroundTaskHelperSnapshot = new Snapshot(SLAInstanceResultWorkflowMetricsReindexer.class, WorkflowMetricsSLAProcessBackgroundTaskHelper.class, null, true);
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SLAInstanceResultWorkflowMetricsIndexer _slaInstanceResultWorkflowMetricsIndexer;

    public String getKey() {
        return "sla-instance-result";
    }

    public void reindex(long companyId) throws PortalException {
        this._creatDefaultDocuments(companyId);
        WorkflowMetricsSLAProcessBackgroundTaskHelper workflowMetricsSLAProcessBackgroundTaskHelper = (WorkflowMetricsSLAProcessBackgroundTaskHelper)_workflowMetricsSLAProcessBackgroundTaskHelperSnapshot.get();
        if (workflowMetricsSLAProcessBackgroundTaskHelper != null) {
            workflowMetricsSLAProcessBackgroundTaskHelper.addBackgroundTasks(true);
        }
    }

    private void _creatDefaultDocuments(long companyId) {
        if (!this._searchCapabilities.isWorkflowMetricsSupported() || !this._hasIndex(this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-processes")) {
            return;
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-processes"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addFilterQueryClauses(new Query[]{this._queries.term("companyId", (Object)companyId), this._queries.term("deleted", (Object)Boolean.FALSE)});
        searchSearchRequest.setQuery((Query)booleanQuery);
        searchSearchRequest.setSize(Integer.valueOf(10000));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        if (searchHits.getTotalHits() == 0L) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            Document document = searchHit.getDocument();
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._slaInstanceResultWorkflowMetricsIndexer.getIndexName(companyId), this._slaInstanceResultWorkflowMetricsIndexer.creatDefaultDocument(companyId, document.getLong("processId"))));
        }
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            if (PortalRunMode.isTestMode()) {
                bulkDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }

    private boolean _hasIndex(String indexName) {
        IndicesExistsIndexRequest indicesExistsIndexRequest = new IndicesExistsIndexRequest(new String[]{indexName});
        IndicesExistsIndexResponse indicesExistsIndexResponse = (IndicesExistsIndexResponse)this.searchEngineAdapter.execute((IndexRequest)indicesExistsIndexRequest);
        return indicesExistsIndexResponse.isExists();
    }
}

