/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index.creation.helper;

import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.search.CountSearchRequest;
import com.liferay.portal.search.engine.adapter.search.CountSearchResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsReindexBackgroundTaskExecutor;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsIndexCreator.class})
public class WorkflowMetricsIndexCreator {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;

    public void createIndex(Company company) throws PortalException {
        for (WorkflowMetricsIndex workflowMetricsIndex : WorkflowMetricsIndex.values()) {
            boolean indexCreated = workflowMetricsIndex.createIndex(this._searchCapabilities, this._searchEngineAdapter, this._indexNameBuilder, company.getCompanyId());
            if (indexCreated) continue;
            return;
        }
    }

    public void reindex(Company company) {
        if (!this._searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            CountSearchRequest countSearchRequest = new CountSearchRequest();
            countSearchRequest.setIndexNames(new String[]{WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-processes", company.getCompanyId())});
            countSearchRequest.setQuery((Query)this._queries.booleanQuery());
            CountSearchResponse countSearchResponse = (CountSearchResponse)this._searchEngineAdapter.execute((SearchRequest)countSearchRequest);
            if (countSearchResponse.getCount() > 0L) {
                return null;
            }
            User user = company.getGuestUser();
            String name = PrincipalThreadLocal.getName();
            try {
                PrincipalThreadLocal.setName((long)user.getUserId());
                this._backgroundTaskLocalService.addBackgroundTask(user.getUserId(), company.getGroupId(), WorkflowMetricsIndexCreator.class.getSimpleName(), WorkflowMetricsReindexBackgroundTaskExecutor.class.getName(), (Map)HashMapBuilder.put((Object)"deleteOnSuccess", (Object)true).put((Object)"workflow.metrics.index.entity.names", (Object)new String[]{"instance", "node", "process", "sla-instance-result", "sla-task-result", "task", "transition"}).build(), new ServiceContext());
            }
            finally {
                PrincipalThreadLocal.setName((String)name);
            }
            return null;
        });
    }

    public void removeIndex(Company company) throws PortalException {
        for (WorkflowMetricsIndex workflowMetricsIndex : WorkflowMetricsIndex.values()) {
            boolean indexRemoved = workflowMetricsIndex.removeIndex(this._searchCapabilities, this._searchEngineAdapter, this._indexNameBuilder, company.getCompanyId());
            if (indexRemoved) continue;
            return;
        }
    }
}

