/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DeleteByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.index.CreateIndexRequest;
import com.liferay.portal.search.engine.adapter.index.DeleteIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;

public enum WorkflowMetricsIndex {
    INSTANCE("-workflow-metrics-instances", "WorkflowMetricsInstanceType"),
    NODE("-workflow-metrics-nodes", "WorkflowMetricsNodeType"),
    PROCESS("-workflow-metrics-processes", "WorkflowMetricsProcessType"),
    SLA_INSTANCE_RESULT("-workflow-metrics-sla-instance-results", "WorkflowMetricsSLAInstanceResultType"),
    SLA_TASK_RESULT("-workflow-metrics-sla-task-results", "WorkflowMetricsSLATaskResultType"),
    TASK("-workflow-metrics-tasks", "WorkflowMetricsTaskType"),
    TRANSITION("-workflow-metrics-transitions", "WorkflowMetricsTransitionType");

    private static final Log _log;
    private final String _indexNameSuffix;
    private final String _indexType;

    public static String getIndexName(IndexNameBuilder indexNameBuilder, String indexNameSuffix, long companyId) {
        return indexNameBuilder.getIndexName(companyId) + indexNameSuffix;
    }

    public static WorkflowMetricsIndex toWorkflowMetricsIndex(String indexEntityName) {
        indexEntityName = StringUtil.toUpperCase((String)indexEntityName);
        return WorkflowMetricsIndex.valueOf(StringUtil.replace((String)indexEntityName, (char)'-', (char)'_'));
    }

    public boolean createIndex(SearchCapabilities searchCapabilities, SearchEngineAdapter searchEngineAdapter, IndexNameBuilder indexNameBuilder, long companyId) throws PortalException {
        if (!searchCapabilities.isWorkflowMetricsSupported() || this._hasIndex(searchEngineAdapter, WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId))) {
            return false;
        }
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId));
        createIndexRequest.setMappings(this._readJSON(this._indexType + "-mappings.json"));
        createIndexRequest.setSettings(this._readJSON("settings.json"));
        try {
            searchEngineAdapter.execute((IndexRequest)createIndexRequest);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return true;
    }

    public boolean deleteAllDocuments(SearchCapabilities searchCapabilities, SearchEngineAdapter searchEngineAdapter, Queries queries, IndexNameBuilder indexNameBuilder, long companyId) throws PortalException {
        if (!searchCapabilities.isWorkflowMetricsSupported() || !this._hasIndex(searchEngineAdapter, WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId))) {
            return false;
        }
        searchEngineAdapter.execute((DocumentRequest)new DeleteByQueryDocumentRequest((Query)queries.matchAll(), new String[]{WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId)}));
        return true;
    }

    public boolean removeIndex(SearchCapabilities searchCapabilities, SearchEngineAdapter searchEngineAdapter, IndexNameBuilder indexNameBuilder, long companyId) throws PortalException {
        if (!searchCapabilities.isWorkflowMetricsSupported() || !this._hasIndex(searchEngineAdapter, WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId))) {
            return false;
        }
        searchEngineAdapter.execute((IndexRequest)new DeleteIndexRequest(new String[]{WorkflowMetricsIndex.getIndexName(indexNameBuilder, this._indexNameSuffix, companyId)}));
        return true;
    }

    private WorkflowMetricsIndex(String indexNameSuffix, String indexType) {
        this._indexNameSuffix = indexNameSuffix;
        this._indexType = indexType;
    }

    private boolean _hasIndex(SearchEngineAdapter searchEngineAdapter, String indexName) {
        IndicesExistsIndexRequest indicesExistsIndexRequest = new IndicesExistsIndexRequest(new String[]{indexName});
        IndicesExistsIndexResponse indicesExistsIndexResponse = (IndicesExistsIndexResponse)searchEngineAdapter.execute((IndexRequest)indicesExistsIndexRequest);
        return indicesExistsIndexResponse.isExists();
    }

    private String _readJSON(String fileName) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)StringUtil.read(((Object)((Object)this)).getClass(), (String)("/META-INF/search/" + fileName)));
            return jsonObject.toString();
        }
        catch (JSONException jsonException) {
            _log.error((Throwable)jsonException);
            return null;
        }
    }

    static {
        _log = LogFactoryUtil.getLog(WorkflowMetricsIndex.class);
    }
}

