/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.search.index.util.WorkflowMetricsIndexerUtil;
import com.liferay.portal.workflow.metrics.model.AddTaskRequest;
import com.liferay.portal.workflow.metrics.model.Assignment;
import com.liferay.portal.workflow.metrics.model.CompleteTaskRequest;
import com.liferay.portal.workflow.metrics.model.DeleteTaskRequest;
import com.liferay.portal.workflow.metrics.model.RoleAssignment;
import com.liferay.portal.workflow.metrics.model.UpdateTaskRequest;
import com.liferay.portal.workflow.metrics.model.UserAssignment;
import com.liferay.portal.workflow.metrics.search.index.TaskWorkflowMetricsIndexer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TaskWorkflowMetricsIndexer.class})
public class TaskWorkflowMetricsIndexerImpl
extends BaseWorkflowMetricsIndexer
implements TaskWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;

    public Document addTask(AddTaskRequest addTaskRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return documentBuilder.build();
        }
        documentBuilder.setValue("active", (Object)Boolean.TRUE);
        ArrayList<Long> assignmentGroupIds = new ArrayList<Long>();
        ArrayList<Long> assignmentIds = new ArrayList<Long>();
        this._populateTaskAssignments(assignmentGroupIds, assignmentIds, addTaskRequest.getAssignments());
        String assignmentType = this._getAssignmentType(addTaskRequest.getAssignments());
        if (!assignmentIds.isEmpty()) {
            documentBuilder.setLongs("assigneeIds", assignmentIds.toArray(new Long[0]));
            documentBuilder.setString("assigneeType", assignmentType);
        }
        documentBuilder.setString("className", addTaskRequest.getClassName()).setLong("classPK", Long.valueOf(addTaskRequest.getClassPK())).setLong("companyId", Long.valueOf(addTaskRequest.getCompanyId())).setValue("completed", (Object)addTaskRequest.isCompleted());
        if (addTaskRequest.isCompleted()) {
            documentBuilder.setDate("completionDate", this.getDate(addTaskRequest.getCompletionDate())).setLong("completionUserId", addTaskRequest.getCompletionUserId());
        }
        Date createDate = addTaskRequest.getCreateDate();
        documentBuilder.setDate("createDate", this.getDate(createDate)).setValue(Field.getSortableFieldName((String)"createDate_Number"), (Object)createDate.getTime()).setValue("deleted", (Object)false);
        if (addTaskRequest.isCompleted()) {
            documentBuilder.setLong("duration", Long.valueOf(this._getDuration(addTaskRequest.getCompletionDate(), createDate)));
        }
        documentBuilder.setValue("instanceCompleted", (Object)addTaskRequest.isInstanceCompleted()).setDate("instanceCompletionDate", this.getDate(addTaskRequest.getInstanceCompletionDate())).setLong("instanceId", Long.valueOf(addTaskRequest.getInstanceId())).setDate("modifiedDate", this.getDate(addTaskRequest.getModifiedDate())).setString("name", addTaskRequest.getName()).setString(Field.getSortableFieldName((String)"name"), StringUtil.toLowerCase((String)addTaskRequest.getName())).setLong("nodeId", Long.valueOf(addTaskRequest.getNodeId())).setLong("processId", Long.valueOf(addTaskRequest.getProcessId())).setLong("taskId", Long.valueOf(addTaskRequest.getTaskId())).setString("uid", this.digest(Long.valueOf(addTaskRequest.getCompanyId()), Long.valueOf(addTaskRequest.getTaskId()))).setLong("userId", Long.valueOf(addTaskRequest.getUserId())).setString("version", addTaskRequest.getProcessVersion());
        this.setLocalizedField(documentBuilder, "assetTitle", addTaskRequest.getAssetTitleMap());
        this.setLocalizedField(documentBuilder, "assetType", addTaskRequest.getAssetTypeMap());
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.addDocument(document);
            if (addTaskRequest.isCompleted()) {
                return;
            }
            ScriptBuilder scriptBuilder = this.scripts.builder();
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", addTaskRequest.getCompanyId()), WorkflowMetricsIndexerUtil.digest("WorkflowMetricsInstanceType", Long.valueOf(addTaskRequest.getCompanyId()), Long.valueOf(addTaskRequest.getInstanceId())), scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"dependencies/workflow-metrics-add-task-script.painless")).language("painless").putParameter("task", (Object)HashMapBuilder.put((Object)"assigneeGroupIds", (Object)assignmentGroupIds).put((Object)"assigneeIds", (Object)assignmentIds).put((Object)"assigneeName", (Object)this._getAssigneeName(addTaskRequest.getAssignments())).put((Object)"assigneeType", (Object)assignmentType).put((Object)"taskId", (Object)addTaskRequest.getTaskId()).put((Object)"taskName", (Object)addTaskRequest.getName()).build()).scriptType(ScriptType.INLINE).build());
            updateDocumentRequest.setScriptedUpsert(true);
            if (PortalRunMode.isTestMode()) {
                updateDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
        });
        return document;
    }

    public Document completeTask(CompleteTaskRequest completeTaskRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(completeTaskRequest.getCompanyId())).setValue("completed", (Object)true).setDate("completionDate", this.getDate(completeTaskRequest.getCompletionDate())).setLong("completionUserId", completeTaskRequest.getCompletionUserId()).setLong("duration", Long.valueOf(completeTaskRequest.getDuration())).setDate("modifiedDate", this.getDate(completeTaskRequest.getModifiedDate())).setLong("taskId", Long.valueOf(completeTaskRequest.getTaskId())).setString("uid", this.digest(Long.valueOf(completeTaskRequest.getCompanyId()), Long.valueOf(completeTaskRequest.getTaskId()))).setLong("userId", Long.valueOf(completeTaskRequest.getUserId()));
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.updateDocument(document);
            this._deleteTask(completeTaskRequest.getCompanyId(), completeTaskRequest.getTaskId());
            BooleanQuery booleanQuery = this.queries.booleanQuery();
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)completeTaskRequest.getCompanyId()), this.queries.term("taskId", (Object)completeTaskRequest.getTaskId())});
            this._slaTaskResultWorkflowMetricsIndexer.updateDocuments(completeTaskRequest.getCompanyId(), HashMapBuilder.put((Object)"completionDate", (Object)document.getDate("completionDate")).put((Object)"completionUserId", (Object)document.getLong("completionUserId")).build(), (Query)booleanQuery);
        });
        return document;
    }

    public void deleteTask(DeleteTaskRequest deleteTaskRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(deleteTaskRequest.getCompanyId())).setLong("taskId", Long.valueOf(deleteTaskRequest.getTaskId())).setString("uid", this.digest(Long.valueOf(deleteTaskRequest.getCompanyId()), Long.valueOf(deleteTaskRequest.getTaskId())));
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.deleteDocument(documentBuilder);
            this._deleteTask(deleteTaskRequest.getCompanyId(), deleteTaskRequest.getTaskId());
        });
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-tasks", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsTaskType";
    }

    public Document updateTask(UpdateTaskRequest updateTaskRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return documentBuilder.build();
        }
        ArrayList<Long> assignmentGroupIds = new ArrayList<Long>();
        ArrayList<Long> assignmentIds = new ArrayList<Long>();
        this._populateTaskAssignments(assignmentGroupIds, assignmentIds, updateTaskRequest.getAssignments());
        String assignmentType = this._getAssignmentType(updateTaskRequest.getAssignments());
        if (!assignmentIds.isEmpty()) {
            documentBuilder.setLongs("assigneeIds", assignmentIds.toArray(new Long[0]));
            documentBuilder.setString("assigneeType", assignmentType);
        }
        documentBuilder.setLong("companyId", Long.valueOf(updateTaskRequest.getCompanyId())).setDate("modifiedDate", this.getDate(updateTaskRequest.getModifiedDate())).setLong("taskId", Long.valueOf(updateTaskRequest.getTaskId())).setString("uid", this.digest(Long.valueOf(updateTaskRequest.getCompanyId()), Long.valueOf(updateTaskRequest.getTaskId()))).setLong("userId", Long.valueOf(updateTaskRequest.getUserId()));
        this.setLocalizedField(documentBuilder, "assetTitle", updateTaskRequest.getAssetTitleMap());
        this.setLocalizedField(documentBuilder, "assetType", updateTaskRequest.getAssetTypeMap());
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.updateDocument(document);
            if (Objects.isNull(document.getLongs("assigneeIds"))) {
                return;
            }
            BooleanQuery booleanQuery = this.queries.booleanQuery();
            booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)document.getLong("companyId")), this.queries.term("taskId", (Object)document.getLong("taskId"))});
            this._slaTaskResultWorkflowMetricsIndexer.updateDocuments(updateTaskRequest.getCompanyId(), HashMapBuilder.put((Object)"assigneeIds", (Object)assignmentIds).put((Object)"assigneeType", (Object)assignmentType).build(), (Query)booleanQuery);
            ScriptBuilder scriptBuilder = this.scripts.builder();
            scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"dependencies/workflow-metrics-update-task-script.painless")).language("painless").putParameter("task", (Object)HashMapBuilder.put((Object)"assigneeGroupIds", (Object)assignmentGroupIds).put((Object)"assigneeIds", (Object)assignmentIds).put((Object)"assigneeName", (Object)this._getAssigneeName(updateTaskRequest.getAssignments())).put((Object)"assigneeType", (Object)assignmentType).put((Object)"taskId", (Object)updateTaskRequest.getTaskId()).build()).scriptType(ScriptType.INLINE);
            UpdateByQueryDocumentRequest updateByQueryDocumentRequest = new UpdateByQueryDocumentRequest((Query)this.queries.nested("tasks", (Query)this.queries.term("tasks.taskId", (Object)updateTaskRequest.getTaskId())), scriptBuilder.build(), new String[]{WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", updateTaskRequest.getCompanyId())});
            updateByQueryDocumentRequest.setRefresh(true);
            this.searchEngineAdapter.execute((DocumentRequest)updateByQueryDocumentRequest);
        });
        return document;
    }

    private void _deleteTask(long companyId, long taskId) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        ScriptBuilder scriptBuilder = this.scripts.builder();
        this.searchEngineAdapter.execute((DocumentRequest)new UpdateByQueryDocumentRequest((Query)this.queries.nested("tasks", (Query)this.queries.term("tasks.taskId", (Object)taskId)), scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"dependencies/workflow-metrics-delete-task-script.painless")).language("painless").putParameter("taskId", (Object)taskId).scriptType(ScriptType.INLINE).build(), new String[]{WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", companyId)}));
    }

    private String _getAssigneeName(List<Assignment> assignments) {
        if (ListUtil.isEmpty(assignments) || assignments.get(0) instanceof RoleAssignment) {
            return null;
        }
        UserAssignment userAssignment = (UserAssignment)assignments.get(0);
        return userAssignment.getName();
    }

    private String _getAssignmentType(List<Assignment> assignments) {
        if (ListUtil.isEmpty(assignments)) {
            return null;
        }
        Assignment assignment = assignments.get(0);
        if (assignment instanceof RoleAssignment) {
            return Role.class.getName();
        }
        return User.class.getName();
    }

    private long _getDuration(Date completionDate, Date createDate) {
        Duration duration = Duration.between(createDate.toInstant(), completionDate.toInstant());
        return duration.toMillis();
    }

    private void _populateTaskAssignments(List<Long> assignmentGroupIds, List<Long> assignmentIds, List<Assignment> assignments) {
        if (ListUtil.isEmpty(assignments)) {
            return;
        }
        Assignment firstAssignment = assignments.get(0);
        if (firstAssignment instanceof RoleAssignment) {
            for (Assignment assignment : assignments) {
                assignmentIds.add(assignment.getAssignmentId());
                RoleAssignment roleAssignment = (RoleAssignment)assignment;
                assignmentGroupIds.addAll(roleAssignment.getGroupIds());
            }
        } else {
            assignmentIds.add(firstAssignment.getAssignmentId());
        }
    }
}

