/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseSLAWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLATaskResult;
import com.liferay.portal.workflow.metrics.sla.processor.WorkflowMetricsSLAStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SLATaskResultWorkflowMetricsIndexer.class})
public class SLATaskResultWorkflowMetricsIndexer
extends BaseSLAWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public Document creatDefaultDocument(long companyId, long nodeId, long processId, String taskName) {
        WorkflowMetricsSLATaskResult workflowMetricsSLATaskResult = new WorkflowMetricsSLATaskResult();
        workflowMetricsSLATaskResult.setCompanyId(companyId);
        workflowMetricsSLATaskResult.setNodeId(nodeId);
        workflowMetricsSLATaskResult.setProcessId(processId);
        workflowMetricsSLATaskResult.setTaskName(taskName);
        return this.createDocument(workflowMetricsSLATaskResult);
    }

    public Document createDocument(WorkflowMetricsSLATaskResult workflowMetricsSLATaskResult) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)true);
        if (workflowMetricsSLATaskResult.getAssigneeIds() != null) {
            documentBuilder.setLongs("assigneeIds", workflowMetricsSLATaskResult.getAssigneeIds());
            documentBuilder.setString("assigneeType", workflowMetricsSLATaskResult.getAssigneeType());
        }
        documentBuilder.setValue("breached", (Object)workflowMetricsSLATaskResult.isBreached()).setLong("companyId", Long.valueOf(workflowMetricsSLATaskResult.getCompanyId()));
        if (workflowMetricsSLATaskResult.getCompletionLocalDateTime() != null) {
            documentBuilder.setDate("completionDate", this.formatLocalDateTime(workflowMetricsSLATaskResult.getCompletionLocalDateTime()));
        }
        if (workflowMetricsSLATaskResult.getCompletionUserId() != null) {
            documentBuilder.setLong("completionUserId", workflowMetricsSLATaskResult.getCompletionUserId());
        }
        documentBuilder.setValue("deleted", (Object)false).setValue("instanceCompleted", (Object)workflowMetricsSLATaskResult.isInstanceCompleted());
        if (workflowMetricsSLATaskResult.getInstanceCompletionLocalDateTime() != null) {
            documentBuilder.setDate("instanceCompletionDate", this.formatLocalDateTime(workflowMetricsSLATaskResult.getInstanceCompletionLocalDateTime()));
        }
        documentBuilder.setLong("instanceId", Long.valueOf(workflowMetricsSLATaskResult.getInstanceId()));
        if (workflowMetricsSLATaskResult.getModifiedLocalDateTime() != null) {
            documentBuilder.setDate("modifiedDate", this.formatLocalDateTime(workflowMetricsSLATaskResult.getModifiedLocalDateTime()));
        }
        documentBuilder.setLong("nodeId", Long.valueOf(workflowMetricsSLATaskResult.getNodeId())).setValue("onTime", (Object)workflowMetricsSLATaskResult.isOnTime()).setLong("processId", Long.valueOf(workflowMetricsSLATaskResult.getProcessId())).setLong("slaDefinitionId", Long.valueOf(workflowMetricsSLATaskResult.getSLADefinitionId()));
        WorkflowMetricsSLAStatus workflowMetricsSLAStatus = workflowMetricsSLATaskResult.getWorkflowMetricsSLAStatus();
        if (workflowMetricsSLAStatus != null) {
            documentBuilder.setString("status", workflowMetricsSLAStatus.name());
        }
        documentBuilder.setLong("taskId", Long.valueOf(workflowMetricsSLATaskResult.getTaskId())).setString("taskName", workflowMetricsSLATaskResult.getTaskName()).setString("uid", this.digest(Long.valueOf(workflowMetricsSLATaskResult.getCompanyId()), Long.valueOf(workflowMetricsSLATaskResult.getInstanceId()), Long.valueOf(workflowMetricsSLATaskResult.getNodeId()), Long.valueOf(workflowMetricsSLATaskResult.getProcessId()), Long.valueOf(workflowMetricsSLATaskResult.getSLADefinitionId()), Long.valueOf(workflowMetricsSLATaskResult.getTaskId())));
        return documentBuilder.build();
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-sla-task-results", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsSLATaskResultType";
    }
}

