/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseSLAWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAInstanceResult;
import com.liferay.portal.workflow.metrics.sla.processor.WorkflowMetricsSLAStatus;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SLAInstanceResultWorkflowMetricsIndexer.class})
public class SLAInstanceResultWorkflowMetricsIndexer
extends BaseSLAWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;

    public void blockDocuments(long companyId, long processId, long slaDefinitionId) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        booleanQuery.addMustNotQueryClauses(new Query[]{this.queries.term("instanceCompleted", (Object)Boolean.TRUE)});
        this.updateDocuments(companyId, HashMapBuilder.put((Object)"blocked", (Object)Boolean.TRUE).build(), (Query)booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("processId", (Object)processId), this.queries.term("slaDefinitionId", (Object)slaDefinitionId)}));
    }

    public Document creatDefaultDocument(long companyId, long processId) {
        WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult = new WorkflowMetricsSLAInstanceResult();
        workflowMetricsSLAInstanceResult.setCompanyId(companyId);
        workflowMetricsSLAInstanceResult.setProcessId(processId);
        return this.createDocument(workflowMetricsSLAInstanceResult);
    }

    public Document createDocument(WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)true).setValue("blocked", (Object)false).setLong("companyId", Long.valueOf(workflowMetricsSLAInstanceResult.getCompanyId()));
        if (workflowMetricsSLAInstanceResult.getCompletionLocalDateTime() != null) {
            documentBuilder.setDate("completionDate", this.formatLocalDateTime(workflowMetricsSLAInstanceResult.getCompletionLocalDateTime()));
        }
        documentBuilder.setValue("deleted", (Object)false).setLong("elapsedTime", Long.valueOf(workflowMetricsSLAInstanceResult.getElapsedTime())).setValue("instanceCompleted", (Object)(workflowMetricsSLAInstanceResult.getCompletionLocalDateTime() != null ? 1 : 0)).setLong("instanceId", Long.valueOf(workflowMetricsSLAInstanceResult.getInstanceId()));
        if (workflowMetricsSLAInstanceResult.getModifiedLocalDateTime() != null) {
            documentBuilder.setDate("modifiedDate", this.formatLocalDateTime(workflowMetricsSLAInstanceResult.getModifiedLocalDateTime()));
        }
        documentBuilder.setValue("onTime", (Object)workflowMetricsSLAInstanceResult.isOnTime());
        if (workflowMetricsSLAInstanceResult.getOverdueLocalDateTime() != null) {
            documentBuilder.setDate("overdueDate", this.formatLocalDateTime(workflowMetricsSLAInstanceResult.getOverdueLocalDateTime()));
        }
        documentBuilder.setLong("processId", Long.valueOf(workflowMetricsSLAInstanceResult.getProcessId())).setLong("remainingTime", Long.valueOf(workflowMetricsSLAInstanceResult.getRemainingTime())).setLong("slaDefinitionId", Long.valueOf(workflowMetricsSLAInstanceResult.getSLADefinitionId()));
        WorkflowMetricsSLAStatus workflowMetricsSLAStatus = workflowMetricsSLAInstanceResult.getWorkflowMetricsSLAStatus();
        if (workflowMetricsSLAStatus != null) {
            documentBuilder.setString("status", workflowMetricsSLAStatus.name());
        }
        documentBuilder.setString("uid", this.digest(Long.valueOf(workflowMetricsSLAInstanceResult.getCompanyId()), Long.valueOf(workflowMetricsSLAInstanceResult.getInstanceId()), Long.valueOf(workflowMetricsSLAInstanceResult.getProcessId()), Long.valueOf(workflowMetricsSLAInstanceResult.getSLADefinitionId())));
        return documentBuilder.build();
    }

    @Override
    public void deleteDocuments(long companyId, long processId, long slaDefinitionId) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        super.deleteDocuments(companyId, processId, slaDefinitionId);
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        BooleanQuery filterBooleanQuery = this.queries.booleanQuery();
        filterBooleanQuery.addMustNotQueryClauses(new Query[]{this.queries.term("instanceCompleted", (Object)Boolean.TRUE)});
        filterBooleanQuery.addMustQueryClauses(new Query[]{this.queries.term("completed", (Object)false), this.queries.term("processId", (Object)processId), this.queries.nested("slaResults", (Query)this.queries.term("slaResults.slaDefinitionId", (Object)slaDefinitionId))});
        booleanQuery.addFilterQueryClauses(new Query[]{filterBooleanQuery});
        ScriptBuilder scriptBuilder = this.scripts.builder();
        UpdateByQueryDocumentRequest updateByQueryDocumentRequest = new UpdateByQueryDocumentRequest((Query)booleanQuery, scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"dependencies/workflow-metrics-delete-sla-result-script.painless")).language("painless").putParameter("slaDefinitionId", (Object)slaDefinitionId).scriptType(ScriptType.INLINE).build(), new String[]{WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", companyId)});
        if (PortalRunMode.isTestMode()) {
            updateByQueryDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)updateByQueryDocumentRequest);
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-sla-instance-results", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsSLAInstanceResultType";
    }
}

