/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAInstanceResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.search.index.util.WorkflowMetricsIndexerUtil;
import com.liferay.portal.workflow.metrics.model.AddProcessRequest;
import com.liferay.portal.workflow.metrics.model.DeleteProcessRequest;
import com.liferay.portal.workflow.metrics.model.UpdateProcessRequest;
import com.liferay.portal.workflow.metrics.search.index.ProcessWorkflowMetricsIndexer;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ProcessWorkflowMetricsIndexer.class})
public class ProcessWorkflowMetricsIndexerImpl
extends BaseWorkflowMetricsIndexer
implements ProcessWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private SLAInstanceResultWorkflowMetricsIndexer _slaInstanceResultWorkflowMetricsIndexer;

    @Override
    public void addDocument(Document document) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", document.getLong("companyId")), this._createWorkflowMetricsInstanceDocument(document.getLong("companyId"), document.getLong("processId"))));
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._slaInstanceResultWorkflowMetricsIndexer.getIndexName(document.getLong("companyId")), this._slaInstanceResultWorkflowMetricsIndexer.creatDefaultDocument(document.getLong("companyId"), document.getLong("processId"))));
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-processes", document.getLong("companyId")), document));
        if (PortalRunMode.isTestMode()) {
            bulkDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    public Document addProcess(AddProcessRequest addProcessRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)addProcessRequest.isActive()).setLong("companyId", Long.valueOf(addProcessRequest.getCompanyId())).setDate("createDate", this.getDate(addProcessRequest.getCreateDate())).setValue("deleted", (Object)false).setString("description", addProcessRequest.getDescription()).setDate("modifiedDate", this.getDate(addProcessRequest.getModifiedDate())).setString("name", addProcessRequest.getName()).setLong("processId", Long.valueOf(addProcessRequest.getProcessId())).setString("title", addProcessRequest.getTitle()).setString("uid", this.digest(Long.valueOf(addProcessRequest.getCompanyId()), Long.valueOf(addProcessRequest.getProcessId()))).setString("version", addProcessRequest.getVersion()).setStrings("versions", addProcessRequest.getVersions());
        this.setLocalizedField(documentBuilder, "title", addProcessRequest.getTitleMap());
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(document));
        return document;
    }

    public void deleteProcess(DeleteProcessRequest deleteProcessRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(deleteProcessRequest.getCompanyId())).setLong("processId", Long.valueOf(deleteProcessRequest.getProcessId())).setString("uid", this.digest(Long.valueOf(deleteProcessRequest.getCompanyId()), Long.valueOf(deleteProcessRequest.getProcessId())));
        this.workflowMetricsPortalExecutor.execute(() -> this.deleteDocument(documentBuilder));
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-processes", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsProcessType";
    }

    public Document updateProcess(UpdateProcessRequest updateProcessRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return documentBuilder.build();
        }
        if (updateProcessRequest.getActive() != null) {
            documentBuilder.setValue("active", (Object)updateProcessRequest.getActive());
        }
        documentBuilder.setLong("companyId", Long.valueOf(updateProcessRequest.getCompanyId()));
        if (updateProcessRequest.getDescription() != null) {
            documentBuilder.setValue("description", (Object)updateProcessRequest.getDescription());
        }
        documentBuilder.setDate("modifiedDate", this.getDate(updateProcessRequest.getModifiedDate())).setLong("processId", Long.valueOf(updateProcessRequest.getProcessId()));
        if (updateProcessRequest.getTitle() != null) {
            documentBuilder.setValue("title", (Object)updateProcessRequest.getTitle());
        }
        documentBuilder.setString("uid", this.digest(Long.valueOf(updateProcessRequest.getCompanyId()), Long.valueOf(updateProcessRequest.getProcessId()))).setValue("version", (Object)updateProcessRequest.getVersion());
        if (MapUtil.isNotEmpty((Map)updateProcessRequest.getTitleMap())) {
            this.setLocalizedField(documentBuilder, "title", updateProcessRequest.getTitleMap());
        }
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.updateDocument(document);
            ScriptBuilder scriptBuilder = this.scripts.builder();
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this.getIndexName(updateProcessRequest.getCompanyId()), WorkflowMetricsIndexerUtil.digest("WorkflowMetricsProcessType", Long.valueOf(updateProcessRequest.getCompanyId()), Long.valueOf(updateProcessRequest.getProcessId())), scriptBuilder.idOrCode(StringUtil.read(this.getClass(), (String)"dependencies/workflow-metrics-update-process-versions-script.painless")).language("painless").putParameter("version", (Object)updateProcessRequest.getVersion()).scriptType(ScriptType.INLINE).build());
            if (PortalRunMode.isTestMode()) {
                updateDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
        });
        return document;
    }

    private Document _createWorkflowMetricsInstanceDocument(long companyId, long processId) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)true).setLong("companyId", Long.valueOf(companyId)).setValue("completed", (Object)false).setValue("deleted", (Object)false).setLong("instanceId", Long.valueOf(0L)).setLong("processId", Long.valueOf(processId)).setString("uid", WorkflowMetricsIndexerUtil.digest("WorkflowMetricsInstanceType", Long.valueOf(companyId), Long.valueOf(processId)));
        return documentBuilder.build();
    }
}

