/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.search.index.util.WorkflowMetricsIndexerUtil;
import com.liferay.portal.workflow.metrics.model.AddNodeRequest;
import com.liferay.portal.workflow.metrics.model.DeleteNodeRequest;
import com.liferay.portal.workflow.metrics.search.index.NodeWorkflowMetricsIndexer;
import java.io.Serializable;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NodeWorkflowMetricsIndexer.class})
public class NodeWorkflowMetricsIndexerImpl
extends BaseWorkflowMetricsIndexer
implements NodeWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;

    public Document addNode(AddNodeRequest addNodeRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        Document document = documentBuilder.setLong("companyId", Long.valueOf(addNodeRequest.getCompanyId())).setDate("createDate", this.getDate(addNodeRequest.getCreateDate())).setValue("deleted", (Object)false).setValue("initial", (Object)addNodeRequest.getInitial()).setDate("modifiedDate", this.getDate(addNodeRequest.getModifiedDate())).setString("name", addNodeRequest.getName()).setString(Field.getSortableFieldName((String)"name"), StringUtil.toLowerCase((String)addNodeRequest.getName())).setLong("nodeId", Long.valueOf(addNodeRequest.getNodeId())).setLong("processId", Long.valueOf(addNodeRequest.getProcessId())).setValue("terminal", (Object)addNodeRequest.getTerminal()).setString("type", addNodeRequest.getType()).setString("uid", this.digest(Long.valueOf(addNodeRequest.getCompanyId()), Long.valueOf(addNodeRequest.getNodeId()))).setString("version", addNodeRequest.getProcessVersion()).build();
        this.workflowMetricsPortalExecutor.execute(() -> this.addDocument(document));
        return document;
    }

    public void deleteNode(DeleteNodeRequest deleteNodeRequest) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(deleteNodeRequest.getCompanyId())).setLong("nodeId", Long.valueOf(deleteNodeRequest.getNodeId())).setString("uid", this.digest(Long.valueOf(deleteNodeRequest.getCompanyId()), Long.valueOf(deleteNodeRequest.getNodeId())));
        this.workflowMetricsPortalExecutor.execute(() -> this.deleteDocument(documentBuilder));
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-nodes", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsNodeType";
    }

    @Override
    protected void addDocument(Document document) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        super.addDocument(document);
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        if (Objects.equals(document.getString("type"), "TASK")) {
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this._slaTaskResultWorkflowMetricsIndexer.getIndexName(document.getLong("companyId")), this._slaTaskResultWorkflowMetricsIndexer.creatDefaultDocument(document.getLong("companyId"), document.getLong("nodeId"), document.getLong("processId"), document.getString("name"))));
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-tasks", document.getLong("companyId")), this._createWorkflowMetricsTaskDocument(document.getLong("companyId"), document.getLong("processId"), document.getLong("nodeId"), document.getString("name"), document.getString("version"))));
        }
        bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-nodes", document.getLong("companyId")), document));
        if (PortalRunMode.isTestMode()) {
            bulkDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
    }

    private Document _createWorkflowMetricsTaskDocument(long companyId, long processId, long nodeId, String name, String processVersion) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(companyId)).setValue("completed", (Object)false).setValue("deleted", (Object)false).setValue("instanceCompleted", (Object)false).setLong("instanceId", Long.valueOf(0L)).setString("name", name).setString(Field.getSortableFieldName((String)"name"), StringUtil.toLowerCase((String)name)).setLong("nodeId", Long.valueOf(nodeId)).setLong("processId", Long.valueOf(processId)).setLong("taskId", Long.valueOf(0L)).setString("uid", WorkflowMetricsIndexerUtil.digest("WorkflowMetricsTaskType", new Serializable[]{Long.valueOf(companyId), Long.valueOf(processId), processVersion, Long.valueOf(nodeId)})).setString("version", processVersion);
        return documentBuilder.build();
    }
}

