/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.search.index.BaseWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAInstanceResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.sla.WorkflowMetricsInstanceSLAStatus;
import com.liferay.portal.workflow.metrics.search.index.InstanceWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.search.index.TaskWorkflowMetricsIndexer;
import java.time.Duration;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={InstanceWorkflowMetricsIndexer.class})
public class InstanceWorkflowMetricsIndexerImpl
extends BaseWorkflowMetricsIndexer
implements InstanceWorkflowMetricsIndexer {
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private SLAInstanceResultWorkflowMetricsIndexer _slaInstanceResultWorkflowMetricsIndexer;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @Reference
    private TaskWorkflowMetricsIndexer _taskWorkflowMetricsIndexer;

    public Document addInstance(Map<Locale, String> assetTitleMap, Map<Locale, String> assetTypeMap, String className, long classPK, long companyId, Date completionDate, Date createDate, long instanceId, Date modifiedDate, long processId, String processVersion, long userId, String userName) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)true).setString("className", className).setLong("classPK", Long.valueOf(classPK)).setLong("companyId", Long.valueOf(companyId)).setValue("completed", (Object)(completionDate != null ? 1 : 0));
        if (completionDate != null) {
            documentBuilder.setDate("completionDate", this.getDate(completionDate)).setValue(Field.getSortableFieldName((String)"completionDate_Number"), (Object)completionDate.getTime());
        }
        documentBuilder.setDate("createDate", this.getDate(createDate)).setValue(Field.getSortableFieldName((String)"createDate_Number"), (Object)createDate.getTime()).setValue("deleted", (Object)Boolean.FALSE);
        if (completionDate != null) {
            documentBuilder.setLong("duration", Long.valueOf(this._getDuration(completionDate, createDate)));
        }
        documentBuilder.setLong("instanceId", Long.valueOf(instanceId)).setDate("modifiedDate", this.getDate(modifiedDate)).setLong("processId", Long.valueOf(processId)).setString("uid", this.digest(Long.valueOf(companyId), Long.valueOf(instanceId))).setLong("userId", Long.valueOf(userId)).setString("userName", userName).setString("slaStatus", WorkflowMetricsInstanceSLAStatus.UNTRACKED.getValue()).setString("version", processVersion);
        this.setLocalizedField(documentBuilder, "assetTitle", assetTitleMap);
        this.setLocalizedField(documentBuilder, "assetType", assetTypeMap);
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> this.updateDocument(document));
        return document;
    }

    public Document completeInstance(long companyId, Date completionDate, long duration, long instanceId, Date modifiedDate) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(companyId)).setValue("completed", (Object)(completionDate != null ? 1 : 0)).setDate("completionDate", this.getDate(completionDate)).setValue(Field.getSortableFieldName((String)"completionDate_Number"), (Object)completionDate.getTime()).setLong("duration", Long.valueOf(duration)).setLong("instanceId", Long.valueOf(instanceId)).setDate("modifiedDate", this.getDate(modifiedDate)).setString("uid", this.digest(Long.valueOf(companyId), Long.valueOf(instanceId)));
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.updateDocument(document);
            this._updateDocuments(companyId, HashMapBuilder.put((Object)"completionDate", (Object)document.getDate("completionDate")).put((Object)"instanceCompleted", (Object)Boolean.TRUE).build(), instanceId);
        });
        return document;
    }

    public void deleteInstance(long companyId, long instanceId) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setLong("companyId", Long.valueOf(companyId)).setLong("instanceId", Long.valueOf(instanceId)).setString("uid", this.digest(Long.valueOf(companyId), Long.valueOf(instanceId)));
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.deleteDocument(documentBuilder);
            this._slaInstanceResultWorkflowMetricsIndexer.deleteDocuments(companyId, instanceId);
            this._slaTaskResultWorkflowMetricsIndexer.deleteDocuments(companyId, instanceId);
        });
    }

    @Override
    public String getIndexName(long companyId) {
        return WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", companyId);
    }

    @Override
    public String getIndexType() {
        return "WorkflowMetricsInstanceType";
    }

    public Document updateInstance(boolean active, Map<Locale, String> assetTitleMap, Map<Locale, String> assetTypeMap, long companyId, long instanceId, Date modifiedDate) {
        DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
        documentBuilder.setValue("active", (Object)active).setLong("companyId", Long.valueOf(companyId)).setDate("modifiedDate", this.getDate(modifiedDate)).setString("uid", this.digest(Long.valueOf(companyId), Long.valueOf(instanceId)));
        this.setLocalizedField(documentBuilder, "assetTitle", assetTitleMap);
        this.setLocalizedField(documentBuilder, "assetType", assetTypeMap);
        Document document = documentBuilder.build();
        this.workflowMetricsPortalExecutor.execute(() -> {
            this.updateDocument(document);
            this._updateDocuments(companyId, HashMapBuilder.put((Object)"active", (Object)active).build(), instanceId);
        });
        return document;
    }

    private long _getDuration(Date completionDate, Date createDate) {
        Duration duration = Duration.between(createDate.toInstant(), completionDate.toInstant());
        return duration.toMillis();
    }

    private void _updateDocuments(long companyId, Map<String, Object> fieldsMap, long instanceId) {
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        booleanQuery.addMustQueryClauses(new Query[]{this.queries.term("companyId", (Object)companyId), this.queries.term("instanceId", (Object)instanceId)});
        this._slaInstanceResultWorkflowMetricsIndexer.updateDocuments(companyId, fieldsMap, (Query)booleanQuery);
        this._slaTaskResultWorkflowMetricsIndexer.updateDocuments(companyId, fieldsMap, (Query)booleanQuery);
        BaseWorkflowMetricsIndexer baseWorkflowMetricsIndexer = (BaseWorkflowMetricsIndexer)this._taskWorkflowMetricsIndexer;
        baseWorkflowMetricsIndexer.updateDocuments(companyId, fieldsMap, (Query)booleanQuery);
    }
}

