/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.search.index;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.document.DocumentBuilder;
import com.liferay.portal.search.document.DocumentBuilderFactory;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.IndexDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.workflow.metrics.internal.petra.executor.WorkflowMetricsPortalExecutor;
import com.liferay.portal.workflow.metrics.internal.search.index.util.WorkflowMetricsIndexerUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseWorkflowMetricsIndexer {
    @Reference
    protected DocumentBuilderFactory documentBuilderFactory;
    @Reference
    protected Queries queries;
    @Reference
    protected Scripts scripts;
    @Reference
    protected SearchCapabilities searchCapabilities;
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    @Reference
    protected WorkflowMetricsPortalExecutor workflowMetricsPortalExecutor;
    private static final Log _log = LogFactoryUtil.getLog(BaseWorkflowMetricsIndexer.class);
    private final DateTimeFormatter _dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public void addDocuments(List<Document> documents) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        documents.forEach(document -> bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new IndexDocumentRequest(this.getIndexName(document.getLong("companyId")), document.getString("uid"), document)));
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            if (PortalRunMode.isTestMode()) {
                bulkDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }

    public void deleteDocument(DocumentBuilder documentBuilder) {
        documentBuilder.setValue("deleted", (Object)true);
        this._updateDocument(documentBuilder.build());
    }

    public abstract String getIndexName(long var1);

    public abstract String getIndexType();

    public void updateDocument(Document document) {
        this._updateDocument(document);
    }

    protected void addDocument(Document document) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        IndexDocumentRequest indexDocumentRequest = new IndexDocumentRequest(this.getIndexName(document.getLong("companyId")), document);
        if (PortalRunMode.isTestMode()) {
            indexDocumentRequest.setRefresh(true);
        }
        this.searchEngineAdapter.execute((DocumentRequest)indexDocumentRequest);
    }

    protected String digest(Serializable ... parts) {
        return WorkflowMetricsIndexerUtil.digest(this.getIndexType(), parts);
    }

    protected String formatLocalDateTime(LocalDateTime localDateTime) {
        return this._dateTimeFormatter.format(localDateTime);
    }

    protected String getDate(Date date) {
        try {
            return DateUtil.getDate((Date)date, (String)"yyyyMMddHHmmss", (Locale)LocaleUtil.getDefault());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    protected void setLocalizedField(DocumentBuilder documentBuilder, String fieldName, Map<Locale, String> localizedMap) {
        for (Map.Entry<Locale, String> entry : localizedMap.entrySet()) {
            String localizedName = Field.getLocalizedName((Locale)entry.getKey(), (String)fieldName);
            documentBuilder.setValue(localizedName, (Object)entry.getValue()).setValue(Field.getSortableFieldName((String)localizedName), (Object)entry.getValue());
        }
    }

    protected void updateDocuments(long companyId, Map<String, Object> fieldsMap, Query filterQuery) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this.getIndexName(companyId)});
        BooleanQuery booleanQuery = this.queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addFilterQueryClauses(new Query[]{filterQuery}));
        searchSearchRequest.setSelectedFieldNames(new String[]{"uid"});
        searchSearchRequest.setSize(Integer.valueOf(10000));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this.searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        if (searchHits.getTotalHits() == 0L) {
            return;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            Document document = searchHit.getDocument();
            DocumentBuilder documentBuilder = this.documentBuilderFactory.builder();
            documentBuilder.setString("uid", document.getString("uid"));
            fieldsMap.forEach((arg_0, arg_1) -> ((DocumentBuilder)documentBuilder).setValue(arg_0, arg_1));
            UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this.getIndexName(companyId), document.getString("uid"), documentBuilder.build());
            updateDocumentRequest.setUpsert(true);
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)updateDocumentRequest);
        }
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            if (PortalRunMode.isTestMode()) {
                bulkDocumentRequest.setRefresh(true);
            }
            this.searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
    }

    private void _updateDocument(Document document) {
        if (!this.searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        UpdateDocumentRequest updateDocumentRequest = new UpdateDocumentRequest(this.getIndexName(document.getLong("companyId")), document.getString("uid"), document);
        if (PortalRunMode.isTestMode()) {
            updateDocumentRequest.setRefresh(true);
        }
        updateDocumentRequest.setUpsert(true);
        this.searchEngineAdapter.execute((DocumentRequest)updateDocumentRequest);
    }
}

