/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.scheduler;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.index.IndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexRequest;
import com.liferay.portal.search.engine.adapter.index.IndicesExistsIndexResponse;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.workflow.metrics.internal.configuration.WorkflowMetricsConfiguration;
import com.liferay.portal.workflow.metrics.internal.sla.transformer.WorkflowMetricsSLADefinitionTransformer;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.workflow.metrics.internal.configuration.WorkflowMetricsConfiguration"}, service={SchedulerJobConfiguration.class})
public class WorkflowMetricsSLADefinitionTransformerSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowMetricsSLADefinitionTransformerSchedulerJobConfiguration.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;
    private TriggerConfiguration _triggerConfiguration;
    @Reference
    private WorkflowMetricsSLADefinitionTransformer _workflowMetricsSLADefinitionTransformer;

    public UnsafeConsumer<Long, Exception> getCompanyJobExecutorUnsafeConsumer() {
        return companyId -> this._transform((long)companyId);
    }

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> this._companyLocalService.forEachCompanyId(companyId -> this._transform((long)companyId));
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        WorkflowMetricsConfiguration workflowMetricsConfiguration = (WorkflowMetricsConfiguration)ConfigurableUtil.createConfigurable(WorkflowMetricsConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)workflowMetricsConfiguration.checkSLADefinitionsJobInterval(), (TimeUnit)TimeUnit.MINUTE);
    }

    private BooleanQuery _createBooleanQuery(long companyId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)Boolean.TRUE), this._queries.term("companyId", (Object)companyId), this._queries.term("deleted", (Object)Boolean.FALSE)});
    }

    private boolean _hasIndex(long companyId) {
        if (!this._searchCapabilities.isWorkflowMetricsSupported()) {
            return false;
        }
        IndicesExistsIndexRequest indicesExistsIndexRequest = new IndicesExistsIndexRequest(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-processes"});
        IndicesExistsIndexResponse indicesExistsIndexResponse = (IndicesExistsIndexResponse)this._searchEngineAdapter.execute((IndexRequest)indicesExistsIndexRequest);
        return indicesExistsIndexResponse.isExists();
    }

    private void _transform(long companyId) {
        if (!this._hasIndex(companyId)) {
            return;
        }
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-processes"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addFilterQueryClauses(new Query[]{this._createBooleanQuery(companyId)}));
        searchSearchRequest.setSize(Integer.valueOf(GetterUtil.getInteger((String)PropsUtil.get((String)"index.search.limit"), (int)10000)));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            Document document = searchHit.getDocument();
            try {
                this._workflowMetricsSLADefinitionTransformer.transform(document.getLong("companyId"), document.getString("version"), document.getLong("processId"));
            }
            catch (PortalException portalException) {
                _log.error((Throwable)portalException);
            }
        }
    }
}

