/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.model.listener;

import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.TermsQuery;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.workflow.metrics.internal.petra.executor.WorkflowMetricsPortalExecutor;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class UserModelListener
extends BaseModelListener<User> {
    @Reference
    protected SearchEngineAdapter searchEngineAdapter;
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference
    private Queries _queries;
    @Reference
    private Scripts _scripts;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private UserLocalService _userLocalService;
    @Reference
    private WorkflowMetricsPortalExecutor _workflowMetricsPortalExecutor;

    public void onBeforeUpdate(User originalUser, User user) throws ModelListenerException {
        if (!this._searchCapabilities.isWorkflowMetricsSupported()) {
            return;
        }
        User currentUser = this._userLocalService.fetchUserById(user.getUserId());
        TransactionCommitCallbackUtil.registerCallback(() -> {
            if (Objects.equals(currentUser.getFullName(), user.getFullName())) {
                return null;
            }
            this._workflowMetricsPortalExecutor.execute(() -> {
                BooleanQuery nestedBooleanQuery = this._queries.booleanQuery();
                TermsQuery termsQuery = this._queries.terms("tasks.assigneeIds");
                termsQuery.addValues(new Object[]{String.valueOf(user.getUserId())});
                nestedBooleanQuery.addMustQueryClauses(new Query[]{termsQuery});
                nestedBooleanQuery.addMustQueryClauses(new Query[]{this._queries.term("tasks.assigneeType", (Object)User.class.getName())});
                ScriptBuilder scriptBuilder = this._scripts.builder();
                this.searchEngineAdapter.execute((DocumentRequest)new UpdateByQueryDocumentRequest((Query)this._queries.nested("tasks", (Query)nestedBooleanQuery), scriptBuilder.idOrCode(StringUtil.read(((Object)((Object)this)).getClass(), (String)"dependencies/workflow-metrics-update-task-assignee-script.painless")).language("painless").putParameter("userId", (Object)user.getUserId()).putParameter("userName", (Object)user.getFullName()).scriptType(ScriptType.INLINE).build(), new String[]{WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", user.getCompanyId())}));
            });
            return null;
        });
    }
}

