/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.background.task;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.background.task.service.BackgroundTaskLocalService;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.search.background.task.WorkflowMetricsReindexStatusMessageSender;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={WorkflowMetricsSLAProcessBackgroundTaskHelper.class})
public class WorkflowMetricsSLAProcessBackgroundTaskHelper {
    @Reference
    private BackgroundTaskLocalService _backgroundTaskLocalService;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private WorkflowMetricsReindexStatusMessageSender _workflowMetricsReindexStatusMessageSender;
    @Reference
    private WorkflowMetricsSLADefinitionLocalService _workflowMetricsSLADefinitionLocalService;
    @Reference(target="(background.task.executor.class.name=com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor)")
    private BackgroundTaskExecutor _workflowMetricsSLAProcessBackgroundTaskExecutor;

    public void addBackgroundTasks(boolean reindex) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._workflowMetricsSLADefinitionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property statusProperty = PropertyFactoryUtil.forName((String)"status");
            dynamicQuery.add(statusProperty.eq((Object)0));
        });
        long total = actionableDynamicQuery.performCount();
        AtomicInteger atomicCounter = new AtomicInteger(0);
        actionableDynamicQuery.setPerformActionMethod(workflowMetricsSLADefinition -> {
            int count = this._backgroundTaskLocalService.getBackgroundTasksCount(workflowMetricsSLADefinition.getGroupId(), this._getBackgroundTaskName((WorkflowMetricsSLADefinition)workflowMetricsSLADefinition), WorkflowMetricsSLAProcessBackgroundTaskExecutor.class.getName(), false);
            if (count > 0) {
                return;
            }
            HashMap taskContextMap = HashMapBuilder.put((Object)"deleteOnSuccess", (Object)true).put((Object)"reindex", (Object)reindex).put((Object)"workflowMetricsSLADefinitionId", (Object)workflowMetricsSLADefinition.getPrimaryKey()).build();
            this._backgroundTaskLocalService.addBackgroundTask(workflowMetricsSLADefinition.getUserId(), workflowMetricsSLADefinition.getGroupId(), this._getBackgroundTaskName((WorkflowMetricsSLADefinition)workflowMetricsSLADefinition), WorkflowMetricsSLAProcessBackgroundTaskExecutor.class.getName(), (Map)taskContextMap, new ServiceContext());
            if (reindex) {
                this._workflowMetricsReindexStatusMessageSender.sendStatusMessage((long)atomicCounter.incrementAndGet(), total, "sla-instance-result");
            }
        });
        actionableDynamicQuery.performActions();
    }

    private String _getBackgroundTaskName(WorkflowMetricsSLADefinition workflowMetricsSLADefinition) {
        return StringBundler.concat((Object[])new Object[]{WorkflowMetricsSLAProcessBackgroundTaskHelper.class.getSimpleName(), "-", workflowMetricsSLADefinition.getProcessId(), workflowMetricsSLADefinition.getPrimaryKey()});
    }
}

