/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.workflow.metrics.internal.background.task;

import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BaseBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.display.BackgroundTaskDisplay;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.search.capabilities.SearchCapabilities;
import com.liferay.portal.search.document.Document;
import com.liferay.portal.search.engine.adapter.SearchEngineAdapter;
import com.liferay.portal.search.engine.adapter.document.BulkDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.BulkableDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.DocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateByQueryDocumentRequest;
import com.liferay.portal.search.engine.adapter.document.UpdateDocumentRequest;
import com.liferay.portal.search.engine.adapter.search.SearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchRequest;
import com.liferay.portal.search.engine.adapter.search.SearchSearchResponse;
import com.liferay.portal.search.hits.SearchHit;
import com.liferay.portal.search.hits.SearchHits;
import com.liferay.portal.search.index.IndexNameBuilder;
import com.liferay.portal.search.query.BooleanQuery;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.query.Query;
import com.liferay.portal.search.query.RangeTermQuery;
import com.liferay.portal.search.script.ScriptBuilder;
import com.liferay.portal.search.script.ScriptType;
import com.liferay.portal.search.script.Scripts;
import com.liferay.portal.search.sort.Sort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.workflow.metrics.internal.search.index.SLAInstanceResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.SLATaskResultWorkflowMetricsIndexer;
import com.liferay.portal.workflow.metrics.internal.search.index.WorkflowMetricsIndex;
import com.liferay.portal.workflow.metrics.internal.search.index.util.WorkflowMetricsIndexerUtil;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAInstanceResult;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLAProcessor;
import com.liferay.portal.workflow.metrics.internal.sla.processor.WorkflowMetricsSLATaskResult;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinition;
import com.liferay.portal.workflow.metrics.model.WorkflowMetricsSLADefinitionVersion;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionLocalService;
import com.liferay.portal.workflow.metrics.service.WorkflowMetricsSLADefinitionVersionLocalService;
import com.liferay.portal.workflow.metrics.sla.calendar.WorkflowMetricsSLACalendarRegistry;
import com.liferay.portal.workflow.metrics.sla.processor.WorkflowMetricsSLAStatus;
import com.liferay.portal.workflow.metrics.util.comparator.WorkflowMetricsSLADefinitionVersionIdComparator;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"background.task.executor.class.name=com.liferay.portal.workflow.metrics.internal.background.task.WorkflowMetricsSLAProcessBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class WorkflowMetricsSLAProcessBackgroundTaskExecutor
extends BaseBackgroundTaskExecutor {
    private static final Log _log = LogFactoryUtil.getLog(WorkflowMetricsSLAProcessBackgroundTaskExecutor.class);
    private final DateTimeFormatter _dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    @Reference
    private IndexNameBuilder _indexNameBuilder;
    @Reference(target="(module.service.lifecycle=portlets.initialized)")
    private ModuleServiceLifecycle _moduleServiceLifecycle;
    @Reference
    private Queries _queries;
    @Reference
    private Scripts _scripts;
    @Reference
    private SearchCapabilities _searchCapabilities;
    @Reference
    private SearchEngineAdapter _searchEngineAdapter;
    @Reference
    private SLAInstanceResultWorkflowMetricsIndexer _slaInstanceResultWorkflowMetricsIndexer;
    @Reference
    private SLATaskResultWorkflowMetricsIndexer _slaTaskResultWorkflowMetricsIndexer;
    @Reference
    private Sorts _sorts;
    @Reference
    private WorkflowMetricsSLACalendarRegistry _workflowMetricsSLACalendarRegistry;
    @Reference
    private WorkflowMetricsSLADefinitionLocalService _workflowMetricsSLADefinitionLocalService;
    @Reference
    private WorkflowMetricsSLADefinitionVersionLocalService _workflowMetricsSLADefinitionVersionLocalService;
    private final WorkflowMetricsSLAProcessor _workflowMetricsSLAProcessor = new WorkflowMetricsSLAProcessor();

    public BackgroundTaskExecutor clone() {
        return this;
    }

    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        if (!this._searchCapabilities.isWorkflowMetricsSupported()) {
            return BackgroundTaskResult.SUCCESS;
        }
        long workflowMetricsSLADefinitionId = MapUtil.getLong((Map)backgroundTask.getTaskContextMap(), (String)"workflowMetricsSLADefinitionId");
        WorkflowMetricsSLADefinition workflowMetricsSLADefinition = this._workflowMetricsSLADefinitionLocalService.fetchWorkflowMetricsSLADefinition(workflowMetricsSLADefinitionId);
        WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion = this._workflowMetricsSLADefinitionVersionLocalService.getWorkflowMetricsSLADefinitionVersion(workflowMetricsSLADefinitionId, workflowMetricsSLADefinition.getVersion());
        long startNodeId = this._getStartNodeId(workflowMetricsSLADefinition.getCompanyId(), workflowMetricsSLADefinition.getProcessId(), workflowMetricsSLADefinition.getProcessVersion());
        if (workflowMetricsSLADefinitionVersion.isActive()) {
            long nextInstanceId;
            long instanceId = 0L;
            while ((nextInstanceId = this._processInstances(false, null, instanceId, null, startNodeId, workflowMetricsSLADefinitionVersion)) != instanceId) {
                instanceId = nextInstanceId;
            }
        }
        if (MapUtil.getBoolean((Map)backgroundTask.getTaskContextMap(), (String)"reindex")) {
            this._processCompletedInstances(startNodeId, workflowMetricsSLADefinitionId);
        } else {
            long nextInstanceId;
            Date endDate = null;
            if (!workflowMetricsSLADefinitionVersion.isActive()) {
                endDate = workflowMetricsSLADefinitionVersion.getCreateDate();
            }
            long instanceId = 0L;
            while ((nextInstanceId = this._processInstances(true, endDate, instanceId, workflowMetricsSLADefinition.getCreateDate(), startNodeId, workflowMetricsSLADefinitionVersion)) != instanceId) {
                instanceId = nextInstanceId;
            }
        }
        return BackgroundTaskResult.SUCCESS;
    }

    public BackgroundTaskDisplay getBackgroundTaskDisplay(BackgroundTask backgroundTask) {
        return null;
    }

    private BooleanQuery _createBooleanQuery(boolean completed, Date endDate, long instanceId, long processId, long slaDefinitionId, Date startDate) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        if (completed) {
            booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("slaDefinitionIds", (Object)slaDefinitionId)});
        }
        return booleanQuery.addMustQueryClauses(new Query[]{this._createInstancesBooleanQuery(completed, endDate, instanceId, processId, startDate)});
    }

    private BooleanQuery _createInstancesBooleanQuery(boolean completed, Date endDate, long instanceId, long processId, Date startDate) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.term("instanceId", (Object)"0")});
        if (startDate != null) {
            RangeTermQuery rangeTermQuery = this._queries.rangeTerm("completionDate", true, false);
            rangeTermQuery.setLowerBound((Object)this._getDate(startDate));
            if (endDate != null) {
                rangeTermQuery.setUpperBound((Object)this._getDate(endDate));
            }
            booleanQuery.addMustQueryClauses(new Query[]{rangeTermQuery});
        }
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)true), this._queries.term("completed", (Object)completed), this._queries.term("deleted", (Object)false), this._queries.rangeTerm("instanceId", false, false, (Object)instanceId, null), this._queries.term("processId", (Object)processId)});
    }

    private BooleanQuery _createMustNotCompletionDateBooleanQuery() {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        return booleanQuery.addMustNotQueryClauses(new Query[]{this._queries.exists("completionDate")});
    }

    private BooleanQuery _createSLAInstanceResultsBooleanQuery(long endInstanceId, long processId, long slaDefinitionId, long startInstanceId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)true), this._queries.term("blocked", (Object)false), this._queries.term("deleted", (Object)false), this._queries.rangeTerm("instanceId", true, true, (Object)startInstanceId, (Object)endInstanceId), this._queries.term("processId", (Object)processId), this._queries.term("slaDefinitionId", (Object)slaDefinitionId)});
    }

    private BooleanQuery _createTasksBooleanQuery(long endInstanceId, LocalDateTime lastCheckLocalDateTime, long processId, long startInstanceId) {
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        if (lastCheckLocalDateTime != null) {
            booleanQuery.addShouldQueryClauses(new Query[]{this._createMustNotCompletionDateBooleanQuery(), this._queries.dateRangeTerm("completionDate", true, false, this._dateTimeFormatter.format(lastCheckLocalDateTime), null)});
        }
        return booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("active", (Object)true), this._queries.term("deleted", (Object)false), this._queries.rangeTerm("instanceId", true, true, (Object)startInstanceId, (Object)endInstanceId), this._queries.term("processId", (Object)processId)});
    }

    private LocalDateTime _getCompletionLocalDateTime(Document document) {
        if (document.getDate("completionDate") != null) {
            return LocalDateTime.parse(document.getDate("completionDate"), this._dateTimeFormatter);
        }
        return null;
    }

    private String _getDate(Date date) {
        try {
            return DateUtil.getDate((Date)date, (String)"yyyyMMddHHmmss", (Locale)LocaleUtil.getDefault());
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)exception);
            }
            return null;
        }
    }

    private long _getStartNodeId(long companyId, long processId, String version) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-nodes"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addMustQueryClauses(new Query[]{this._queries.term("deleted", (Object)false), this._queries.term("initial", (Object)true), this._queries.term("processId", (Object)processId), this._queries.term("version", (Object)version)}));
        searchSearchRequest.setSelectedFieldNames(new String[]{"nodeId"});
        searchSearchRequest.setSize(Integer.valueOf(1));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        Iterator iterator = searchHits.getSearchHits().iterator();
        if (iterator.hasNext()) {
            SearchHit searchHit = (SearchHit)iterator.next();
            Document document = searchHit.getDocument();
            return GetterUtil.getLong((Object)document.getLong("nodeId"));
        }
        return 0L;
    }

    private Map<Long, WorkflowMetricsSLAInstanceResult> _getWorkflowMetricsSLAInstanceResults(final long companyId, long endInstanceId, final long processId, final long slaDefinitionId, long startInstanceId) {
        HashMap<Long, WorkflowMetricsSLAInstanceResult> workflowMetricsSLAInstanceResults = new HashMap<Long, WorkflowMetricsSLAInstanceResult>();
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-sla-instance-results"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addFilterQueryClauses(new Query[]{this._createSLAInstanceResultsBooleanQuery(endInstanceId, processId, slaDefinitionId, startInstanceId)}));
        searchSearchRequest.setSelectedFieldNames(new String[]{"elapsedTime", "instanceId", "modifiedDate", "onTime", "overdueDate", "remainingTime", "status"});
        searchSearchRequest.setSize(Integer.valueOf(10000));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        for (SearchHit searchHit : searchHits.getSearchHits()) {
            final Document document = searchHit.getDocument();
            WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult = new WorkflowMetricsSLAInstanceResult(){
                {
                    this.setCompanyId(companyId);
                    this.setElapsedTime(document.getLong("elapsedTime"));
                    this.setInstanceId(document.getLong("instanceId"));
                    this.setModifiedLocalDateTime(LocalDateTime.parse(document.getDate("modifiedDate"), WorkflowMetricsSLAProcessBackgroundTaskExecutor.this._dateTimeFormatter));
                    this.setOnTime(GetterUtil.getBoolean((Object)document.getValue("onTime")));
                    this.setOverdueLocalDateTime(LocalDateTime.parse(document.getString("overdueDate"), WorkflowMetricsSLAProcessBackgroundTaskExecutor.this._dateTimeFormatter));
                    this.setProcessId(processId);
                    this.setRemainingTime(document.getLong("remainingTime"));
                    this.setSLADefinitionId(slaDefinitionId);
                    this.setWorkflowMetricsSLAStatus(WorkflowMetricsSLAStatus.valueOf((String)document.getString("status")));
                }
            };
            workflowMetricsSLAInstanceResults.put(workflowMetricsSLAInstanceResult.getInstanceId(), workflowMetricsSLAInstanceResult);
        }
        return workflowMetricsSLAInstanceResults;
    }

    private long _populateTaskDocuments(long companyId, long endInstanceId, LocalDateTime lastCheckLocalDateTime, long processId, long startInstanceId, Map<Long, List<Document>> taskDocuments) {
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.addSorts(new Sort[]{this._sorts.field("instanceId", SortOrder.ASC)});
        searchSearchRequest.setIndexNames(new String[]{this._indexNameBuilder.getIndexName(companyId) + "-workflow-metrics-tasks"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addFilterQueryClauses(new Query[]{this._createTasksBooleanQuery(endInstanceId, lastCheckLocalDateTime, processId, startInstanceId)}));
        searchSearchRequest.setSelectedFieldNames(new String[]{"assigneeIds", "assigneeType", "completed", "completionDate", "completionUserId", "createDate", "instanceId", "name", "nodeId", "taskId"});
        searchSearchRequest.setSize(Integer.valueOf(10000));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        List instanceIds = TransformUtil.transform((Collection)searchHits.getSearchHits(), searchHit -> {
            Document document = searchHit.getDocument();
            List documents = taskDocuments.computeIfAbsent(document.getLong("instanceId"), key -> new ArrayList());
            documents.add(document);
            documents.sort(Comparator.comparing(curDocument -> LocalDateTime.parse(curDocument.getDate("createDate"), this._dateTimeFormatter)));
            return document.getLong("instanceId");
        });
        if (instanceIds.isEmpty()) {
            return startInstanceId;
        }
        if (searchHits.getTotalHits() >= 10000L) {
            return (Long)Collections.max(instanceIds);
        }
        return startInstanceId;
    }

    private void _processCompletedInstances(long startNodeId, long workflowMetricsSLADefinitionId) {
        List workflowMetricsSLADefinitionVersions = this._workflowMetricsSLADefinitionVersionLocalService.getWorkflowMetricsSLADefinitionVersions(workflowMetricsSLADefinitionId, (OrderByComparator)WorkflowMetricsSLADefinitionVersionIdComparator.getInstance((boolean)true));
        Iterator iterator = workflowMetricsSLADefinitionVersions.iterator();
        WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion = (WorkflowMetricsSLADefinitionVersion)iterator.next();
        Date startDate = workflowMetricsSLADefinitionVersion.getCreateDate();
        while (startDate != null) {
            Date endDate = null;
            WorkflowMetricsSLADefinitionVersion nextWorkflowMetricsSLADefinitionVersion = null;
            if (iterator.hasNext()) {
                nextWorkflowMetricsSLADefinitionVersion = (WorkflowMetricsSLADefinitionVersion)iterator.next();
                endDate = nextWorkflowMetricsSLADefinitionVersion.getCreateDate();
            }
            if (workflowMetricsSLADefinitionVersion.isActive()) {
                long nextInstanceId;
                long instanceId = 0L;
                while ((nextInstanceId = this._processInstances(true, endDate, instanceId, startDate, startNodeId, workflowMetricsSLADefinitionVersion)) != instanceId) {
                    instanceId = nextInstanceId;
                }
            }
            startDate = endDate;
            workflowMetricsSLADefinitionVersion = nextWorkflowMetricsSLADefinitionVersion;
        }
    }

    private long _processInstances(boolean completed, Date endDate, long instanceId, Date startDate, long startNodeId, WorkflowMetricsSLADefinitionVersion workflowMetricsSLADefinitionVersion) {
        long nextInstanceId;
        SearchSearchRequest searchSearchRequest = new SearchSearchRequest();
        searchSearchRequest.addSorts(new Sort[]{this._sorts.field("instanceId", SortOrder.ASC)});
        String indexName = this._indexNameBuilder.getIndexName(workflowMetricsSLADefinitionVersion.getCompanyId());
        searchSearchRequest.setIndexNames(new String[]{indexName + "-workflow-metrics-instances"});
        BooleanQuery booleanQuery = this._queries.booleanQuery();
        searchSearchRequest.setQuery((Query)booleanQuery.addFilterQueryClauses(new Query[]{this._createBooleanQuery(completed, endDate, instanceId, workflowMetricsSLADefinitionVersion.getProcessId(), workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId(), startDate)}));
        searchSearchRequest.setSelectedFieldNames(new String[]{"completionDate", "createDate", "instanceId"});
        searchSearchRequest.setSize(Integer.valueOf(10000));
        SearchSearchResponse searchSearchResponse = (SearchSearchResponse)this._searchEngineAdapter.execute((SearchRequest)searchSearchRequest);
        SearchHits searchHits = searchSearchResponse.getSearchHits();
        List instanceDocuments = TransformUtil.transform((Collection)searchHits.getSearchHits(), SearchHit::getDocument);
        if (instanceDocuments.isEmpty()) {
            return instanceId;
        }
        Document firstInstanceDocument = (Document)instanceDocuments.get(0);
        Document lastInstanceDocument = (Document)instanceDocuments.get(instanceDocuments.size() - 1);
        Map<Long, WorkflowMetricsSLAInstanceResult> workflowMetricsSLAInstanceResults = this._getWorkflowMetricsSLAInstanceResults(workflowMetricsSLADefinitionVersion.getCompanyId(), lastInstanceDocument.getLong("instanceId"), workflowMetricsSLADefinitionVersion.getProcessId(), workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId(), firstInstanceDocument.getLong("instanceId"));
        LocalDateTime nowLocalDateTime = LocalDateTime.now();
        HashMap<Long, List<Document>> taskDocuments = new HashMap<Long, List<Document>>();
        long firstInstanceId = firstInstanceDocument.getLong("instanceId");
        while ((nextInstanceId = this._populateTaskDocuments(workflowMetricsSLADefinitionVersion.getCompanyId(), lastInstanceDocument.getLong("instanceId"), nowLocalDateTime, workflowMetricsSLADefinitionVersion.getProcessId(), firstInstanceId, taskDocuments)) != firstInstanceId) {
            firstInstanceId = nextInstanceId;
        }
        BulkDocumentRequest bulkDocumentRequest = new BulkDocumentRequest();
        ArrayList<Document> slaInstanceResultDocuments = new ArrayList<Document>();
        ArrayList<Document> slaTaskResultDocuments = new ArrayList<Document>();
        for (Document document : instanceDocuments) {
            WorkflowMetricsSLAInstanceResult workflowMetricsSLAInstanceResult = this._workflowMetricsSLAProcessor.process(this._getCompletionLocalDateTime(document), LocalDateTime.parse(document.getDate("createDate"), this._dateTimeFormatter), (List)taskDocuments.get(document.getLong("instanceId")), document.getLong("instanceId"), nowLocalDateTime, startNodeId, this._workflowMetricsSLACalendarRegistry, workflowMetricsSLADefinitionVersion, workflowMetricsSLAInstanceResults.get(document.getLong("instanceId")));
            if (workflowMetricsSLAInstanceResult == null) continue;
            slaInstanceResultDocuments.add(this._slaInstanceResultWorkflowMetricsIndexer.createDocument(workflowMetricsSLAInstanceResult));
            for (WorkflowMetricsSLATaskResult workflowMetricsSLATaskResult : workflowMetricsSLAInstanceResult.getWorkflowMetricsSLATaskResults()) {
                slaTaskResultDocuments.add(this._slaTaskResultWorkflowMetricsIndexer.createDocument(workflowMetricsSLATaskResult));
            }
            ScriptBuilder scriptBuilder = this._scripts.builder();
            bulkDocumentRequest.addBulkableDocumentRequest((BulkableDocumentRequest)new UpdateDocumentRequest(WorkflowMetricsIndex.getIndexName(this._indexNameBuilder, "-workflow-metrics-instances", workflowMetricsSLAInstanceResult.getCompanyId()), WorkflowMetricsIndexerUtil.digest("WorkflowMetricsInstanceType", Long.valueOf(workflowMetricsSLAInstanceResult.getCompanyId()), Long.valueOf(workflowMetricsSLAInstanceResult.getInstanceId())), scriptBuilder.idOrCode(StringUtil.read(((Object)((Object)this)).getClass(), (String)"dependencies/workflow-metrics-update-sla-instance-script.painless")).language("painless").putParameter("slaResult", (Object)HashMapBuilder.put((Object)"onTime", (Object)workflowMetricsSLAInstanceResult.isOnTime()).put((Object)"overdueDate", (Object)this._dateTimeFormatter.format(workflowMetricsSLAInstanceResult.getOverdueLocalDateTime())).put((Object)"remainingTime", (Object)workflowMetricsSLAInstanceResult.getRemainingTime()).put((Object)"slaDefinitionId", (Object)workflowMetricsSLAInstanceResult.getSLADefinitionId()).put((Object)"status", () -> {
                WorkflowMetricsSLAStatus workflowMetricsSLAStatus = workflowMetricsSLAInstanceResult.getWorkflowMetricsSLAStatus();
                return workflowMetricsSLAStatus.name();
            }).build()).scriptType(ScriptType.INLINE).build()));
        }
        this._slaInstanceResultWorkflowMetricsIndexer.addDocuments(slaInstanceResultDocuments);
        this._slaTaskResultWorkflowMetricsIndexer.addDocuments(slaTaskResultDocuments);
        if (ListUtil.isNotEmpty((List)bulkDocumentRequest.getBulkableDocumentRequests())) {
            this._searchEngineAdapter.execute((DocumentRequest)bulkDocumentRequest);
        }
        if (completed) {
            this._updateInstances(workflowMetricsSLADefinitionVersion.getCompanyId(), lastInstanceDocument.getLong("instanceId"), workflowMetricsSLADefinitionVersion.getWorkflowMetricsSLADefinitionId(), firstInstanceDocument.getLong("instanceId"));
        }
        if (searchHits.getTotalHits() >= 10000L) {
            return lastInstanceDocument.getLong("instanceId");
        }
        return instanceId;
    }

    private void _updateInstances(long companyId, long endInstanceId, long slaDefinitionId, long startInstanceId) {
        String indexName = this._indexNameBuilder.getIndexName(companyId);
        UpdateByQueryDocumentRequest updateByQueryDocumentRequest = new UpdateByQueryDocumentRequest((Query)this._queries.rangeTerm("instanceId", true, true, (Object)startInstanceId, (Object)endInstanceId), this._scripts.script(StringBundler.concat((Object[])new Object[]{"if (!ctx._source.containsKey('slaDefinitionIds')) ", "ctx._source['slaDefinitionIds'] = [];", "ctx._source.slaDefinitionIds.add(", slaDefinitionId, ")"})), new String[]{indexName + "-workflow-metrics-instances"});
        if (PortalRunMode.isTestMode()) {
            updateByQueryDocumentRequest.setRefresh(true);
        }
        this._searchEngineAdapter.execute((DocumentRequest)updateByQueryDocumentRequest);
    }
}

